/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.EffectiveProjectFolderReaders;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class ProjectFoldersController
extends DIPInternalControllerBase {
    public static final String BASE_PATH_URI = "/api/project-folders";
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private InterestsInternalDB interestsInternalDB;

    @AuditedCall(value={"msgType", "folder-project-create"})
    @RequestMapping(value={"/api/project-folders/create"}, method={RequestMethod.POST})
    @ResponseBody
    public ProjectFolder create(HttpServletRequest req, @RequestParam String folderId, @RequestParam String name) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ProjectFolder created = this.projectFoldersService.createFolder_Check(authCtx, folderId, name);
            t.commitV("Created a new folder: %s", new Object[]{name});
            ProjectFolder projectFolder = created;
            return projectFolder;
        }
    }

    @AuditedCall(value={"msgType", "folder-project-delete"})
    @RequestMapping(value={"/api/project-folders/delete"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(HttpServletRequest req, @RequestParam List<String> folderIds, @RequestParam String destination) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            boolean movedSomething = false;
            for (String folderId : folderIds) {
                movedSomething = this.projectFoldersService.moveContent_Check(authCtx, folderId, destination) || movedSomething;
                this.projectFoldersService.deleteFolder_Check(authCtx, folderId);
            }
            StringBuilder builder = new StringBuilder("Deleted ");
            builder.append(folderIds.size());
            builder.append(" folder" + (folderIds.size() != 1 ? "s" : ""));
            if (movedSomething) {
                builder.append(" and the content moved to ");
                ProjectFolder destinationFolder = this.projectFoldersService.getMandatoryUnsafe_Uncheck(destination);
                boolean destinationIsRoot = this.projectFoldersService.isProjectFolderRoot(destinationFolder.id);
                builder.append(destinationIsRoot ? "root project folder" : destinationFolder.name);
            }
            t.commit(builder.toString());
        }
        for (String folderId : folderIds) {
            this.interestsInternalDB.deleteForFolder(folderId);
        }
    }

    @AuditedCall(value={"msgType", "folder-project-move-items"})
    @RequestMapping(value={"/api/project-folders/move-items"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void moveItems(HttpServletRequest req, @RequestParam String destination, @RequestParam List<String> folderIds, @RequestParam List<String> projectKeys) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (String folderId : folderIds) {
                this.projectFoldersService.moveFolder_Check(authCtx, folderId, destination);
            }
            this.projectFoldersService.moveProjects_Check(authCtx, destination, Sets.newHashSet(projectKeys));
            ProjectFolder destinationFolder = this.projectFoldersService.getMandatoryUnsafe_Uncheck(destination);
            boolean destinationIsRoot = this.projectFoldersService.isProjectFolderRoot(destinationFolder.id);
            StringBuilder builder = new StringBuilder("Moved ");
            if (!projectKeys.isEmpty()) {
                builder.append(projectKeys.size());
                builder.append(" project" + (projectKeys.size() > 1 ? "s " : " "));
            }
            if (!folderIds.isEmpty()) {
                if (!projectKeys.isEmpty()) {
                    builder.append("and ");
                }
                builder.append(folderIds.size());
                builder.append(" folder" + (folderIds.size() > 1 ? "s " : " "));
            }
            builder.append("into ");
            builder.append(destinationIsRoot ? "root project folder" : destinationFolder.name);
            t.commit(builder.toString());
        }
    }

    @AuditedCall(value={"msgType", "folder-project-settings-get"})
    @RequestMapping(value={"/api/project-folders/{folderId}/settings"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFoldersService.ProjectFolderSettings getFolderSettings(HttpServletRequest req, @PathVariable String folderId) throws IOException, DKUSecurityException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ProjectFoldersService.ProjectFolderSettings projectFolderSettings = this.projectFoldersService.getProjectFolderSettingsMandatoryUnsafe_Check(authCtx, folderId);
            return projectFolderSettings;
        }
    }

    @AuditedCall(value={"msgType", "folder-project-settings-update"})
    @RequestMapping(value={"/api/project-folders/{folderId}/settings"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateFolderSettings(HttpServletRequest req, @PathVariable String folderId, @RequestParam ProjectFoldersService.ProjectFolderSettings projectFolderSettings) throws IOException, DKUSecurityException {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectFoldersService.saveProjectFolder_Check(authCtx, folderId, projectFolderSettings);
            t.commitV("Updated the settings of folder %s", new Object[]{folderId});
        }
    }

    @AuditedCall(value={"msgType", "folder-project-list-root-contents"})
    @RequestMapping(value={"/api/project-folders/list-contents"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFolderContents listRootContents(HttpServletRequest req, @RequestParam boolean lightMode, @RequestParam(required=false, defaultValue="-1") int maxLevel, @RequestParam(required=false, defaultValue="true") boolean withTagsFile, @RequestParam(required=false, defaultValue="false") boolean withGitInfo, @RequestParam(required=false, defaultValue="false") boolean includeLimitedVisibility) throws Exception {
        AuthCtx authCtx;
        this.projectFoldersService.cleanUpProjectFolders_NT(false);
        HashMap<String, List<Scenario>> scenariosMap = new HashMap<String, List<Scenario>>();
        ProjectFolderContents contents = new ProjectFolderContents();
        ProjectFoldersService.ProjectFolderSummaryOptions options = new ProjectFoldersService.ProjectFolderSummaryOptions();
        options.maxChildrenDepth = maxLevel;
        options.includeLimitedVisibility = includeLimitedVisibility;
        options.retrieveProjects = true;
        options.retrieveAncestry = true;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            contents.folder = this.projectFoldersService.getProjectFolderSummaryMandatoryUnsafe_Check(authCtx, null, new HashMap<String, List<String>>(), options);
            for (ProjectsService.HomepageProjectItem projectItem : this.projectsService.listAccessibleUnsafeExtended(authCtx, lightMode, withTagsFile, includeLimitedVisibility)) {
                if (!projectItem.onlyLimitedVisibility && !lightMode) {
                    scenariosMap.put(projectItem.projectKey, this.scenariosDAO.listUnsafe(projectItem.projectKey));
                }
                contents.projects.add(projectItem);
            }
        }
        for (ProjectsService.HomepageProjectItem prj : contents.projects) {
            this.projectsService.enrichHomepageProjectItem_NT(prj, authCtx, lightMode, withGitInfo, scenariosMap);
        }
        return contents;
    }

    @AuditedCall(value={"msgType", "folder-project-summary-get"})
    @RequestMapping(value={"/api/project-folders/{folderId}/summary"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFoldersService.ProjectFolderSummary getSummary(HttpServletRequest req, @PathVariable String folderId, @RequestParam(required=false, defaultValue="1") int maxLevel, @RequestParam(required=false, defaultValue="false") boolean includeAncestry, @RequestParam(required=false, defaultValue="false") boolean includeProjectKeys) throws Exception {
        ProjectFoldersService.ProjectFolderSummaryOptions options = new ProjectFoldersService.ProjectFolderSummaryOptions();
        options.maxChildrenDepth = maxLevel;
        options.includeLimitedVisibility = false;
        options.retrieveProjects = includeProjectKeys;
        options.retrieveAncestry = includeAncestry;
        if ("ROOT".equals(folderId)) {
            this.projectFoldersService.cleanUpProjectFolders_NT(false);
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ProjectFoldersService.ProjectFolderSummary projectFolderSummary = this.projectFoldersService.getProjectFolderSummaryMandatoryUnsafe_Check(authCtx, folderId, new HashMap<String, List<String>>(), options);
            return projectFolderSummary;
        }
    }

    @AuditedCall(value={"msgType", "folder-project-default-summary-get"})
    @RequestMapping(value={"/api/project-folders/{contextFolderId}/default-folder-summary"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFoldersService.ProjectFolderSummary defaultFolder(HttpServletRequest req, @PathVariable String contextFolderId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.projectFoldersService.getDefaultProjectFolderSummary_Unsafe_NT(authCtx, contextFolderId);
    }

    @AuditedCall(value={"msgType", "folder-project-list-contents"})
    @RequestMapping(value={"/api/project-folders/{folderId}/list-contents"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectFolderContents listContents(HttpServletRequest req, @PathVariable String folderId, @RequestParam boolean lightMode, @RequestParam(required=false, defaultValue="-1") int maxLevel, @RequestParam(required=false, defaultValue="true") boolean withTagsFile, @RequestParam(required=false, defaultValue="false") boolean withGitInfo, @RequestParam(required=false, defaultValue="false") boolean includeLimitedVisibility) throws Exception {
        AuthCtx authCtx;
        HashMap<String, List<Scenario>> scenariosMap = new HashMap<String, List<Scenario>>();
        ProjectFolderContents contents = new ProjectFolderContents();
        ProjectFoldersService.ProjectFolderSummaryOptions options = new ProjectFoldersService.ProjectFolderSummaryOptions();
        options.maxChildrenDepth = maxLevel;
        options.includeLimitedVisibility = includeLimitedVisibility;
        options.retrieveProjects = true;
        options.retrieveAncestry = true;
        try (Transaction ignored = this.transactionService.beginRead();){
            ProjectFoldersService.ProjectFolderSummary pfs;
            authCtx = this.authService.getMandatoryUser(req);
            contents.folder = this.projectFoldersService.getProjectFolderSummaryMandatoryUnsafe_Check(authCtx, folderId, new HashMap<String, List<String>>(), options);
            HashSet<String> pkeys = new HashSet<String>();
            LinkedList<ProjectFoldersService.ProjectFolderSummary> pfsList = new LinkedList<ProjectFoldersService.ProjectFolderSummary>();
            pfsList.push(contents.folder);
            while ((pfs = (ProjectFoldersService.ProjectFolderSummary)pfsList.poll()) != null) {
                pkeys.addAll(pfs.projectKeys);
                pfsList.addAll(pfs.children);
            }
            for (ProjectsService.HomepageProjectItem projectItem : this.projectsService.getProjectItemsWithPermissionChecksFromProjectKeys(authCtx, pkeys, lightMode, withTagsFile, includeLimitedVisibility)) {
                if (!projectItem.onlyLimitedVisibility && !lightMode) {
                    scenariosMap.put(projectItem.projectKey, this.scenariosDAO.listUnsafe(projectItem.projectKey));
                }
                contents.projects.add(projectItem);
            }
        }
        for (ProjectsService.HomepageProjectItem prj : contents.projects) {
            this.projectsService.enrichHomepageProjectItem_NT(prj, authCtx, lightMode, withGitInfo, scenariosMap);
        }
        return contents;
    }

    @AuditedCall(value={"msgType", "folder-project-list-readers"})
    @RequestMapping(value={"/api/project-folders/{folderId}/list-readers"}, method={RequestMethod.GET})
    @ResponseBody
    public EffectiveProjectFolderReaders listReaders(HttpServletRequest req, @PathVariable String folderId) throws Exception {
        EffectiveProjectFolderReaders readers;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            readers = this.projectFoldersService.getEffectiveReaders_Check(authCtx, folderId);
        }
        return readers;
    }

    @AuditedCall(value={"msgType", "folder-project-list"})
    @RequestMapping(value={"/api/project-folders/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectFolderContents> list(HttpServletRequest req) throws Exception {
        ArrayList<ProjectFolderContents> contents = new ArrayList<ProjectFolderContents>();
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            List<ProjectFoldersService.ProjectFolderSummary> summaries = this.projectFoldersService.listAll_Check(authCtx);
            boolean lightMode = true;
            boolean withTagsFile = false;
            for (ProjectFoldersService.ProjectFolderSummary summary : summaries) {
                ProjectFolderContents projectFolderContent = new ProjectFolderContents();
                projectFolderContent.folder = summary;
                for (String pkey : summary.projectKeys) {
                    SerializedProject project = this.projectsService.getMandatoryUnsafe(pkey);
                    ProjectsService.HomepageProjectItem projectItem = this.projectsService.getProjectItemWithPermissionChecksFromProject(authCtx, project, true, false);
                    if (projectItem == null) continue;
                    projectFolderContent.projects.add(projectItem);
                }
                this.cleanupUselessProjectKeysFromParent(summary);
                contents.add(projectFolderContent);
            }
        }
        return contents;
    }

    private void cleanupUselessProjectKeysFromParent(ProjectFoldersService.ProjectFolderSummary psum) {
        if (psum.parent != null) {
            psum.parent.projectKeys = null;
            this.cleanupUselessProjectKeysFromParent(psum.parent);
        }
    }

    @UIModel
    public static class ProjectFolderContents {
        public ProjectFoldersService.ProjectFolderSummary folder;
        public List<ProjectsService.HomepageProjectItem> projects = new ArrayList<ProjectsService.HomepageProjectItem>();
    }
}

