/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.ClusteringService;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLSparkParams;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesService;
import com.dataiku.dip.analysis.ml.clustering.guess.ClusteringGuessPolicy;
import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.GuessStatus;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.analysis.SavedModelsController;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AnalysisClusteringController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private ClusteringService clusteringService;
    @Autowired
    private ClusteringRecipesService recipesService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private MLBaseService mlBaseService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private static Logger logger = Logger.getLogger((String)"dku.analysis");

    @AuditedCall(value={"msgType", "analysis-clustering-task-create", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/cml/create-and-guess"})
    public void createAndGuessClustering(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam MLTask.BackendType mlBackendType, @RequestParam String mlBackendName, @RequestParam(required=false) Boolean useGlobalMetastore, @RequestParam ClusteringGuessPolicy guessPolicy) throws Exception {
        MLSparkParams sparkParams;
        AuthCtx u = null;
        AnalysisCoreParams acp = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            if (mlBackendType == null) {
                throw ErrorContext.iae((String)"Invalid ML Backend type");
            }
            if (mlBackendType.isSparkBased()) {
                SparkSettings sparkSettings = new ClusterSelector().selectForProject(u, projectKey).getSparkSettings();
                if (StringUtils.isBlank((String)mlBackendName)) {
                    mlBackendName = sparkSettings.getDefault().name;
                }
                sparkSettings.getByName(mlBackendName);
                sparkParams = RecipeCreationUtils.setupMLSparkParams(u, projectKey, mlBackendName, useGlobalMetastore);
            } else {
                sparkParams = null;
            }
        }
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)new Id(this.clusteringService.createAndGuess_NT(u, acp, mlBackendType, sparkParams, guessPolicy)));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/cml/get-model-snippets"})
    public void getCMLTaskSnippets(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam(required=false) String[] fullModelIds) throws Exception {
        List<FullModelId> fullModelIdList;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (fullModelIds == null || fullModelIds.length == 0) {
            fullModelIdList = this.clusteringService.listTaskModelIds(loc);
        } else {
            fullModelIdList = new ArrayList<FullModelId>();
            for (String fmi : fullModelIds) {
                fullModelIdList.add(FullModelId.parse(fmi));
            }
        }
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, this.clusteringService.getSnippets_NT(fullModelIdList));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/cml/get-mltask-status"})
    public void getPMLTaskStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)this.clusteringService.getMLTaskStatus_NT(loc));
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-get-settings", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "sessionId", "${sessionId}"})
    @RequestMapping(value={"/api/analysis/cml/get-session-task"})
    public void getSessionSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String sessionId) throws Exception {
        ClusteringMLTask task;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            task = this.analysisCRUDService.getCMLSessionTask(loc, sessionId, true);
        }
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)task);
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-get-settings", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/cml/get-updated-settings"})
    public void getCMLUpdatedSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        ClusteringMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getCMLTask(loc);
        }
        boolean changed = this.clusteringService.update_NT(u, acp, loc, task);
        logger.info((Object)("CHANGED " + changed));
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)task);
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-reguess", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/cml/reguess"})
    public void reguess(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        ClusteringMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getCMLTask(loc);
        }
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)this.clusteringService.reguess_NT(u, acp, loc, task));
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-change-guess-policy", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "newPolicyId", "${newPolicyId}"})
    @RequestMapping(value={"/api/analysis/cml/change-guess-policy"})
    public void changeGuessPolicy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String newPolicyId) throws Exception {
        ClusteringMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-guessing");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getCMLTask(loc);
        }
        this.clusteringService.changeGuessPolicy(u, acp, loc, task, ClusteringGuessPolicy.valueOf(newPolicyId));
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)task);
    }

    @AuditedCall(value={"msgType", "analysis-cmltask-duplicate", "projectKeyFrom", "${projectKeyFrom}", "analysisIdFrom", "${analysisIdFrom}", "mlTaskIdFrom", "${mlTaskIdFrom}", "projectKeyTo", "${projectKeyTo}", "analysisIdTo", "${analysisIdTo}"})
    @RequestMapping(value={"/api/analysis/cml/duplicate"})
    public void duplicateTask(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKeyFrom, @RequestParam String analysisIdFrom, @RequestParam String mlTaskIdFrom, @RequestParam String projectKeyTo, @RequestParam String analysisIdTo) throws Exception {
        AnalysisCoreParams acp;
        ClusteringMLTask task;
        AuthCtx user;
        MLTaskLoc loc = new MLTaskLoc(projectKeyFrom, analysisIdFrom, mlTaskIdFrom);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKeyFrom, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.projectsService.checkPerm(req, projectKeyTo, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
            task = this.analysisCRUDService.getCMLTask(loc);
            acp = this.analysisCRUDService.getCoreMandatory(projectKeyTo, analysisIdTo);
        }
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)new Id(this.clusteringService.duplicate(acp, user, loc, task)));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/cml/get-pretrain-status"})
    public void getPretrainStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        AuthCtx user;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AnalysisCoreParams acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            this.clusteringService.checkSourceDatasetPermissions(user, acp, loc);
        }
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)this.clusteringService.getPreTrainStatus_NT(loc, user));
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-set-settings", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/cml/save-settings"})
    public void saveSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTask) throws Exception {
        logger.debug((Object)("FOUND ML TASK : " + mlTask));
        ClusteringMLTask taskObj = (ClusteringMLTask)JSON.parse((String)mlTask, ClusteringMLTask.class);
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, taskObj.id);
        GuessStatus updated = new GuessStatus();
        updated.state = GuessStatus.GuessState.OK;
        loc.writeGuessStatus(updated);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.analysisCRUDService.saveMLTask(loc, taskObj, true);
            t.commit("Saved ML Task settings in " + projectKey + "." + analysisId + " (task:" + taskObj.id + ")");
        }
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-train", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/cml/train-start"})
    public void trainStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam(required=false) Boolean forceRefresh, @RequestParam(required=false) String userSessionName, @RequestParam(required=false) String userSessionDescription, @RequestParam(defaultValue="false") Boolean runQueue) throws Exception {
        ClusteringMLTask task;
        AuthCtx user;
        AnalysisCoreParams acp;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkVisualMLAllowed(user);
            task = this.analysisCRUDService.getCMLTask(loc);
        }
        if (forceRefresh != null && forceRefresh.booleanValue()) {
            t = this.transactionService.beginWriteForUI(req);
            try {
                ++task.sampling.instanceIdRefresher;
                this.analysisCRUDService.saveMLTask(loc, task, true);
                t.commit("Saved settings of ML task " + task.id + " in " + projectKey + "." + analysisId);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        this.clusteringService.trainStart_NT(user, acp, loc, task, userSessionName, userSessionDescription, runQueue);
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-retrain", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/cml/retrain-start"})
    public void retrainStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String sessionId, @RequestParam(required=false) String[] fullModelIds) throws Exception {
        ClusteringMLTask task;
        AuthCtx user;
        AnalysisCoreParams acp;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkVisualMLAllowed(user);
            this.clusteringService.checkSourceDatasetPermissions(user, acp, loc);
            task = this.analysisCRUDService.getCMLSessionTask(loc, sessionId, false);
        }
        this.clusteringService.retrainStart_NT(user, acp, loc, sessionId, task, fullModelIds);
    }

    @AuditedCall(value={"msgType", "analysis-clustering-enqueue-session", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/cml/enqueue-session"})
    public void enqueueSession(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam(required=false) boolean pauseQueue, @RequestParam(required=false) String userSessionName, @RequestParam(required=false) String userSessionDescription, @RequestParam(required=false) Boolean forceRefresh) throws Exception {
        ClusteringMLTask task;
        AuthCtx user;
        AnalysisCoreParams acp;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before training");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkVisualMLAllowed(user);
            this.clusteringService.checkSourceDatasetPermissions(user, acp, loc);
            task = this.analysisCRUDService.getCMLTask(loc);
        }
        this.clusteringService.enqueueSession(user, acp, loc, task, pauseQueue, userSessionName, userSessionDescription, forceRefresh);
    }

    @AuditedCall(value={"msgType", "analysis-clustering-resume-queue-sessions", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/cml/train-queue"})
    public void trainQueue(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        AnalysisCoreParams acp;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before training");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkVisualMLAllowed(user);
            this.clusteringService.checkSourceDatasetPermissions(user, acp, loc);
        }
        this.clusteringService.trainQueue(acp, loc);
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-deploy", "modelId", "${fullModelId}", "datasetRef", "${inputDatasetSmartName}"})
    @RequestMapping(value={"/api/analysis/cml/flow/deploy-train"})
    public void deployTrain(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String inputDatasetSmartName, @RequestParam String modelName) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        AuthCtx user = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
        }
        DatasetLocUtils.DatasetLoc trainLoc = DatasetLocUtils.resolveSmart(projectKey, inputDatasetSmartName);
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, this.recipesService.createTrainingRecipePrep_NT(user, fmi, trainLoc, modelName));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/cml/flow/list-redeployable-train"})
    public void redeployableTrainPrepare(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            MLTask mlTask = fmi.getHeadMLTask();
            assert (mlTask.taskType.equals((Object)MLTask.MLTaskType.CLUSTERING));
            Map<SerializedRecipe, SavedModel> models = this.recipesService.listUpdatableTrain(projectKey, mlTask.backendType);
            ArrayList<SavedModelsController.ReplaceableSavedModel> results = new ArrayList<SavedModelsController.ReplaceableSavedModel>(models.size());
            for (SerializedRecipe recipe : models.keySet()) {
                SavedModelsController.ReplaceableSavedModel rsm = new SavedModelsController.ReplaceableSavedModel();
                rsm.inputDatasetName = recipe.getSingleInput((String)"main").ref;
                rsm.recipeName = recipe.name;
                rsm.savedModel = models.get(recipe);
                results.add(rsm);
            }
            AnalysisClusteringController.writeJSON((HttpServletResponse)resp, results);
        }
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-redeploy", "modelId", "${fullModelId}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/api/analysis/cml/flow/redeploy-train"})
    public void redeployTrain(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String recipeName, @RequestParam boolean activate) throws Exception {
        SerializedRecipe recipe;
        AuthCtx user;
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
            recipe = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, recipeName);
        }
        boolean schemaChanged = this.recipesService.updateTrainingRecipePrep_NT(user, fmi, recipe, activate);
        AnalysisClusteringController.writeJSONString((HttpServletResponse)resp, (String)("{\"schemaChanged\":" + schemaChanged + "}"));
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-deploy", "modelId", "${fullModelId}", "datasetRef", "${inputDatasetSmartName}"})
    @RequestMapping(value={"/api/analysis/cml/flow/deploy-cluster"})
    public void deployCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String inputDatasetSmartName, @RequestParam String outputDatasetName, @RequestParam String outputDatasetSettings) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        AuthCtx user = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
        }
        DatasetLocUtils.DatasetLoc trainLoc = DatasetLocUtils.resolveSmart(projectKey, inputDatasetSmartName);
        String recipeName = this.recipesService.createClusterRecipe_NT(user, fmi, trainLoc, outputDatasetName, (ManagedDatasetsCreationService.ManagedDatasetCreationSettings)JSON.parse((String)outputDatasetSettings, ManagedDatasetsCreationService.ManagedDatasetCreationSettings.class));
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)new Id(recipeName));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/cml/flow/list-redeployable-cluster"})
    public void redeployableCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            MLTask mlTask = fmi.getHeadMLTask();
            assert (mlTask.taskType.equals((Object)MLTask.MLTaskType.CLUSTERING));
            List<SerializedRecipe> recipes = this.recipesService.listUpdatableCluster(projectKey, mlTask.backendType);
            ArrayList<SavedModelsController.ReplaceableSavedModel> results = new ArrayList<SavedModelsController.ReplaceableSavedModel>(recipes.size());
            for (SerializedRecipe recipe : recipes) {
                SavedModelsController.ReplaceableSavedModel rsm = new SavedModelsController.ReplaceableSavedModel();
                rsm.inputDatasetName = recipe.getSingleInput((String)"main").ref;
                rsm.outputDatasetName = recipe.getSingleOutput((String)"main").ref;
                rsm.recipeName = recipe.name;
                rsm.savedModel = null;
                results.add(rsm);
            }
            AnalysisClusteringController.writeJSON((HttpServletResponse)resp, results);
        }
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-redeploy", "modelId", "${fullModelId}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/api/analysis/cml/flow/redeploy-cluster"})
    public void redeployCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String recipeName) throws Exception {
        SerializedRecipe recipe;
        AuthCtx user;
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
            recipe = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, recipeName);
        }
        boolean schemaChanged = this.recipesService.updateClusterRecipe_NT(user, fmi, recipe);
        AnalysisClusteringController.writeJSONString((HttpServletResponse)resp, (String)("{\"schemaChanged\":" + schemaChanged + "}"));
    }

    @AuditedCall(value={"msgType", "analysis-clustering-task-deploy-notebook", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/analysis/cml/create-notebook"})
    public void deployNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String notebookTitle) throws Exception {
        Callable<ClusteringService.NotebookToSave> nbkFuture;
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            nbkFuture = this.clusteringService.createJupyterNotebook(fmi, notebookTitle, authCtx);
        }
        ClusteringService.NotebookToSave nbk = nbkFuture.call();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            t.writeStringUTF8(nbk.newNotebookFile, nbk.jsonContent);
            t.commit("Created a Jupyter notebook from model " + fullModelId);
            AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)new Id(nbk.transmogrifiedTitle));
        }
    }

    @AuditedCall(value={"msgType", "analysis-ml-copy-algo", "projectKeyFrom", "${projectKeyFrom}", "analysisIdFrom", "${analysisIdFrom}", "mlTaskIdFrom", "${mlTaskIdFrom}", "projectKeyTo", "${projectKeyTo}", "analysisIdTo", "${analysisIdTo}", "mlTaskIdTo", "${mlTaskIdTo}"})
    @RequestMapping(value={"/api/analysis/cml/copy-algorithm-settings"})
    public void copyAlgorithmSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKeyFrom, @RequestParam String analysisIdFrom, @RequestParam String mlTaskIdFrom, @RequestParam String projectKeyTo, @RequestParam String analysisIdTo, @RequestParam String mlTaskIdTo) throws Exception {
        ClusteringMLTask taskTo;
        MLTaskLoc locTo;
        ClusteringMLTask taskFrom;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKeyFrom, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            MLTaskLoc locFrom = new MLTaskLoc(projectKeyFrom, analysisIdFrom, mlTaskIdFrom);
            taskFrom = this.analysisCRUDService.getCMLTask(locFrom);
            this.projectsService.checkPerm(req, projectKeyTo, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            locTo = new MLTaskLoc(projectKeyTo, analysisIdTo, mlTaskIdTo);
            taskTo = this.analysisCRUDService.getCMLTask(locTo);
        }
        assert (taskFrom.backendType == taskTo.backendType);
        ClusteringModelingParams.MetricParams metrics = (ClusteringModelingParams.MetricParams)JSON.deepCopy((Object)taskTo.modeling.metrics);
        taskTo.modeling = (ClusteringModelingParams)JSON.deepCopy((Object)taskFrom.modeling);
        taskTo.modeling.metrics = metrics;
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(u);){
            this.analysisCRUDService.saveMLTask(locTo, taskTo, true);
            rw.commit("Copied algorithm settings from " + taskFrom.id + " to " + taskTo.id);
        }
        AnalysisClusteringController.writeJSON((HttpServletResponse)resp, (Object)taskTo);
    }
}

