/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.EditableDatasetHandler;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.InlineDataOutputWriter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EditableDatasetService {
    @Autowired
    private DatasetSaveService saveService;
    @Autowired
    private FlowGraphService graphService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.datasets.editable");

    public void checkEditable(Dataset dataset) throws IOException {
        if (!"Inline".equals(dataset.getType())) {
            throw ErrorContext.iaef((String)"Dataset %s is not editable: type %s", (Object)dataset, (Object[])new Object[]{dataset.getType()});
        }
    }

    public EditableDatasetSaveResult save(Dataset dataset, EditableDatasetSaveQuery query, AuthCtx user) throws Exception {
        Schema schema = query.schema;
        ArrayList<ArrayList<Boolean>> forcedChanges = query.changes;
        EditableDatasetSaveResult res = new EditableDatasetSaveResult();
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        SchemaUtils.checkSchema(schema);
        if (query.schemaOrder != null) {
            Schema orderedSchema = new Schema();
            ArrayList<SchemaColumn> orderedColumns = new ArrayList<SchemaColumn>();
            for (Integer idx : query.schemaOrder) {
                if (schema.columns.size() <= idx) continue;
                orderedColumns.add((SchemaColumn)schema.columns.get(idx));
            }
            orderedSchema.columns = orderedColumns;
            dataset.setSchema(orderedSchema);
        } else {
            dataset.setSchema(schema);
        }
        SerializedDataset sds = dataset.serialize();
        sds.versionTag = VersionTag.increment(sds.versionTag, user.getIdentifier());
        try (EditableDatasetHandler dsHandler = (EditableDatasetHandler)((Object)DatasetHandlerFactory.build(user, dataset));){
            InlineDataOutputWriter dataOutput = dsHandler.buildDataOutput(null, 0, 0, null).getWriter(Output.WriteMode.OVERWRITE);
            InlineDataOutputWriter changesOutput = dsHandler.buildChangesOutput(null, 0, 0, null).getWriter(Output.WriteMode.OVERWRITE);
            MemTable oldData = dsHandler.getDataAsMemTable();
            MemTable oldChanges = dsHandler.getChangesAsMemTable();
            dataOutput.init((ColumnFactory)cf);
            changesOutput.init((ColumnFactory)cf);
            logger.info((Object)("Save " + query.data.size() + " rows"));
            logger.info((Object)("Previous data : " + String.valueOf(oldData == null ? "no" : Integer.valueOf(oldData.rows.size())) + " rows"));
            logger.info((Object)("Previous changes : " + String.valueOf(oldChanges == null ? "no" : Integer.valueOf(oldChanges.rows.size())) + " rows"));
            for (int idx = 0; idx < query.data.size(); ++idx) {
                int c2;
                int oldIdx;
                ArrayList<Object> line = query.data.get(idx);
                Row drow = rf.row();
                Row crow = rf.row();
                int n = oldIdx = query.rowMapping != null ? query.rowMapping.get(idx) : idx;
                if (line.size() > schema.columns.size()) {
                    throw new IllegalArgumentException("Provided row has " + line.size() + " elements but schema has " + schema.columns.size());
                }
                if (oldIdx < 0) {
                    if (line.size() > 0) {
                        for (c2 = 0; c2 < line.size(); ++c2) {
                            SchemaColumn sc = (SchemaColumn)schema.columns.get(c2);
                            if (line.get(c2) != null && StringUtils.isNotBlank((String)line.get(c2).toString())) {
                                drow.put((Column)cf.column(sc.getName()), line.get(c2).toString());
                                crow.put((Column)cf.column(sc.getName()), query.markChanged);
                                continue;
                            }
                            drow.put((Column)cf.column(sc.getName()), "");
                            crow.put((Column)cf.column(sc.getName()), false);
                        }
                    } else {
                        logger.warn((Object)"Dropped empty new row");
                    }
                } else {
                    if (oldData == null || oldData.rows.size() <= oldIdx) {
                        throw new IllegalStateException("Invalid original row index: " + oldIdx + " (" + (String)(oldData == null ? "no" : "only " + oldData.rows.size()) + " rows available)");
                    }
                    Row oldRow = oldData.rows.get(oldIdx);
                    Row oldCRow = oldChanges != null && oldChanges.rows.size() > oldIdx ? (Row)oldChanges.rows.get(oldIdx) : oldData.row();
                    if (line.size() == 0) {
                        for (c = 0; c < schema.columns.size(); ++c) {
                            colName = ((SchemaColumn)schema.columns.get(c)).getName();
                            oldColName = query.colMapping != null ? query.colMapping.get(c) : colName;
                            oc = oldData.column(oldColName);
                            nc = cf.column(colName);
                            if (oldRow.get((Column)oc) != null) {
                                drow.put((Column)nc, StringUtils.isNotBlank((String)oldRow.get((Column)oc)) ? oldRow.get((Column)oc) : "");
                                crow.put((Column)nc, oldCRow.get((Column)oc));
                                continue;
                            }
                            crow.put((Column)nc, false);
                        }
                    } else {
                        for (c = 0; c < schema.columns.size(); ++c) {
                            colName = ((SchemaColumn)schema.columns.get(c)).getName();
                            oldColName = query.colMapping != null ? query.colMapping.get(c) : colName;
                            oc = oldData.column(oldColName);
                            nc = cf.column(colName);
                            String newValue = line.get(c) != null ? line.get(c).toString() : "";
                            String oldValue = oldRow.get((Column)oc) != null ? oldRow.get((Column)oc).toString() : "";
                            drow.put((Column)nc, newValue);
                            if (StringUtils.isBlank((String)newValue) && StringUtils.isBlank((String)oldValue) || newValue.equals(oldValue)) {
                                crow.put((Column)nc, oldCRow.get((Column)oc));
                                continue;
                            }
                            crow.put((Column)nc, query.markChanged);
                        }
                    }
                }
                if (forcedChanges != null && forcedChanges.size() > idx && forcedChanges.get(idx) != null && forcedChanges.get(idx).size() > 0) {
                    for (c2 = 0; c2 < schema.columns.size(); ++c2) {
                        String colName = ((SchemaColumn)schema.columns.get(c2)).getName();
                        StreamColumn col = cf.column(colName);
                        crow.put((Column)col, forcedChanges.get(idx).get(c2).toString());
                    }
                }
                dataOutput.emitRow(drow);
                changesOutput.emitRow(crow);
            }
            dataOutput.lastRowEmitted();
            changesOutput.lastRowEmitted();
        }
        this.saveService.save(dataset.getProjectKey(), dataset.getName(), sds, user);
        res.versionTag = sds.versionTag;
        return res;
    }

    public EditableDatasetGetResult get(Dataset ds) throws Exception {
        EditableDatasetGetResult ret = new EditableDatasetGetResult();
        Schema schema = ds.getSchema();
        ret.versionTag = ds.serialize().versionTag;
        if (schema == null || schema.columns == null || schema.columns.size() == 0) {
            logger.warn((Object)("Dataset '" + ds.getFullName() + "' has an empty schema"));
        } else {
            try (EditableDatasetHandler dsHandler = (EditableDatasetHandler)((Object)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), ds));){
                FlowRecipe flowRecipe;
                ret.data = dsHandler.getDataAsList();
                ret.humanModified = dsHandler.getChangesAsList();
                ret.schema = schema;
                ProjectFlowGraph flow = this.graphService.getProjectGraphUnsafe(ds.getProjectKey());
                FlowDataset flowDataset = flow.datasets.get(ds.getFullName());
                if (flowDataset != null && flowDataset.getPredecessors().size() > 0 && (flowRecipe = (FlowRecipe)flowDataset.getPredecessors().get(0)) != null) {
                    SerializedRecipe recipe = flowRecipe.getModel();
                    ret.creatingRecipe = new RecipeLink();
                    ret.creatingRecipe.projectKey = recipe.projectKey;
                    ret.creatingRecipe.name = recipe.name;
                    ret.creatingRecipe.type = recipe.type;
                    ret.creatingRecipe.params = recipe.params;
                }
            }
        }
        return ret;
    }

    @UIModel
    public static class EditableDatasetSaveQuery {
        public ArrayList<ArrayList<Object>> data;
        @UINullable
        public ArrayList<ArrayList<Boolean>> changes;
        @UINullable
        public ArrayList<Integer> rowMapping;
        @UINullable
        public ArrayList<String> colMapping;
        @UINullable
        public ArrayList<Integer> schemaOrder;
        public Schema schema;
        public VersionTag versionTag;
        @UINullable
        public boolean force;
        @UINullable
        public boolean markChanged = true;
    }

    @UIModel
    public static class EditableDatasetSaveResult {
        public VersionTag versionTag;
    }

    @UIModel
    public static class EditableDatasetGetResult {
        ArrayList<ArrayList<String>> data;
        ArrayList<ArrayList<String>> humanModified;
        Schema schema;
        RecipeLink creatingRecipe;
        VersionTag versionTag;
    }

    public static class RecipeLink {
        public String projectKey;
        public String name;
        public String type;
        public RecipeParams params;
    }
}

