/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.recipes.RecipesMassActionsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.RecipesEnginesService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/flow/recipes/mass-actions"})
public class RecipesMassActionsController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private RecipesEnginesService recipesEnginesService;
    @Autowired
    private RecipesMassActionsService recipesMassActionsService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.controllers.recipes");

    @AuditNotNeeded
    @RequestMapping(value={"/start-set-impala-write-mode"})
    public void startSetImpalaWriteMode(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes) throws Exception {
        InfoMessage.InfoMessages ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesMassActionsService.startSetImpalaWriteMode(refs, authCtx);
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "recipe-change-impala-write-mode", "recipes", "${recipes}", "runInStreamMode", "${runInStreamMode}"})
    @RequestMapping(value={"/set-impala-write-mode"})
    public void setImpalaWriteMode(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam boolean runInStreamMode) throws Exception {
        InfoMessage.InfoMessages ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesMassActionsService.setImpalaWriteMode(refs, runInStreamMode, authCtx);
            t.commit("Change impala write mode for " + refs.size() + " recipes.");
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/start-set-hive-engine"})
    public void startSetHiveEngine(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes) throws Exception {
        InfoMessage.InfoMessages ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesMassActionsService.startSetHiveEngine(refs, authCtx);
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "recipe-change-hive-engine", "recipes", "${recipes}", "executionEngine", "${executionEngine}"})
    @RequestMapping(value={"/set-hive-engine"})
    public void setHiveEngine(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam String executionEngine) throws Exception {
        InfoMessage.InfoMessages ret;
        HiveRecipeMeta.HiveExecutionEngine hiveExecutionEngine = HiveRecipeMeta.HiveExecutionEngine.valueOf(executionEngine);
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesMassActionsService.setHiveEngine(refs, hiveExecutionEngine, authCtx);
            t.commit("Change hive engine for " + refs.size() + " recipes.");
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/start-set-spark-config"})
    public void startSetSparkConfig(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes) throws Exception {
        InfoMessage.InfoMessages ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesMassActionsService.startSetSparkConfig(refs, authCtx);
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "set-spark-config", "recipes", "${recipes}", "sparkConfig", "${sparkConfig}"})
    @RequestMapping(value={"/set-spark-config"})
    public void setSparkConfig(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, String sparkConfig) throws Exception {
        InfoMessage.InfoMessages ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        SparkOverrideConfig config = (SparkOverrideConfig)JSON.parse((String)sparkConfig, SparkOverrideConfig.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesMassActionsService.setSparkConfig(refs, config, authCtx);
            t.commit("Changed spark config for " + refs.size() + " recipes.");
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/start-set-pipelineability"})
    public void startSetPipelineability(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam String pipelineType) throws Exception {
        InfoMessage.InfoMessages ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            RecipePipelineHelper.PipelineType type = RecipePipelineHelper.PipelineType.valueOf(pipelineType);
            ret = this.recipesMassActionsService.startSetPipelineability(refs, type, authCtx);
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "set-pipelineability", "recipes", "${recipes}", "allowStart", "${allowStart}", "allowMerge", "${allowMerge}"})
    @RequestMapping(value={"/set-pipelineability"})
    public void setPipelineability(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam String pipelineType, @RequestParam String allowStart, @RequestParam String allowMerge) throws Exception {
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            RecipePipelineHelper.PipelineType type = RecipePipelineHelper.PipelineType.valueOf(pipelineType);
            this.recipesMassActionsService.setPipelineability(refs, type, "true".equals(allowStart), "true".equals(allowMerge), authCtx);
            t.commit("Change spark pipelineability for " + refs.size() + " recipes.");
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/start-change-engines"})
    public void startChangeEngines(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes) throws Exception {
        RecipesEnginesService.EnginesChangeStartResponse ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesEnginesService.startChangeEngines(refs, authCtx);
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)((Object)ret));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/test-change-engines"})
    public void testChangeEngines(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, String engine) throws Exception {
        InfoMessage.InfoMessages ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesEnginesService.testChangeEngines(refs, engine, authCtx);
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "set-recipes-engines", "recipes", "${recipes}"})
    @RequestMapping(value={"/change-engines"})
    public void changeEngines(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, String engine) throws Exception {
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            this.recipesEnginesService.changeEngines(refs, engine, authCtx);
            if (refs.size() == 1) {
                t.commit("Change recipe engine: " + ((TaggableObjectsService.TaggableObjectRef)refs.get(0)).getLoc().resolved().getFullName());
            } else {
                t.commit("Change " + refs.size() + " recipes engines");
            }
        }
    }

    @AuditedCall(value={"msgType", "set-recipes-code-env", "recipes", "${recipes}"})
    @RequestMapping(value={"/change-code-env"})
    public void changeCodeEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam(value="envSelection") String envSelectionStr) throws Exception {
        Object ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        CodeEnvSelection envSelection = (CodeEnvSelection)JSON.parse((String)envSelectionStr, CodeEnvSelection.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesMassActionsService.changeCodeEnv(refs, envSelection);
            if (refs.size() == 1) {
                t.commit("Change recipe code env: " + ((TaggableObjectsService.TaggableObjectRef)refs.get(0)).getLoc().resolved().getFullName());
            } else {
                t.commit("Change " + refs.size() + " recipes code envs");
            }
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "recipe-test-convert-to-impala", "recipes", "${recipes}"})
    @RequestMapping(value={"/test-convert-to-impala"})
    public void testConvertToImpala(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam boolean checkRecipesRunOnImpala) throws Exception {
        AuthCtx authCtx;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
        }
        this.recipesEnginesService.testConvertToImpala_NT(refs, authCtx, checkRecipesRunOnImpala);
    }

    @AuditedCall(value={"msgType", "recipe-convert-to-impala", "recipes", "${recipes}"})
    @RequestMapping(value={"/convert-to-impala"})
    public void convertToImpala(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam boolean checkRecipesRunOnImpala) throws Exception {
        AuthCtx authCtx;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
        }
        this.recipesEnginesService.convertToImpala_NT(refs, authCtx, checkRecipesRunOnImpala);
    }

    @AuditedCall(value={"msgType", "recipe-test-convert-to-hive", "recipes", "${recipes}"})
    @RequestMapping(value={"/test-convert-to-hive"})
    public void testConvertToHive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam boolean checkRecipesRunOnHive) throws Exception {
        AuthCtx authCtx;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
        }
        this.recipesEnginesService.testConvertToHive_NT(refs, authCtx, checkRecipesRunOnHive);
    }

    @AuditedCall(value={"msgType", "recipe-convert-to-hive", "recipes", "${recipes}"})
    @RequestMapping(value={"/convert-to-hive"})
    public void convertToHive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam boolean checkRecipesRunOnHive) throws Exception {
        AuthCtx authCtx;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
        }
        this.recipesEnginesService.convertToHive_NT(refs, authCtx, checkRecipesRunOnHive);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/start-set-spark-engine"})
    public void startSetSparkEngine(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes) throws Exception {
        InfoMessage.InfoMessages ret;
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesMassActionsService.startSetSparkEngine(refs, authCtx);
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "recipe-change-spark-engine", "recipes", "${recipes}", "executionEngine", "${executionEngine}"})
    @RequestMapping(value={"/set-spark-engine"})
    public void setSparkEngine(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipes, @RequestParam String executionEngine) throws Exception {
        InfoMessage.InfoMessages ret;
        AbstractSparkRecipeParams.SparkExecutionEngine sparkExecutionEngine = AbstractSparkRecipeParams.SparkExecutionEngine.valueOf(executionEngine);
        List refs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProject(refs, authCtx);
            ret = this.recipesMassActionsService.setSparkEngine(refs, sparkExecutionEngine, authCtx);
            t.commit("Change spark engine for " + refs.size() + " recipes.");
        }
        RecipesMassActionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    private void checkWriteConfOnAllSourceProject(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx) throws DKUSecurityException {
        HashSet authorizedProjectKeys = new HashSet();
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            String projectKey = ref.getLoc().resolved().getProjectKey();
            if (authorizedProjectKeys.contains(projectKey)) continue;
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
    }
}

