/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.upsert.UpsertQueryGenerator;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.server.recipes.UpsertSchemaGenerator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpsertRecipeService {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.upsert");

    private void expandParams(UpsertRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        FilterDescUtils.expand(params.preFilter, vc);
        FilterDescUtils.expand(params.computedColumns, vc);
    }

    public UpsertRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        UpsertRecipePayloadParams params = (UpsertRecipePayloadParams)JSON.parse((String)payload, UpsertRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        this.expandParams(params, sr.projectKey);
        return params;
    }

    public QueryBunch generateSQL(JobActivity activity, SQLDialect dialect, UpsertRecipePayloadParams params, String engine, boolean forceOutputColumnNameOverride) throws IOException {
        Partition part;
        List<Partition> parts;
        Dataset source = activity.getSubgraph().getSingleSourceDataset().getMandatory(this.datasetsDAO);
        List<Partition> sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        PartitioningScheme targetPartitionScheme = null;
        boolean usePartitionsInQueries = MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams);
        if (usePartitionsInQueries && (parts = activity.getSubgraph().getSourcePartitions(activity.getSubgraph().getSingleSourceDataset())) != null && !parts.isEmpty() && !parts.get(0).isAll() && !parts.get(0).isNP() && source.getPartitioningSchema().isPartitioned()) {
            sourcePartitions = parts;
            sourcePartitionScheme = source.getPartitioningSchema();
        }
        Dataset outputDS = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO);
        if (usePartitionsInQueries && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = outputDS.getPartitioningSchema();
        }
        return this.generateSQL(dialect, params, engine, source, outputDS, sourcePartitionScheme, sourcePartitions, targetPartitionScheme, forceOutputColumnNameOverride);
    }

    public String generatePrepareDataSQL(JobActivity activity, SQLDialect dialect, UpsertRecipePayloadParams params, String engine, boolean forceOutputColumnNameOverride) throws IOException {
        Partition part;
        List<Partition> parts;
        Dataset source = activity.getSubgraph().getSingleSourceDataset().getMandatory(this.datasetsDAO);
        List<Partition> sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        PartitioningScheme targetPartitionScheme = null;
        boolean usePartitionsInQueries = MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams);
        if (usePartitionsInQueries && (parts = activity.getSubgraph().getSourcePartitions(activity.getSubgraph().getSingleSourceDataset())) != null && parts.size() > 0 && !parts.get(0).isAll() && !parts.get(0).isNP() && source.getPartitioningSchema().isPartitioned()) {
            sourcePartitions = parts;
            sourcePartitionScheme = source.getPartitioningSchema();
        }
        Dataset target = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO);
        if (usePartitionsInQueries && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && target.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = target.getPartitioningSchema();
        }
        SQLUtils.SQLTable sourceTable = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
        SQLUtils.SQLTable targetTable = DatasetUtils.getResolvedTableWithSparkSQLFallback(target, dialect, params.engineParams);
        UpsertQueryGenerator sqlGenerator = new UpsertQueryGenerator(params, source, source.getParams(), sourceTable, target, target.getParams(), targetTable);
        sqlGenerator.setPartitioning(sourcePartitionScheme, sourcePartitions, targetPartitionScheme);
        return sqlGenerator.generatePrepareDataSelectSQL(dialect);
    }

    public QueryBunch generateSQLIgnorePartitions(SQLDialect dialect, UpsertRecipePayloadParams params, String engine, Dataset source, Dataset target, boolean forceOutputColumnNameOverride) throws IOException {
        return this.generateSQL(dialect, params, engine, source, target, null, null, null, forceOutputColumnNameOverride);
    }

    private QueryBunch generateSQL(SQLDialect dialect, UpsertRecipePayloadParams params, String engine, Dataset source, Dataset target, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme, boolean forceOutputColumnNameOverride) throws IOException {
        SQLUtils.SQLTable sourceTable = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
        SQLUtils.SQLTable targetTable = DatasetUtils.getResolvedTableWithSparkSQLFallback(target, dialect, params.engineParams);
        UpsertQueryGenerator sqlGenerator = new UpsertQueryGenerator(params, source, source.getParams(), sourceTable, target, target.getParams(), targetTable);
        sqlGenerator.setPartitioning(sourcePartitionScheme, sourcePartitions, targetPartitionScheme);
        QueryBunch qb = new QueryBunch();
        qb.inputQuery = sqlGenerator.generateSourceSelect(dialect);
        if (!("SQL".equals(engine) || "IMPALA".equals(engine) || "HIVE".equals(engine))) {
            qb.query = sqlGenerator.generatePrepareDataSQL(dialect);
        } else {
            switch (params.upsertSQLMode) {
                case DIRECT: {
                    SQLDialect.UpsertWriter upsertWriter = dialect.getUpsertWriter();
                    if (upsertWriter == null) {
                        throw new UnsupportedOperationException("Dialect doesn't support upsert");
                    }
                    switch (params.upsertIndexMode) {
                        case USE_EXISTING: {
                            break;
                        }
                        case CREATE_IF_NEEDED: {
                            if (dialect.getUniqueConstraintWriter() == null) break;
                            qb.optionalPreQueries.add(sqlGenerator.generateCreateIndex(dialect));
                            break;
                        }
                        case TEMPORARY: {
                            if (dialect.getUniqueConstraintWriter() == null) break;
                            qb.optionalPreQueries.add(sqlGenerator.generateCreateIndex(dialect));
                            qb.postQueries.add(sqlGenerator.generateDropIndex(dialect));
                            qb.namedLock = "index." + target.getFullName();
                            break;
                        }
                        default: {
                            throw new Error("unreachable");
                        }
                    }
                    qb.query = sqlGenerator.generateUpsertSQL(dialect);
                    if (upsertWriter.canUpsertConcurrently()) break;
                    qb.namedLock = "merge." + target.getFullName();
                    break;
                }
                case UPDATE_THEN_INSERT: {
                    qb.preQueries.add(sqlGenerator.generateUpdateSQL(dialect));
                    qb.query = sqlGenerator.generateInsertUnmatchedSQL(dialect);
                    if (dialect.canInsertAndSelectConcurrently()) break;
                    qb.namedLock = "insert-select." + target.getFullName();
                    break;
                }
                case PREPARE_THEN_REPLACE: {
                    qb.optionalPreQueries.add(sqlGenerator.generateDropTempTable(dialect));
                    qb.preQueries.add(sqlGenerator.generateCreateTempTable(dialect));
                    qb.preQueries.add(sqlGenerator.generatePrepareDataSQL(dialect));
                    String truncation = sqlGenerator.generateTruncateDataSQL(dialect);
                    if (StringUtils.isNotBlank((String)truncation)) {
                        qb.preQueries.add(truncation);
                    }
                    qb.query = sqlGenerator.generateCopyDataSQL(dialect);
                    qb.postQueries.add(sqlGenerator.generateDropTempTable(dialect));
                    if (dialect.canInsertAndSelectConcurrently()) break;
                    qb.namedLock = "insert-select." + target.getFullName();
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
        }
        return qb;
    }

    public Schema getOutputSchemaBeforeOverride(Dataset inputDS, UpsertRecipePayloadParams params, boolean lowerCaseColumnsNames, Integer identifierMaxLength) {
        Schema schema = this.getBaseOutputSchema(inputDS, params, identifierMaxLength);
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    public Schema getOutputSchemaAfterOverride(Dataset inputDS, UpsertRecipePayloadParams params, boolean lowerCaseColumnsNames, Integer identifierMaxLength) {
        Schema schema = this.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames, identifierMaxLength);
        SchemaUtils.applyOverrides(schema, Collections.emptyMap(), lowerCaseColumnsNames);
        return schema;
    }

    private Schema getBaseOutputSchema(Dataset inputDS, UpsertRecipePayloadParams params, Integer identifierMaxLength) {
        return new UpsertSchemaGenerator(inputDS.getSchema()).getBaseOutputSchema(params, identifierMaxLength);
    }
}

