/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CachesPreloadingService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private FlowGraphService flowGraphService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.cachePreload");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void start() throws IOException {
        block18: {
            DKULogger.startCurrentCall();
            try {
                Params params = ApplicationConfigurator.getParams();
                boolean preloadConfig = params.getBoolParam("dku.caching.preloadConfig", false);
                if (!preloadConfig) break block18;
                logger.info((Object)"Preloading configuration");
                int configPreloadThreads = params.getIntParam("dku.caching.configPreloadThreads", Integer.valueOf(3));
                ExecutorService es = Executors.newFixedThreadPool(configPreloadThreads, new ThreadFactoryBuilder().setNameFormat("ObjectCachePreload-%d").build());
                List<Object> projectKeys = new ArrayList();
                try (Object t = this.transactionService.beginRead();){
                    projectKeys = this.projectsDAO.listKeys();
                }
                for (final String string : projectKeys) {
                    es.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            DKULogger.startCurrentCall();
                            logger.infoV("Preload %s: starting", new Object[]{string});
                            try (Transaction t = CachesPreloadingService.this.transactionService.beginRead();){
                                CachesPreloadingService.this.datasetsDAO.listUnsafe(string);
                                logger.infoV("Preload %s: datasets loaded", new Object[]{string});
                                CachesPreloadingService.this.recipesDAO.listUnsafe(string);
                                logger.infoV("Preload %s: recipes loaded", new Object[]{string});
                                CachesPreloadingService.this.analysisCRUDService.listCoreUnsafe(string, null);
                                logger.infoV("Preload %s: analysis loaded", new Object[]{string});
                            }
                            logger.infoV("Preload %s: done", new Object[0]);
                            DKULogger.endCurrentCall();
                            return null;
                        }
                    });
                }
                logger.info((Object)"Preload: waiting for threads to finish");
                es.shutdown();
                try {
                    es.awaitTermination(1000L, TimeUnit.HOURS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn((Object)"Await failed", (Throwable)e);
                }
                logger.info((Object)"Preload: done");
                if (!params.getBoolParam("dku.caching.preloadFlowGraph", false)) break block18;
                logger.info((Object)"Preload: computing global graph");
                t = this.transactionService.beginRead();
                try {
                    this.flowGraphService.getGlobalGraphUnsafe(true);
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
                logger.info((Object)"Preload: got global graph");
            }
            finally {
                DKULogger.endCurrentCall();
            }
        }
    }
}

