/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.UrlRedactionUtils;
import com.dataiku.dip.server.controllers.admin.AdminEditionController;
import com.dataiku.dip.server.notifications.backend.ProjectLibsChangedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.imfs.InMemoryCache;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitCodes;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.cli.GitRemoteCommands;
import com.dataiku.dip.transactions.git.jgit.GitLocalCommands;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GitReferencesService {
    public static final String FILENAME = "external-libraries.json";
    private static final String GIT_LIBRARY_PUSH_DIRECTORY = "git-library-push";
    private static final String LIBRARY_TEXT = "Library: ";
    private static final String PUSH_LIBRARY_TEXT = "Trying to push the library: ";
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private PubSubService pubSubService;
    protected static final DKULogger logger = DKULogger.getLogger((String)"dip.services.gitrefs");

    public Map<String, GitModel.GitReference> getProjectGitReferences(String projectKey) throws IOException, CodedException {
        return this.getProjectExternalLibraries((String)projectKey).gitReferences;
    }

    public DSSGitModel.ExternalLibraries getProjectExternalLibrariesForUI(String projectKey) throws IOException, CodedException {
        RelFile projectGitRefsFile = this.getProjectGitRefsFile(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        return this.getExternalLibrariesFromRelFileEncrypted(projectGitRefsFile, tr);
    }

    public DSSGitModel.ExternalLibraries getProjectExternalLibraries(String projectKey) throws IOException, CodedException {
        RelFile projectGitRefsFile = this.getProjectGitRefsFile(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        return this.getExternalLibrariesFromRelFile(projectGitRefsFile, tr);
    }

    public GitModel.GitReference encryptProjectGitReference(GitModel.GitReference gitReference) {
        if (gitReference != null) {
            gitReference.remotePassword = this.passwordEncryptionService.encryptIfNotEncryptedOrEmpty(gitReference.remotePassword);
        }
        return gitReference;
    }

    public GitModel.GitReference decryptProjectGitReference(GitModel.GitReference gitReference) {
        try {
            gitReference.remotePassword = this.passwordEncryptionService.decryptIfEncrypted(gitReference.remotePassword);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)(e.getMessage() + " for git reference " + gitReference.getSanitizedRemoteUrl()));
        }
        return gitReference;
    }

    private void saveProjectGitReferences(RWTransactionRef tr, String projectKey, RelFile projectGitRefsFile, DSSGitModel.ExternalLibraries externalLibraries) throws IOException {
        for (Map.Entry<String, GitModel.GitReference> entry : externalLibraries.gitReferences.entrySet()) {
            this.encryptProjectGitReference(entry.getValue());
        }
        tr.writeObject(projectGitRefsFile, (Object)externalLibraries);
        ProjectLibsChangedEvent event = new ProjectLibsChangedEvent(projectKey);
        String key = "ProjectLibsChangedEvent-" + projectKey;
        int interval = DKUApp.getProperty((String)"dku.docportal.indexingDebounceIntervalMs", (int)30000);
        this.pubSubService.publishAfterTransactionWithDebounce(key, event, interval);
    }

    public void setProjectGitReferences(String projectKey, Map<String, GitModel.GitReference> gitReferences) throws IOException, CodedException {
        RelFile projectGitRefsFile = this.getProjectGitRefsFile(projectKey);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        DSSGitModel.ExternalLibraries externalLibraries = this.getExternalLibrariesFromRelFile(projectGitRefsFile, (TransactionRef)tr);
        externalLibraries.gitReferences = gitReferences;
        this.saveProjectGitReferences(tr, projectKey, projectGitRefsFile, externalLibraries);
    }

    public String mkRemoteURL(String remote, String remoteLogin, String remotePassword) throws URISyntaxException {
        URIBuilder uri;
        String scheme;
        if (!StringUtils.isEmpty((String)remoteLogin) && ("http".equals(scheme = (uri = new URIBuilder(remote)).getScheme().toLowerCase()) || "https".equals(scheme))) {
            if (StringUtils.isEmpty((String)remotePassword)) {
                uri.setUserInfo(remoteLogin);
            } else {
                uri.setUserInfo(remoteLogin, this.passwordEncryptionService.decryptIfEncrypted(remotePassword));
            }
            return uri.toString();
        }
        return remote;
    }

    public String getGitReferenceRemoteURL(GitModel.GitReference ref) throws URISyntaxException {
        return this.mkRemoteURL(ref.remote, ref.remoteLogin, ref.remotePassword);
    }

    public String setProjectGitReference(String projectKey, GitModel.GitReference gitRef, String gitRefPath, boolean addPythonPath) throws IOException, CodedException {
        if (StringUtils.isBlank((String)gitRefPath)) {
            throw new CodedException((InfoMessage.MessageCode)GitCodes.ERR_INVALID_GIT_REF_PATH, "Git reference path should not be blank");
        }
        RelFile projectGitRefsFile = this.getProjectGitRefsFile(projectKey);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        DSSGitModel.ExternalLibraries externalLibraries = this.getExternalLibrariesFromRelFile(projectGitRefsFile, (TransactionRef)tr);
        RelFile libPath = AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey);
        String refPath = libPath.appendStrictChildPath(gitRefPath).getFullPath().substring(libPath.getFullPath().length() + 1);
        externalLibraries.gitReferences.put(refPath, gitRef);
        if (addPythonPath) {
            externalLibraries.pythonPath.add(refPath);
        }
        this.saveProjectGitReferences(tr, projectKey, projectGitRefsFile, externalLibraries);
        return refPath;
    }

    private void renameProjectGitReference(DSSGitModel.ExternalLibraries externalLibraries, String oldPath, String newPath) {
        GitModel.GitReference gitReference = externalLibraries.gitReferences.get(oldPath);
        if (gitReference != null) {
            externalLibraries.gitReferences.remove(oldPath);
            externalLibraries.gitReferences.put(newPath, gitReference);
        }
        if (externalLibraries.pythonPath.remove(oldPath)) {
            externalLibraries.pythonPath.add(newPath);
        }
        if (externalLibraries.rsrcPath.remove(oldPath)) {
            externalLibraries.rsrcPath.add(newPath);
        }
    }

    public void updateGitReferencesAfterPathUpdate(String projectKey, String oldPath, String newPath) throws CodedException, IOException {
        RelFile projectGitRefsFile = this.getProjectGitRefsFile(projectKey);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        DSSGitModel.ExternalLibraries externalLibraries = this.getExternalLibrariesFromRelFile(projectGitRefsFile, (TransactionRef)tr);
        ArrayList<Map.Entry<String, GitModel.GitReference>> entriesFound = new ArrayList<Map.Entry<String, GitModel.GitReference>>();
        for (Map.Entry<String, GitModel.GitReference> entry : externalLibraries.gitReferences.entrySet()) {
            if (!Objects.equals(entry.getKey(), oldPath) && !entry.getKey().startsWith(oldPath + "/")) continue;
            entriesFound.add(entry);
        }
        if (!entriesFound.isEmpty()) {
            for (Map.Entry<String, Object> entry : entriesFound) {
                this.renameProjectGitReference(externalLibraries, entry.getKey(), entry.getKey().startsWith(oldPath + "/") ? entry.getKey().replaceFirst(oldPath + "/", newPath + "/") : newPath);
            }
            this.saveProjectGitReferences(tr, projectKey, projectGitRefsFile, externalLibraries);
        }
    }

    public void removeGitReferencesAfterPathDeletion(String projectKey, String deletedPath) throws CodedException, IOException {
        RelFile projectGitRefsFile = this.getProjectGitRefsFile(projectKey);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        DSSGitModel.ExternalLibraries externalLibraries = this.getExternalLibrariesFromRelFile(projectGitRefsFile, (TransactionRef)tr);
        ArrayList<Map.Entry<String, GitModel.GitReference>> entriesFound = new ArrayList<Map.Entry<String, GitModel.GitReference>>();
        for (Map.Entry<String, GitModel.GitReference> entry : externalLibraries.gitReferences.entrySet()) {
            if (!Objects.equals(entry.getKey(), deletedPath) && !entry.getKey().startsWith(deletedPath + "/")) continue;
            entriesFound.add(entry);
        }
        if (!entriesFound.isEmpty()) {
            for (Map.Entry<String, Object> entry : entriesFound) {
                externalLibraries.gitReferences.remove(entry.getKey());
                externalLibraries.pythonPath.remove(entry.getKey());
                externalLibraries.rsrcPath.remove(entry.getKey());
            }
            this.saveProjectGitReferences(tr, projectKey, projectGitRefsFile, externalLibraries);
        }
    }

    public void removeProjectGitReference(String projectKey, String gitRefPath, boolean deleteDirectory) throws IOException, CodedException {
        RelFile libDir;
        RelFile gitRefDir;
        RelFile projectGitRefsFile = this.getProjectGitRefsFile(projectKey);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        DSSGitModel.ExternalLibraries externalLibraries = this.getExternalLibrariesFromRelFile(projectGitRefsFile, (TransactionRef)tr);
        if (externalLibraries.gitReferences.remove(gitRefPath) != null && deleteDirectory && StringUtils.isNotBlank((String)gitRefPath) && (gitRefDir = (libDir = AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey)).appendPath_withoutDirectoryTraversalCheck(gitRefPath)).isStrictChildOf(libDir)) {
            tr.deleteDirectory(gitRefDir);
            externalLibraries.pythonPath.remove(gitRefPath);
            externalLibraries.rsrcPath.remove(gitRefPath);
        }
        this.saveProjectGitReferences(tr, projectKey, projectGitRefsFile, externalLibraries);
    }

    public FutureResponse<InfoMessage.InfoMessages> startPullProjectGitRefs_NT(String projectKey, AuthCtx authCtx) throws Exception {
        PullGitReferencesFutureThread ft = new PullGitReferencesFutureThread(projectKey, authCtx);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    public FutureResponse<InfoMessage.InfoMessages> startPullProjectGitRef_NT(String projectKey, String gitRefPath, AuthCtx authCtx) throws Exception {
        PullGitReferencesFutureThread ft = new PullGitReferencesFutureThread(projectKey, authCtx, gitRefPath);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    public FutureResponse<InfoMessage.InfoMessages> startPushProjectGitRefs_NT(String projectKey, String commitMessage, AuthCtx authCtx) throws Exception {
        PushGitReferencesFutureThread ft = new PushGitReferencesFutureThread(projectKey, commitMessage, authCtx);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    public FutureResponse<InfoMessage.InfoMessages> startPushProjectGitRef_NT(String projectKey, String commitMessage, String gitRefPath, AuthCtx authCtx) throws Exception {
        PushGitReferencesFutureThread ft = new PushGitReferencesFutureThread(projectKey, commitMessage, authCtx, gitRefPath);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    public void revertLibrary(String projectKey, String gitLib, AuthCtx authCtx) throws CodedException, IOException {
        NativeFS tempFs = this.getConflictTempFolder(projectKey);
        RelFile libPath = AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey).appendStrictChildPath(gitLib);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            GitModel.GitReference gitReference = this.getProjectGitReference(projectKey, gitLib);
            t.deleteDirectory(libPath);
            t.makeDirectory(libPath);
            FSUtils.newRecursiveCopy().from((ReadOnlyFS)tempFs, gitLib).to((ReadWriteFS)t, libPath).run();
            gitReference.conflictingFiles = new HashSet();
            gitReference.resolvedFiles = new HashSet();
            gitReference.lastHash = gitReference.faultyHash;
            gitReference.isDirty = false;
            this.setProjectGitReference(projectKey, gitReference, gitLib, false);
            t.commitV("Restore %s to the previous version for %s", new Object[]{gitLib, projectKey});
        }
    }

    public void setDirty(String projectKey, String[] libs, AuthCtx authCtx) throws CodedException, IOException {
        StringJoiner changedLib = new StringJoiner(", ");
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            for (String lib : libs) {
                GitModel.GitReference gitReference = this.getProjectGitReference(projectKey, lib);
                if (gitReference.isDirty) continue;
                gitReference.isDirty = true;
                changedLib.add(lib);
                this.setProjectGitReference(projectKey, gitReference, lib, false);
            }
            String modifiedLib = changedLib.toString();
            if (!modifiedLib.isEmpty()) {
                t.commitV(" Set %s to dirty state.", new Object[]{modifiedLib});
            }
        }
    }

    public GitModel.GitReference getProjectGitReference(String projectKey, String gitLib) throws IOException, CodedException {
        Map<String, GitModel.GitReference> gitReferences = this.getProjectGitReferences(projectKey);
        if (!gitReferences.containsKey(gitLib)) {
            throw new IllegalArgumentException(gitLib + " not found in libraries");
        }
        return gitReferences.get(gitLib);
    }

    public void markAsResolved(String projectKey, String fileName, String gitLibPath, AuthCtx authCtx) throws CodedException, IOException {
        String file = fileName.replaceFirst(gitLibPath, "").substring(1);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            GitModel.GitReference gitReference = this.getProjectGitReference(projectKey, gitLibPath);
            gitReference.conflictingFiles.remove(file);
            gitReference.resolvedFiles.add(file);
            this.setProjectGitReference(projectKey, gitReference, gitLibPath, false);
            t.commitV("Git references update for %s", new Object[]{projectKey});
        }
    }

    private void couldNotDoSmthWithGitReferences(Map.Entry<String, GitModel.GitReference> gitRefEntry, InfoMessage.InfoMessages messages, GitModel.GitReference gitRef, Exception ex, GitCodes gitCodes) {
        String loggerMessage = "";
        String infoMessage = "";
        if (gitCodes == GitCodes.ERR_GIT_REF_UPDATE_FAILED) {
            loggerMessage = "Could not update this git reference: %s %s";
            infoMessage = "Could not import from the following repository: '%s' (%s: %s @ %s). Error is %s";
        }
        if (gitCodes == GitCodes.ERR_GIT_PUSH_FAILED) {
            loggerMessage = "Could not push to this git reference: %s %s";
            infoMessage = "Could not push to the following repository: '%s' (%s: %s @ %s). Error is %s";
        }
        logger.errorV((Throwable)ex, loggerMessage, new Object[]{gitRef.getSanitizedRemoteUrl(), gitRef.checkout});
        messages.withFatalV((InfoMessage.MessageCode)gitCodes, infoMessage, new Object[]{gitRefEntry.getKey(), gitRef.getSanitizedRemoteUrl(), StringUtils.defaultIfBlank((String)gitRef.remotePath, (String)"/"), StringUtils.defaultIfBlank((String)gitRef.checkout, (String)"main"), UrlRedactionUtils.sanitizeHttpUrls((String)ExceptionUtils.getMessageWithCauses((Throwable)ex))});
    }

    private NativeFS getConflictTempFolder(String projectKey) throws IOException {
        File tmpResolutionDir = DKUApp.getFile((String[])new String[]{"tmp", projectKey, GIT_LIBRARY_PUSH_DIRECTORY});
        DKUFileUtils.mkdirs((File)tmpResolutionDir);
        return NativeFS.from((File)tmpResolutionDir).build();
    }

    private DSSGitModel.ExternalLibraries getExternalLibrariesFromRelFile(RelFile relFile, TransactionRef tr) throws IOException, CodedException {
        DSSGitModel.ExternalLibraries externalLibraries = this.getExternalLibrariesFromRelFileEncrypted(relFile, tr);
        for (Map.Entry<String, GitModel.GitReference> entry : externalLibraries.gitReferences.entrySet()) {
            this.decryptProjectGitReference(entry.getValue());
        }
        return externalLibraries;
    }

    private DSSGitModel.ExternalLibraries getExternalLibrariesFromRelFileEncrypted(RelFile relFile, TransactionRef tr) throws IOException, CodedException {
        if (!tr.isFile(relFile)) {
            return new DSSGitModel.ExternalLibraries();
        }
        try {
            return (DSSGitModel.ExternalLibraries)tr.readObject(relFile, DSSGitModel.ExternalLibraries.class);
        }
        catch (JsonSyntaxException ex) {
            throw new CodedException((InfoMessage.MessageCode)GitCodes.ERR_MALFORMED_EXT_LIBS_JSON, "Error while parsing external libraries. Make sure that the JSON file is properly formatted.", (Throwable)ex);
        }
    }

    private RelFile getProjectGitRefsFile(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "lib", FILENAME});
    }

    private class PullGitReferencesFutureThread
    extends GitReferencesFutureThread {
        PullGitReferencesFutureThread(String projectKey, AuthCtx authCtx) {
            this(projectKey, authCtx, null);
        }

        PullGitReferencesFutureThread(String projectKey, AuthCtx authCtx, String gitRefPath) {
            super(projectKey, authCtx, "pull_git_refs", "Pulling Git refs for libraries", gitRefPath);
        }

        private GitRef pullGitRef_NT(Map.Entry<String, GitModel.GitReference> gitRefEntry, File contextualTmpDir, InfoMessage.InfoMessages messages) {
            TransactionContext.assertNoAttachedTransaction();
            GitModel.GitReference gitRef = gitRefEntry.getValue();
            try {
                File gitCloneDirectory = new File(contextualTmpDir, SecretKeyGenerator.generate((int)8));
                DKUFileUtils.mkdirs((File)gitCloneDirectory);
                GitRemoteCommands git = new GitRemoteCommands(gitCloneDirectory);
                git.shallowClone(this.owner, GitReferencesService.this.getGitReferenceRemoteURL(gitRef), gitRef.checkout);
                String pulledHash = git.getHashFor("HEAD");
                File remoteDir = gitCloneDirectory;
                if (StringUtils.isNotBlank((String)gitRef.remotePath) && !(remoteDir = DKUFileUtils.getWithinOrSame((File)remoteDir, (String[])new String[]{gitRef.remotePath})).exists()) {
                    throw new CodedException((InfoMessage.MessageCode)GitCodes.ERR_GIT_PATH_INVALID, "Given path does not exist in repository: '" + gitRef.remotePath + "'");
                }
                messages.withSuccess((InfoMessage.MessageCode)GitCodes.INFO_GIT_REF_UPDATE_OK, String.format("Successfully updated '%s' (%s: %s @ %s)", gitRefEntry.getKey(), gitRef.getSanitizedRemoteUrl(), StringUtils.defaultIfBlank((String)gitRef.remotePath, (String)"/"), StringUtils.defaultIfBlank((String)gitRef.checkout, (String)"main")));
                return new GitRef(gitRefEntry, remoteDir, pulledHash);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                GitReferencesService.this.couldNotDoSmthWithGitReferences(gitRefEntry, messages, gitRef, ex, GitCodes.ERR_GIT_REF_UPDATE_FAILED);
                return null;
            }
            catch (Exception ex) {
                GitReferencesService.this.couldNotDoSmthWithGitReferences(gitRefEntry, messages, gitRef, ex, GitCodes.ERR_GIT_REF_UPDATE_FAILED);
                return null;
            }
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            Map<String, GitModel.GitReference> gitReferences = this.loadGitReferences();
            ArrayList<GitRef> pulledGitRefs = new ArrayList<GitRef>();
            try (AutoDelete tempDir = DSSTempUtils.getTempFolder((String)"lib-pulls");){
                for (Map.Entry<String, GitModel.GitReference> gitRefEntry : gitReferences.entrySet()) {
                    GitRef pullGitRef = this.pullGitRef_NT(gitRefEntry, (File)tempDir, messages);
                    if (pullGitRef == null) continue;
                    pulledGitRefs.add(pullGitRef);
                }
                this.saveGitRefs(pulledGitRefs);
            }
            return messages;
        }
    }

    private class PushGitReferencesFutureThread
    extends GitReferencesFutureThread {
        private final String commitMessage;

        PushGitReferencesFutureThread(String projectKey, String commitMessage, AuthCtx authCtx) {
            this(projectKey, commitMessage, authCtx, null);
        }

        PushGitReferencesFutureThread(String projectKey, String commitMessage, AuthCtx authCtx, String gitRefPath) {
            super(projectKey, authCtx, "push_git_refs", "Pushing Git refs for libraries", gitRefPath);
            this.commitMessage = commitMessage;
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            Map<String, GitModel.GitReference> gitReferences = this.loadGitReferences();
            ArrayList<GitRef> pushedGitRefs = new ArrayList<GitRef>();
            try (AutoDelete tempDir = DSSTempUtils.getTempFolder((String)"lib-pushs");){
                for (Map.Entry<String, GitModel.GitReference> gitRefEntry : gitReferences.entrySet()) {
                    if (gitRefEntry.getValue().conflictingFiles == null || gitRefEntry.getValue().conflictingFiles.isEmpty()) {
                        GitRef pushGitRef = this.pushGitRef_NT(gitRefEntry, (File)tempDir, messages);
                        if (pushGitRef == null) continue;
                        pushedGitRefs.add(pushGitRef);
                        continue;
                    }
                    messages.withErrorV((InfoMessage.MessageCode)GitCodes.INFO_GIT_LIBRARY_STILL_HAVE_CONFLICT, "%s is in conflict. Please resolve conflicts before. Files in conflict: %s", new Object[]{gitRefEntry.getKey(), String.join((CharSequence)"; ", gitRefEntry.getValue().conflictingFiles)});
                }
                this.saveGitRefs(pushedGitRefs);
            }
            return messages;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private GitRef pushGitRef_NT(Map.Entry<String, GitModel.GitReference> gitRefEntry, File contextualTmpDir, InfoMessage.InfoMessages messages) {
            TransactionContext.assertNoAttachedTransaction();
            GitModel.GitReference gitRef = gitRefEntry.getValue();
            try {
                File gitCloneTmpDirectory = new File(contextualTmpDir, SecretKeyGenerator.generate((int)8));
                DKUFileUtils.mkdirs((File)gitCloneTmpDirectory);
                FutureProgress.pushState((String)(GitReferencesService.PUSH_LIBRARY_TEXT + gitRefEntry.getKey()));
                GitRemoteCommands gitRemoteCommands = new GitRemoteCommands(gitCloneTmpDirectory);
                gitRemoteCommands.clone(this.owner, GitReferencesService.this.getGitReferenceRemoteURL(gitRef), gitRef.checkout, ".", true);
                try (Git git = Git.open((File)gitCloneTmpDirectory);){
                    GitLocalCommands gitLocalCommands = new GitLocalCommands(git);
                    gitLocalCommands.disableSymlinksIfNeeded();
                    gitLocalCommands.disableHooksIfNeeded();
                    gitLocalCommands.hardResetTo(gitRef.lastHash);
                    File subFolder = new File(gitCloneTmpDirectory, gitRef.remotePath);
                    DKUFileUtils.mkdirs((File)subFolder);
                    this.copyLocalLibsToTmpGit(gitRefEntry, subFolder);
                    if (!this.addModificationsToGit(git)) {
                        FutureProgress.popState();
                        FutureProgress.pushState((String)(GitReferencesService.LIBRARY_TEXT + gitRefEntry.getKey() + ", already up to date."));
                        messages.withInfo((InfoMessage.MessageCode)GitCodes.INFO_GIT_ALREADY_UP_TO_DATE, GitReferencesService.LIBRARY_TEXT + gitRefEntry.getKey() + ". No modifications detected");
                        if (gitRef.resolvedFiles != null && !gitRef.resolvedFiles.isEmpty()) {
                            GitRef gitRef2 = new GitRef(gitRefEntry, null, gitRemoteCommands.getHashFor("HEAD"));
                            return gitRef2;
                        }
                        GitRef gitRef3 = null;
                        return gitRef3;
                    }
                    DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
                    GitRemoteCommands.GitCommandResult commandResult = this.commitAndRebase(git, gitRemoteCommands, gitRef, smartLogTailBuilder);
                    if (!commandResult.commandSucceeded) {
                        FutureProgress.popState();
                        FutureProgress.pushState((String)(GitReferencesService.PUSH_LIBRARY_TEXT + gitRefEntry.getKey() + ". Conflict detected."));
                        GitRef gitRef4 = this.handleConflict(gitRefEntry, messages, gitCloneTmpDirectory);
                        return gitRef4;
                    }
                    commandResult = gitRemoteCommands.pushWithLogTail(this.owner, "origin", gitRef.checkout, false, smartLogTailBuilder);
                    if (!commandResult.commandSucceeded) {
                        FutureProgress.popState();
                        FutureProgress.pushState((String)("Failed to push the library: " + gitRefEntry.getKey()));
                        messages.mergeFrom(commandResult.messages);
                        GitRef gitRef5 = null;
                        return gitRef5;
                    }
                    FutureProgress.popState();
                    FutureProgress.pushState((String)("Pushed the library: " + gitRefEntry.getKey()));
                    messages.withSuccess((InfoMessage.MessageCode)GitCodes.INFO_GIT_PUSH_OK, GitReferencesService.LIBRARY_TEXT + gitRefEntry.getKey());
                    GitRef gitRef6 = new GitRef(gitRefEntry, subFolder, gitRemoteCommands.getHashFor("HEAD"));
                    return gitRef6;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                GitReferencesService.this.couldNotDoSmthWithGitReferences(gitRefEntry, messages, gitRef, ex, GitCodes.ERR_GIT_PUSH_FAILED);
                return null;
            }
            catch (Exception ex) {
                GitReferencesService.this.couldNotDoSmthWithGitReferences(gitRefEntry, messages, gitRef, ex, GitCodes.ERR_GIT_PUSH_FAILED);
                return null;
            }
        }

        private GitRemoteCommands.GitCommandResult commitAndRebase(Git git, GitRemoteCommands gitRemoteCommands, GitModel.GitReference gitRef, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws GitAPIException {
            GitModel.GitAuthor gitAuthor = new GitModel.GitAuthor((AuthCtx)this.owner);
            git.commit().setSign(Boolean.valueOf(false)).setMessage(this.commitMessage).setAuthor(gitAuthor.name, gitAuthor.getEmailOrName()).call();
            return gitRemoteCommands.pullRebase(this.owner, "origin", gitRef.checkout, null, smartLogTailBuilder, false);
        }

        private GitRef handleConflict(Map.Entry<String, GitModel.GitReference> gitRefEntry, InfoMessage.InfoMessages messages, File gitCloneTmpDirectory) throws InterruptedException, CodedException, IOException {
            GitModel.GitReference gitRef = gitRefEntry.getValue();
            GitRemoteCommands gitRemoteCommands = new GitRemoteCommands(gitCloneTmpDirectory);
            Set<String> conflictFiles = gitRemoteCommands.listFilesUnmerged(gitRef.remotePath);
            String gitRefEntryId = gitRefEntry.getKey();
            NativeFS conflictTempFolder = GitReferencesService.this.getConflictTempFolder(this.projectKey);
            RelFile libRootFile = AdminEditionController.GlobalCodeZone.LIB.getPath(this.projectKey).appendStrictChildPath(gitRefEntryId);
            conflictTempFolder.deleteDirectory(gitRefEntryId);
            try (Transaction t = GitReferencesService.this.transactionService.beginRead();){
                FSUtils.newRecursiveCopy().from((ReadOnlyFS)t, libRootFile).to((ReadWriteFS)conflictTempFolder, gitRefEntryId).run();
            }
            StringJoiner joiner = new StringJoiner("'; '", GitReferencesService.LIBRARY_TEXT + gitRefEntry.getKey() + ". Conflict detected: '", "'");
            for (String conflictFile : conflictFiles) {
                messages.withError((InfoMessage.MessageCode)GitCodes.INFO_GIT_PUSH_CONFLICTING_FILE, conflictFile);
                joiner.add(conflictFile);
            }
            messages.withError((InfoMessage.MessageCode)GitCodes.ERR_GIT_REBASE_FAILED, joiner.toString());
            return new GitRef(gitRefEntry, new File(gitCloneTmpDirectory, gitRef.remotePath), conflictFiles, gitRemoteCommands.getHashFor("HEAD"));
        }

        private boolean addModificationsToGit(Git git) throws GitAPIException {
            Status status = git.status().call();
            Set missing = status.getMissing();
            if (!missing.isEmpty()) {
                RmCommand rmCommand = git.rm();
                for (String missingFile : missing) {
                    rmCommand = rmCommand.addFilepattern(missingFile);
                }
                rmCommand.call();
            }
            git.add().addFilepattern(".").call();
            return !status.isClean();
        }

        private void copyLocalLibsToTmpGit(Map.Entry<String, GitModel.GitReference> gitRefEntry, File gitCloneTmpDirectory) throws IOException {
            String gitRefEntryId = gitRefEntry.getKey();
            RelFile src = AdminEditionController.GlobalCodeZone.LIB.getPath(this.projectKey).appendStrictChildPath(gitRefEntryId);
            NativeFS dest = NativeFS.from((File)gitCloneTmpDirectory).build();
            List gitRoot = dest.listFiles("", (RelFileFilter)new NoGitRelFileFilter());
            for (RelFile relFile : gitRoot) {
                if (dest.isDirectory(relFile)) {
                    dest.deleteDirectory(relFile);
                    continue;
                }
                if (!dest.isFile(relFile)) continue;
                dest.deleteFile(relFile);
            }
            try (Transaction t = GitReferencesService.this.transactionService.beginRead();){
                FSUtils.newRecursiveCopy().from((ReadOnlyFS)t, src).to((ReadWriteFS)dest).filter((RelFileFilter)new NoGitRelFileFilter()).run();
            }
        }
    }

    private class GitRef {
        final File directory;
        final Map.Entry<String, GitModel.GitReference> gitRefEntry;
        final String hash;
        final Set<String> conflictingFiles;
        final boolean isDirty;

        public GitRef(Map.Entry<String, GitModel.GitReference> gitRefEntry, File directory, String hash) {
            this.directory = directory;
            this.gitRefEntry = gitRefEntry;
            this.hash = hash;
            this.conflictingFiles = null;
            this.isDirty = false;
        }

        public GitRef(Map.Entry<String, GitModel.GitReference> gitRefEntry, File gitCloneTmpDirectory, Set<String> filesUnmerged, String hash) {
            this.directory = gitCloneTmpDirectory;
            gitRefEntry.getValue().faultyHash = gitRefEntry.getValue().lastHash;
            this.gitRefEntry = gitRefEntry;
            this.hash = hash;
            this.conflictingFiles = filesUnmerged;
            this.isDirty = false;
        }
    }

    public static class NoGitRelFileFilter
    implements RelFileFilter {
        public boolean accept(ReadOnlyFS fs, RelFile file) {
            return !".git".equals(file.getLeafName()) && !".gitignore".equals(file.getLeafName());
        }
    }

    private abstract class GitReferencesFutureThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        protected String projectKey;
        protected String gitRefPath;
        protected final FuturePayload futurePayload;

        GitReferencesFutureThread(String projectKey, AuthCtx authCtx, String payloadAction, String payloadDisplayName) {
            super(authCtx);
            this.projectKey = projectKey;
            this.futurePayload = this.buildFuturePayload(projectKey, payloadAction, payloadDisplayName);
        }

        GitReferencesFutureThread(String projectKey, AuthCtx authCtx, String payloadAction, String payloadDisplayName, String gitRefPath) {
            this(projectKey, authCtx, payloadAction, payloadDisplayName);
            this.gitRefPath = gitRefPath;
        }

        private FuturePayload buildFuturePayload(String projectKey, String action, String displayName) {
            FuturePayload fp = new FuturePayload();
            fp.action = action;
            fp.targets.add(new FuturePayload.FuturePayloadTarget(StringUtils.defaultIfBlank((String)projectKey, (String)"instance libs"), "GIT_REF"));
            fp.displayName = displayName;
            return fp;
        }

        protected Map<String, GitModel.GitReference> loadGitReferences() throws IOException, CodedException {
            Map gitReferences;
            try (Transaction t = GitReferencesService.this.transactionService.beginRead();){
                gitReferences = GitReferencesService.this.getProjectGitReferences(this.projectKey);
            }
            if (StringUtils.isNotBlank((String)this.gitRefPath) && (gitReferences = Maps.filterKeys(gitReferences, (Predicate)Predicates.equalTo((Object)this.gitRefPath))).isEmpty()) {
                throw new IllegalArgumentException(String.format("No Git reference was found with the id '%s'", this.gitRefPath));
            }
            return gitReferences;
        }

        protected void saveGitRefs(List<GitRef> gitRefs) throws IOException, CodedException {
            if (gitRefs == null || gitRefs.isEmpty()) {
                return;
            }
            HashMap<File, InMemoryCache> cachedTempDirs = new HashMap<File, InMemoryCache>();
            NoGitRelFileFilter noGitFilter = new NoGitRelFileFilter();
            for (GitRef gitRef : gitRefs) {
                if (gitRef.directory == null) continue;
                Stopwatch sw = Stopwatch.createStarted();
                InMemoryCache inMemoryCache = new InMemoryCache((ReadOnlyFS)NativeFS.from((File)gitRef.directory).build());
                inMemoryCache.listRecursive(RelFile.root(), (RelFileFilter)noGitFilter).parallelStream().forEach(rf -> {
                    try {
                        if (cachedTempDir.isFile(rf) && noGitFilter.accept((ReadOnlyFS)cachedTempDir, (RelFile)rf)) {
                            cachedTempDir.getHash(rf);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                cachedTempDirs.put(gitRef.directory, inMemoryCache);
                logger.info((Object)("Computed hashes of " + String.valueOf(gitRef.directory) + " in " + DKUtils.getElapsed((Stopwatch)sw)));
            }
            try (RWTransaction t = GitReferencesService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                Map<String, GitModel.GitReference> gitReferences = GitReferencesService.this.getProjectGitReferences(this.projectKey);
                for (GitRef gitRef : gitRefs) {
                    String gitRefEntryId = gitRef.gitRefEntry.getKey();
                    GitModel.GitReference updatedGitRef = gitRef.gitRefEntry.getValue();
                    if (gitRef.directory != null) {
                        Stopwatch sw = Stopwatch.createStarted();
                        RelFile libRoot = AdminEditionController.GlobalCodeZone.LIB.getPath(this.projectKey).appendStrictChildPath(gitRefEntryId);
                        FSUtils.newRecursiveSync().from((ReadOnlyFS)cachedTempDirs.get(gitRef.directory)).to((ReadWriteFS)t, libRoot).filter((RelFileFilter)noGitFilter).overwriteMode(FSUtils.OverwriteMode.SKIP_UNLESS_HASH_CHANGED).run();
                        logger.info((Object)("Diffed changes from " + String.valueOf(gitRef.directory) + " against " + String.valueOf(libRoot) + " in " + DKUtils.getElapsed((Stopwatch)sw)));
                    }
                    if (gitRef.conflictingFiles == null || gitRef.conflictingFiles.isEmpty()) {
                        updatedGitRef.conflictingFiles = new HashSet();
                        updatedGitRef.faultyHash = "";
                    } else {
                        updatedGitRef.faultyHash = updatedGitRef.lastHash;
                        updatedGitRef.lastHash = gitRef.hash;
                        updatedGitRef.conflictingFiles = gitRef.conflictingFiles;
                    }
                    updatedGitRef.resolvedFiles = new HashSet();
                    updatedGitRef.lastHash = gitRef.hash;
                    updatedGitRef.isDirty = false;
                    gitReferences.put(gitRefEntryId, updatedGitRef);
                }
                for (Map.Entry entry : gitReferences.entrySet()) {
                    ((GitModel.GitReference)entry.getValue()).remotePassword = GitReferencesService.this.passwordEncryptionService.encryptIfNotEncryptedOrEmpty(((GitModel.GitReference)entry.getValue()).remotePassword);
                }
                GitReferencesService.this.setProjectGitReferences(this.projectKey, gitReferences);
                t.commitV("Git references update for %s", new Object[]{this.projectKey});
            }
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }
}

