/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class AppliesToUtils {
    public static List<Column> getColumnsForMemTable(AppliesToProcessor.AppliesToParams params, MemTable table) {
        switch (params.appliesTo) {
            case SINGLE_COLUMN: {
                return Lists.newArrayList((Object[])new Column[]{table.column(params.columns.get(0), Processor.ProcessorRole.INPUT_COLUMN)});
            }
            case COLUMNS: {
                ArrayList<Column> columnList = new ArrayList<Column>();
                for (String col : params.columns) {
                    columnList.add(table.column(col, Processor.ProcessorRole.INPUT_COLUMN));
                }
                return columnList;
            }
            case PATTERN: {
                final Pattern p = Pattern.compile(params.appliesToPattern);
                return FluentIterable.from(table.columns()).filter((Predicate)new Predicate<Column>(){

                    public boolean apply(Column arg0) {
                        return p.matcher(arg0.getName()).matches();
                    }
                }).toList();
            }
            case ALL: {
                return Lists.newArrayList(table.columns());
            }
        }
        throw new Error("unreachable");
    }
}

