/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.recipes.RecipeDeserializer;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpointDeserializer;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class StreamingEndpointsRegistry {
    private static final Map<String, StreamingEndpointMeta> library = new LinkedHashMap<String, StreamingEndpointMeta>();

    public static StreamingEndpointMeta getMeta(StreamingEndpoint endpoint) {
        return StreamingEndpointsRegistry.getMeta(endpoint.type);
    }

    public static synchronized StreamingEndpointMeta getMeta(String type) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)type), (Object)"Recipe type is not specified");
        if (library.containsKey(type)) {
            return library.get(type);
        }
        if (type.startsWith("Custom")) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Unknown streaming endpoint type: " + type);
        }
        throw new Error("Unknown streaming endpoint type " + type);
    }

    public static synchronized void register(StreamingEndpointMeta meta) {
        StreamingEndpointDeserializer.registerType(meta.getType(), meta.paramsClass());
        library.put(meta.getType(), meta);
    }

    public static void loadClass() {
        DKUtils.forceInit(RecipeDeserializer.class);
    }
}

