/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.httpsse;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.http.ConnectionClosedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class SSEDecoder {
    private boolean interrupted;
    private final BufferedReader br;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.sseclient");

    public SSEDecoder(InputStream stream) {
        this.br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8), 10);
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void close() throws IOException {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (ConnectionClosedException e) {
                logger.info((Object)"Connection is closed");
            }
            catch (IOException e) {
                throw new IOException("Failed to close httpsse decoder", e);
            }
        }
    }

    public HTTPSSEEvent next() throws IOException {
        String line;
        StringBuilder data = new StringBuilder();
        String eventName = null;
        String eventId = null;
        while (!this.interrupted && (line = this.br.readLine()) != null) {
            String fieldValue;
            String fieldName;
            int indexOfColon = line.indexOf(58);
            if (line.length() == 0) {
                String body;
                if (data.length() <= 0) continue;
                if (eventName == null) {
                    eventName = "message";
                }
                if ((body = data.toString()).endsWith("\n")) {
                    body = body.substring(0, body.length() - 1);
                }
                return new HTTPSSEEvent(eventName, eventId, body);
            }
            if (indexOfColon == 0) {
                logger.info((Object)("Stream comment: " + line));
                continue;
            }
            if (indexOfColon < 0) {
                fieldName = line;
                fieldValue = "";
            } else {
                fieldName = line.substring(0, indexOfColon);
                fieldValue = line.substring(indexOfColon + 1);
            }
            if (fieldValue.startsWith(" ")) {
                fieldValue = fieldValue.substring(1);
            }
            if ("data".equals(fieldName)) {
                data.append(fieldValue);
                data.append("\n");
                continue;
            }
            if ("event".equals(fieldName)) {
                eventName = fieldValue;
                continue;
            }
            if ("id".equals(fieldName)) {
                eventId = fieldValue;
                continue;
            }
            logger.warn((Object)("+ Unknown field : " + line));
        }
        return null;
    }

    public static class HTTPSSEEvent {
        public String type;
        public String eventId;
        public String data;

        public HTTPSSEEvent(String type, String eventId, String data) {
            this.type = type;
            this.eventId = eventId;
            this.data = data;
        }
    }
}

