/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.model.api;

import com.dataiku.lambda.model.api.PredictionResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VertexAIResponse {
    public List<?> predictions;

    public VertexAIResponse(List<?> predictions) {
        this.predictions = predictions;
    }

    public VertexAIResponse(PredictionResponse presp) {
        this.predictions = presp.results.stream().map(this::convertResponseItemToVertexFormat).collect(Collectors.toList());
    }

    private Object convertResponseItemToVertexFormat(PredictionResponse.PredictionResponseItem item) {
        if (item instanceof PredictionResponse.ClassificationResponseItem) {
            PredictionResponse.ClassificationResponseItem classifItem = (PredictionResponse.ClassificationResponseItem)item;
            if (classifItem.probas == null) {
                return new Item(classifItem.prediction);
            }
            ArrayList<String> classes = new ArrayList<String>();
            ArrayList<Double> scores = new ArrayList<Double>();
            for (Map.Entry<String, Double> entry : classifItem.probas.entrySet()) {
                classes.add(entry.getKey());
                scores.add(entry.getValue());
            }
            return new Item(classes, scores);
        }
        if (item instanceof PredictionResponse.RegressionResponseItem) {
            PredictionResponse.RegressionResponseItem regItem = (PredictionResponse.RegressionResponseItem)item;
            return new Item(regItem.prediction);
        }
        return item;
    }

    public static class Item {
        @Nullable
        Double value;
        @Nullable
        List<String> classes;
        @Nullable
        List<Double> scores;
        @Nullable
        String prediction;

        public Item(@Nonnull Double value) {
            this.value = value;
        }

        public Item(@Nonnull List<String> classes, @Nonnull List<Double> scores) {
            this.classes = classes;
            this.scores = scores;
        }

        public Item(@Nonnull String prediction) {
            this.prediction = prediction;
        }
    }
}

