/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;

public class Rand
implements Function {
    @Override
    public String checkArguments(Evaluable[] args) {
        return args.length == 0 || args.length == 2 ? null : GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects either no arguments or two long integers";
    }

    @Override
    public Object call(Properties bindings, Object[] args) {
        long max;
        if (args.length == 0) {
            return ThreadLocalRandom.current().nextDouble();
        }
        if (args.length != 2 || !(args[0] instanceof Number) || !(args[1] instanceof Number) || args[0] instanceof Double && (Double)args[0] % 1.0 != 0.0 || args[1] instanceof Double && (Double)args[1] % 1.0 != 0.0) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects either no arguments or two long integers");
        }
        long min = ((Number)args[0]).longValue();
        if (min >= (max = ((Number)args[1]).longValue())) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects min (" + min + ") to be strictly less than max (" + max + ")");
        }
        if (min < 0L) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects min (" + min + ") and max (" + max + ") to be positive integers");
        }
        return ThreadLocalRandom.current().nextLong(min, max);
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Rand.DOCUMENTATION", "Without arguments, returns a random float between 0 and 1.<br/>With two positive long integers as min and max arguments, returns a random long integer between min (inclusive) and max (exclusive).").withParams("[long min]", "[long max]").withReturns("double or long").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("0", "24").returns("17"));
    }
}

