/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class StreamUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static BufferedReader readStream(InputStream input, String encoding) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(input, encoding));
    }

    public static BufferedReader readStream(InputStream input) {
        try {
            return StreamUtils.readStream(input, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            return null;
        }
    }

    public static BufferedReader readFile(File f, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        FileInputStream fis = new FileInputStream(f.getPath());
        InputStreamReader in = new InputStreamReader((InputStream)fis, encoding);
        return new BufferedReader(in);
    }

    public static BufferedReader readFile(File f) throws FileNotFoundException {
        try {
            return StreamUtils.readFile(f, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            return null;
        }
    }

    public static BufferedOutputStream readFD(FileDescriptor fd, String encoding) {
        return new BufferedOutputStream(new FileOutputStream(FileDescriptor.in));
    }

    public static BufferedOutputStream readFD(FileDescriptor fd) {
        return StreamUtils.readFD(fd, DEFAULT_ENCODING);
    }

    public static BufferedWriter writeToFile(File f, String encoding, boolean append) throws FileNotFoundException, UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f, append), encoding));
    }

    public static BufferedWriter writeToFile(File f, boolean append) throws FileNotFoundException {
        try {
            return StreamUtils.writeToFile(f, DEFAULT_ENCODING, append);
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            return null;
        }
    }

    public static void skip(InputStream i, long n) throws IOException {
        long skipped;
        while (n > 0L && (skipped = i.skip(n)) != 0L) {
            n -= skipped;
        }
    }

    public static byte[] streamToByteArray(InputStream stream, long probableSize) throws IOException {
        int readByte;
        byte[] data = new byte[(int)Math.min(probableSize, Integer.MAX_VALUE)];
        for (int offset = 0; offset < data.length; offset += readByte) {
            readByte = stream.read(data, offset, data.length - offset);
            if (readByte != -1) continue;
            return Arrays.copyOf(data, offset);
        }
        readByte = stream.read();
        if (readByte != -1) {
            byte[] remaining = IOUtils.toByteArray((InputStream)stream);
            long totalSize = 1L + (long)data.length + (long)remaining.length;
            if (totalSize > Integer.MAX_VALUE) {
                throw new IOException("Stream too long");
            }
            byte[] output = new byte[(int)totalSize];
            System.arraycopy(data, 0, output, 0, data.length);
            output[data.length] = (byte)readByte;
            System.arraycopy(remaining, 0, output, data.length + 1, remaining.length);
            return output;
        }
        return data;
    }

    private StreamUtils() {
    }
}

