/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource;

import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedSetDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.FunctionValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SortField;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SortedSetSelector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SortedSetSortField;
import java.io.IOException;
import java.util.Map;

public class SortedSetFieldSource
extends FieldCacheSource {
    protected final SortedSetSelector.Type selector;

    public SortedSetFieldSource(String field) {
        this(field, SortedSetSelector.Type.MIN);
    }

    public SortedSetFieldSource(String field, SortedSetSelector.Type selector) {
        super(field);
        this.selector = selector;
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortedSetSortField(this.field, reverse, this.selector);
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        SortedSetDocValues sortedSet = DocValues.getSortedSet(readerContext.reader(), this.field);
        SortedDocValues view = SortedSetSelector.wrap(sortedSet, this.selector);
        return new DocTermsIndexDocValues(this, view){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public Object objectVal(int doc) throws IOException {
                return this.strVal(doc);
            }
        };
    }

    @Override
    public String description() {
        return "sortedset(" + this.field + ",selector=" + this.selector + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortedSetFieldSource other = (SortedSetFieldSource)obj;
        return this.selector == other.selector;
    }
}

