/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.iterators;

import com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc.IntArrayList;
import java.io.IOException;

public interface OrdinalIterator {
    public static final int NO_MORE_ORDS = -1;
    public static final OrdinalIterator EMPTY = () -> -1;

    public int nextOrd() throws IOException;

    default public int[] toArray() throws IOException {
        IntArrayList resultList = new IntArrayList();
        int ord = this.nextOrd();
        while (ord != -1) {
            resultList.add(ord);
            ord = this.nextOrd();
        }
        return resultList.toArray();
    }

    public static OrdinalIterator fromArray(final int[] source) {
        return new OrdinalIterator(){
            int cursor;

            @Override
            public int nextOrd() throws IOException {
                while (this.cursor < source.length) {
                    int ord;
                    if ((ord = source[this.cursor++]) == -1) continue;
                    return ord;
                }
                return -1;
            }
        };
    }
}

