/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.search.CollectionTerminatedException;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Collector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdStream;
import com.dataiku.dss.shadelib.org.apache.lucene.search.LeafCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorable;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import java.io.IOException;

public class TotalHitCountCollector
implements Collector {
    private Weight weight;
    private int totalHits;

    public int getTotalHits() {
        return this.totalHits;
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        int leafCount;
        int n = leafCount = this.weight == null ? -1 : this.weight.count(context);
        if (leafCount != -1) {
            this.totalHits += leafCount;
            throw new CollectionTerminatedException();
        }
        return new LeafCollector(){

            @Override
            public void setScorer(Scorable scorer) throws IOException {
            }

            @Override
            public void collect(int doc) throws IOException {
                ++TotalHitCountCollector.this.totalHits;
            }

            @Override
            public void collect(DocIdStream stream) throws IOException {
                TotalHitCountCollector.this.totalHits += stream.count();
            }
        };
    }
}

