/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util.fst;

import com.dataiku.dss.shadelib.org.apache.lucene.store.DataInput;
import com.dataiku.dss.shadelib.org.apache.lucene.store.DataOutput;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IntsRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.fst.Outputs;
import java.io.IOException;
import java.util.Arrays;

public final class IntSequenceOutputs
extends Outputs<IntsRef> {
    private static final IntsRef NO_OUTPUT = new IntsRef();
    private static final IntSequenceOutputs singleton = new IntSequenceOutputs();
    private static final long BASE_NUM_BYTES = RamUsageEstimator.shallowSizeOf(NO_OUTPUT);

    private IntSequenceOutputs() {
    }

    public static IntSequenceOutputs getSingleton() {
        return singleton;
    }

    @Override
    public IntsRef common(IntsRef output1, IntsRef output2) {
        assert (output1 != null);
        assert (output2 != null);
        int mismatchPos = Arrays.mismatch(output1.ints, output1.offset, output1.offset + output1.length, output2.ints, output2.offset, output2.offset + output2.length);
        if (mismatchPos == 0) {
            return NO_OUTPUT;
        }
        if (mismatchPos == -1) {
            return output1;
        }
        if (mismatchPos == output1.length) {
            return output1;
        }
        if (mismatchPos == output2.length) {
            return output2;
        }
        return new IntsRef(output1.ints, output1.offset, mismatchPos);
    }

    @Override
    public IntsRef subtract(IntsRef output, IntsRef inc) {
        assert (output != null);
        assert (inc != null);
        if (inc == NO_OUTPUT) {
            return output;
        }
        if (inc.length == output.length) {
            return NO_OUTPUT;
        }
        assert (inc.length < output.length) : "inc.length=" + inc.length + " vs output.length=" + output.length;
        assert (inc.length > 0);
        return new IntsRef(output.ints, output.offset + inc.length, output.length - inc.length);
    }

    @Override
    public IntsRef add(IntsRef prefix, IntsRef output) {
        assert (prefix != null);
        assert (output != null);
        if (prefix == NO_OUTPUT) {
            return output;
        }
        if (output == NO_OUTPUT) {
            return prefix;
        }
        assert (prefix.length > 0);
        assert (output.length > 0);
        IntsRef result = new IntsRef(prefix.length + output.length);
        System.arraycopy(prefix.ints, prefix.offset, result.ints, 0, prefix.length);
        System.arraycopy(output.ints, output.offset, result.ints, prefix.length, output.length);
        result.length = prefix.length + output.length;
        return result;
    }

    @Override
    public void write(IntsRef prefix, DataOutput out) throws IOException {
        assert (prefix != null);
        out.writeVInt(prefix.length);
        for (int idx = 0; idx < prefix.length; ++idx) {
            out.writeVInt(prefix.ints[prefix.offset + idx]);
        }
    }

    @Override
    public IntsRef read(DataInput in) throws IOException {
        int len = in.readVInt();
        if (len == 0) {
            return NO_OUTPUT;
        }
        IntsRef output = new IntsRef(len);
        for (int idx = 0; idx < len; ++idx) {
            output.ints[idx] = in.readVInt();
        }
        output.length = len;
        return output;
    }

    @Override
    public void skipOutput(DataInput in) throws IOException {
        int len = in.readVInt();
        if (len == 0) {
            return;
        }
        for (int idx = 0; idx < len; ++idx) {
            in.readVInt();
        }
    }

    @Override
    public IntsRef getNoOutput() {
        return NO_OUTPUT;
    }

    @Override
    public String outputToString(IntsRef output) {
        return output.toString();
    }

    @Override
    public long ramBytesUsed(IntsRef output) {
        return BASE_NUM_BYTES + RamUsageEstimator.sizeOf(output.ints);
    }

    public String toString() {
        return "IntSequenceOutputs";
    }
}

