/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server;

import com.dataiku.dss.shadelib.org.eclipse.jetty.io.ByteBufferPool;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.handler.ContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Attributes;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.DecoratedObjectFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.LifeCycle;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.compression.DeflaterPool;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.compression.InflaterPool;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.WebSocketComponents;
import java.util.concurrent.Executor;

public class WebSocketServerComponents
extends WebSocketComponents {
    public static final String WEBSOCKET_COMPONENTS_ATTRIBUTE = WebSocketComponents.class.getName();
    public static final String WEBSOCKET_INFLATER_POOL_ATTRIBUTE = "jetty.websocket.inflater";
    public static final String WEBSOCKET_DEFLATER_POOL_ATTRIBUTE = "jetty.websocket.deflater";
    public static final String WEBSOCKET_BUFFER_POOL_ATTRIBUTE = "jetty.websocket.bufferPool";

    WebSocketServerComponents(InflaterPool inflaterPool, DeflaterPool deflaterPool, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory, Executor executor) {
        super(null, objectFactory, bufferPool, inflaterPool, deflaterPool, executor);
    }

    public static WebSocketComponents ensureWebSocketComponents(Server server, ContextHandler contextHandler) {
        return WebSocketServerComponents.ensureWebSocketComponents(server, contextHandler.getContext(), contextHandler);
    }

    public static WebSocketComponents ensureWebSocketComponents(Server server) {
        return WebSocketServerComponents.ensureWebSocketComponents(server, server.getContext(), server);
    }

    private static WebSocketComponents ensureWebSocketComponents(Server server, final Attributes attributes, final ContainerLifeCycle container) {
        Executor executor;
        ByteBufferPool bufferPool;
        DeflaterPool deflaterPool;
        WebSocketComponents components = (WebSocketComponents)attributes.getAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
        if (components != null) {
            return components;
        }
        InflaterPool inflaterPool = (InflaterPool)attributes.getAttribute(WEBSOCKET_INFLATER_POOL_ATTRIBUTE);
        if (inflaterPool == null) {
            inflaterPool = InflaterPool.ensurePool(server);
        }
        if ((deflaterPool = (DeflaterPool)attributes.getAttribute(WEBSOCKET_DEFLATER_POOL_ATTRIBUTE)) == null) {
            deflaterPool = DeflaterPool.ensurePool(server);
        }
        if ((bufferPool = (ByteBufferPool)attributes.getAttribute(WEBSOCKET_BUFFER_POOL_ATTRIBUTE)) == null) {
            bufferPool = server.getByteBufferPool();
        }
        if ((executor = (Executor)attributes.getAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.server.Executor")) == null) {
            executor = server.getThreadPool();
        }
        DecoratedObjectFactory objectFactory = (DecoratedObjectFactory)attributes.getAttribute(DecoratedObjectFactory.ATTR);
        final WebSocketServerComponents serverComponents = new WebSocketServerComponents(inflaterPool, deflaterPool, bufferPool, objectFactory, executor);
        if (objectFactory != null) {
            serverComponents.unmanage(objectFactory);
        }
        if (server.contains(inflaterPool)) {
            serverComponents.unmanage(inflaterPool);
        }
        if (server.contains(deflaterPool)) {
            serverComponents.unmanage(deflaterPool);
        }
        if (server.contains(bufferPool)) {
            serverComponents.unmanage(bufferPool);
        }
        if (executor != null) {
            serverComponents.unmanage(executor);
        }
        container.addManaged(serverComponents);
        attributes.setAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE, serverComponents);
        container.addEventListener(new LifeCycle.Listener(){

            @Override
            public void lifeCycleStopping(LifeCycle event) {
                attributes.removeAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
                container.removeBean(serverComponents);
                container.removeEventListener(this);
            }

            public String toString() {
                return String.format("%sCleanupListener", WebSocketServerComponents.class.getSimpleName());
            }
        });
        return serverComponents;
    }

    public static WebSocketComponents getWebSocketComponents(ContextHandler contextHandler) {
        return WebSocketServerComponents.getWebSocketComponents(contextHandler.getContext());
    }

    public static WebSocketComponents getWebSocketComponents(Server server) {
        return WebSocketServerComponents.getWebSocketComponents(server.getContext());
    }

    private static WebSocketComponents getWebSocketComponents(Attributes attributes) {
        WebSocketComponents components = (WebSocketComponents)attributes.getAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
        if (components == null) {
            throw new IllegalStateException("WebSocketComponents has not been created");
        }
        return components;
    }
}

