/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import java.util.Map;
import java.util.Set;

public class DatetimeCyclicalEncoder
implements Processor {
    private static final long serialVersionUID = 0L;
    public Map<String, Set<Period>> mapping;

    public DatetimeCyclicalEncoder(Map<String, Set<Period>> mapping) {
        this.mapping = mapping;
    }

    public static LocalDateTime getTruncatedDateTime(Period period, LocalDateTime dateTime) {
        switch (period) {
            case MINUTE: {
                return dateTime.truncatedTo(ChronoUnit.MINUTES);
            }
            case HOUR: {
                return dateTime.truncatedTo(ChronoUnit.HOURS);
            }
            case DAY: {
                return dateTime.truncatedTo(ChronoUnit.DAYS);
            }
            case WEEK: {
                return dateTime.truncatedTo(ChronoUnit.DAYS).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
            }
            case MONTH: {
                return dateTime.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
            }
            case QUARTER: {
                return dateTime.truncatedTo(ChronoUnit.DAYS).with(IsoFields.DAY_OF_QUARTER, 1L);
            }
            case YEAR: {
                return dateTime.truncatedTo(ChronoUnit.DAYS).withDayOfYear(1);
            }
        }
        throw new IllegalArgumentException("Unknown period: " + period.name());
    }

    @Override
    public void process(RawObservation data) {
        LocalDateTime origin = LocalDateTime.of(1900, 1, 1, 0, 0, 0);
        for (Map.Entry<String, Set<Period>> entry : this.mapping.entrySet()) {
            String column = entry.getKey();
            Double timestamp = data.getAsDouble(column) * 1000.0;
            LocalDateTime dateTime = origin.plus(Duration.of(timestamp.longValue(), ChronoUnit.MILLIS));
            for (Period period : entry.getValue()) {
                long secondsSubPeriod = ChronoUnit.SECONDS.between(DatetimeCyclicalEncoder.getTruncatedDateTime(period, dateTime), dateTime);
                double trigoArg = (double)(secondsSubPeriod * 2L) * Math.PI / (double)period.durationInSeconds;
                String prefix = "datetime_cyclical:" + column + ":" + period.name().toLowerCase() + ":";
                data.put(prefix + "sin", Math.sin(trigoArg));
                data.put(prefix + "cos", Math.cos(trigoArg));
            }
        }
    }

    public static enum Period {
        MINUTE(60),
        HOUR(3600),
        DAY(86400),
        WEEK(604800),
        MONTH(2678400),
        QUARTER(7948800),
        YEAR(31622400);

        public final int durationInSeconds;

        private Period(int durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }
    }
}

