/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel;

import com.dataiku.dss.shadelibpoi.org.apache.poi.common.usermodel.HyperlinkType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.common.ExtendedColor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFExtendedColor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFHyperlink;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CreationHelper;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.AreaReference;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellReference;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.Internal;

public class HSSFCreationHelper
implements CreationHelper {
    private final HSSFWorkbook workbook;

    @Internal(since="3.15 beta 3")
    HSSFCreationHelper(HSSFWorkbook wb) {
        this.workbook = wb;
    }

    @Override
    public HSSFRichTextString createRichTextString(String text) {
        return new HSSFRichTextString(text);
    }

    @Override
    public HSSFDataFormat createDataFormat() {
        return this.workbook.createDataFormat();
    }

    @Override
    public HSSFHyperlink createHyperlink(HyperlinkType type) {
        return new HSSFHyperlink(type);
    }

    @Override
    public HSSFExtendedColor createExtendedColor() {
        return new HSSFExtendedColor(new ExtendedColor());
    }

    @Override
    public HSSFFormulaEvaluator createFormulaEvaluator() {
        return new HSSFFormulaEvaluator(this.workbook);
    }

    @Override
    public HSSFClientAnchor createClientAnchor() {
        return new HSSFClientAnchor();
    }

    @Override
    public AreaReference createAreaReference(String reference) {
        return new AreaReference(reference, this.workbook.getSpreadsheetVersion());
    }

    @Override
    public AreaReference createAreaReference(CellReference topLeft, CellReference bottomRight) {
        return new AreaReference(topLeft, bottomRight, this.workbook.getSpreadsheetVersion());
    }
}

