/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.datacollections.AbstractDataCollectionItem;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.datacollections.UIDataCollection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.DataCollectionPermissionsService;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/data-collections"})
public class PublicAPIDataCollectionsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService projectPermissionsService;
    @Autowired
    private DataCollectionsService dataCollectionsService;
    @Autowired
    private DataCollectionPermissionsService dataCollectionPermissionsService;
    @Autowired
    private AuditTrailService auditTrailService;

    @AuditedCall(value={"msgType", "data-collections-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIDataCollection.ListItemWithDetails> listDataCollections(HttpServletRequest req) throws IOException, DKUSecurityException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            List<UIDataCollection.ListItemWithDetails> list = this.dataCollectionsService.listReadableUnsafe(authCtx).stream().map(UIDataCollection.ListItemWithDetails::new).collect(Collectors.toList());
            return list;
        }
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    @ResponseBody
    public void createDataCollection(HttpServletRequest req, HttpServletResponse resp, @RequestBody DataCollection.DataCollectionSettings settings) throws IOException, DKUSecurityException {
        String createdId;
        this.require(StringUtils.isNotBlank((String)settings.displayName), "Required field 'displayName' is missing");
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            if (authCtx.getAuthSource() == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_PROJECT || !authCtx.getPermissions().mayCreateDataCollections()) {
                throw new SecurityException("You may not create new data collections");
            }
            if (StringUtils.isNotBlank((String)settings.id) && !DataCollectionsService.isValidDataCollectionId((String)settings.id)) {
                throw new DKUControllerBase.MalformedRequestException("Field 'id' is invalid, expected 8 alphanumeric characters");
            }
            if (this.dataCollectionsService.getOrNullUnsafe(settings.id) != null) {
                throw new DKUControllerBase.MalformedRequestException(String.format("Data collection %s already exists", settings.id));
            }
            createdId = this.dataCollectionsService.createDataCollection((DSSAuthCtx)authCtx, (DataCollection)new DataCollection((DataCollection.DataCollectionSettings)settings)).id;
            resp.setStatus(201);
            t.commit("Created data collection " + createdId);
            this.auditTrailService.generic("data-collection-create").with("id", createdId).emit();
        }
        PublicAPIDataCollectionsController.writeJSON((HttpServletResponse)resp, (Object)new PublicAPIControllerBase.ResponseMessageWithId(createdId, String.format("Created data collection '%s'", createdId)));
    }

    @AuditedCall(value={"msgType", "data-collection-get-settings", "dataCollectionId", "${dataCollectionId}"})
    @RequestMapping(value={"/{dataCollectionId:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public DataCollection.DataCollectionSettings getDataCollectionSettings(HttpServletRequest req, @PathVariable String dataCollectionId) throws DKUSecurityException, IOException {
        boolean isCurrentUserAdmin;
        DataCollection dataCollection;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            dataCollection = this.dataCollectionsService.getMandatoryUnsafe(dataCollectionId);
            this.dataCollectionPermissionsService.checkDataCollectionPrivileges(authCtx, dataCollection, new Privileges.DataCollectionLevelPrivilegeType[]{Privileges.DataCollectionLevelPrivilegeType.READ});
            isCurrentUserAdmin = this.dataCollectionPermissionsService.hasDataCollectionPrivileges(authCtx, dataCollection, new Privileges.DataCollectionLevelPrivilegeType[]{Privileges.DataCollectionLevelPrivilegeType.ADMIN});
        }
        return new DataCollection.DataCollectionSettings(dataCollection, isCurrentUserAdmin);
    }

    @AuditedCall(value={"msgType", "data-collection-update", "dataCollectionId", "${dataCollectionId}"})
    @RequestMapping(value={"/{dataCollectionId:.+}"}, method={RequestMethod.PUT})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage updateDataCollectionSettings(HttpServletRequest req, @PathVariable String dataCollectionId, @RequestBody DataCollection.DataCollectionSettings settings) throws DKUSecurityException, IOException {
        settings.id = dataCollectionId;
        this.require(StringUtils.isNotBlank((String)settings.displayName), "Required field 'displayName' is missing");
        this.require(settings.description != null, "Required field 'description' is missing");
        this.require(StringUtils.isNotBlank((String)settings.color), "Required field 'color' is missing");
        this.require(settings.tags != null, "Required field 'tags' is missing");
        this.require(settings.permissions != null, "Required field 'permissions' is missing");
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(dataCollectionId);
            this.dataCollectionPermissionsService.checkDataCollectionPrivileges((AuthCtx)authCtx, dataCollection, new Privileges.DataCollectionLevelPrivilegeType[]{Privileges.DataCollectionLevelPrivilegeType.ADMIN});
            UIDataCollection.MetadataInfo metadataInfo = new UIDataCollection.MetadataInfo(settings.displayName, settings.description, settings.color, settings.tags);
            this.dataCollectionsService.updateMetadata(dataCollection, metadataInfo);
            this.dataCollectionsService.updatePermissions(dataCollection, settings.permissions);
            t.commit(String.format("Updated data collection '%s", dataCollectionId));
        }
        return new PublicAPIControllerBase.ResponseMessage(String.format("Updated data collection '%s", dataCollectionId));
    }

    @AuditedCall(value={"msgType", "data-collection-delete", "dataCollectionId", "${dataCollectionId}"})
    @RequestMapping(value={"/{dataCollectionId:.+}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage deleteDataCollection(HttpServletRequest req, @PathVariable String dataCollectionId) throws DKUSecurityException, IOException {
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(dataCollectionId);
            this.dataCollectionPermissionsService.checkDataCollectionPrivileges((AuthCtx)authCtx, dataCollection, new Privileges.DataCollectionLevelPrivilegeType[]{Privileges.DataCollectionLevelPrivilegeType.ADMIN});
            this.dataCollectionsService.delete(dataCollection);
            t.commit("Deleted data collection " + dataCollectionId);
        }
        return new PublicAPIControllerBase.ResponseMessage(String.format("Deleted data collection '%s'", dataCollectionId));
    }

    @AuditedCall(value={"msgType", "data-collection-get-items", "dataCollectionId", "${dataCollectionId}"})
    @RequestMapping(value={"/{dataCollectionId}/objects"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AbstractDataCollectionItemRef> getDataCollectionItems(HttpServletRequest req, @PathVariable String dataCollectionId) throws DKUSecurityException, IOException {
        List items;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            DataCollection dataCollection = this.dataCollectionsService.getMandatoryUnsafe(dataCollectionId);
            this.dataCollectionPermissionsService.checkDataCollectionPrivileges(authCtx, dataCollection, new Privileges.DataCollectionLevelPrivilegeType[]{Privileges.DataCollectionLevelPrivilegeType.READ});
            items = this.dataCollectionsService.getDataCollectionItemsFiltered(authCtx, dataCollection);
        }
        return items.stream().map(AbstractDataCollectionItem::getRef).collect(Collectors.toList());
    }

    @AuditedCall(value={"msgType", "data-collection-add-object", "dataCollectionId", "${dataCollectionId}", "itemRef", "{$itemRef}"})
    @RequestMapping(value={"/{dataCollectionId}/objects"}, method={RequestMethod.POST})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage addObjectToDataCollection(HttpServletRequest req, @PathVariable String dataCollectionId, @RequestBody AbstractDataCollectionItemRef itemRef) throws DKUSecurityException, IOException {
        String responseMessage;
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            if (!authCtx.getPermissions().mayPublishToDataCollections()) {
                throw new SecurityException("You may not publish objects to data collections");
            }
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(dataCollectionId);
            this.dataCollectionPermissionsService.checkDataCollectionPrivileges((AuthCtx)authCtx, dataCollection, new Privileges.DataCollectionLevelPrivilegeType[]{Privileges.DataCollectionLevelPrivilegeType.WRITE});
            if (!(itemRef instanceof AbstractDataCollectionItemRef.DatasetRef)) {
                throw new DKUControllerBase.MalformedRequestException(String.format("Unexpected type for item %s", itemRef));
            }
            AbstractDataCollectionItemRef.DatasetRef datasetRef = (AbstractDataCollectionItemRef.DatasetRef)itemRef;
            this.require(datasetRef.projectKey != null, "Required field 'projectKey' is missing from itemRef");
            this.require(datasetRef.id != null, "Required field 'id' is missing from itemRef");
            this.projectPermissionsService.checkProjectPrivileges((AuthCtx)authCtx, datasetRef.projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.PUBLISH_TO_DATA_COLLECTIONS});
            boolean modified = this.dataCollectionsService.addDatasets((String)dataCollectionId, Collections.singletonList(new TaggableObjectsService.TaggableObjectRef((String)datasetRef.projectKey, (ITaggingService.TaggableType)ITaggingService.TaggableType.DATASET, (String)datasetRef.id))).modified;
            responseMessage = String.format(modified ? "Added item %s to data collection '%s'" : "Item  %s is already in data collection '%s'", itemRef, dataCollectionId);
            if (modified) {
                t.commit(responseMessage);
            }
        }
        return new PublicAPIControllerBase.ResponseMessage(responseMessage);
    }

    @AuditedCall(value={"msgType", "data-collection-remove-dataset", "dataCollectionId", "${dataCollectionId}", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{dataCollectionId}/objects/dataset/{projectKey}/{datasetName}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage removeDatasetFromDataCollection(HttpServletRequest req, @PathVariable String dataCollectionId, @PathVariable String projectKey, @PathVariable String datasetName) throws DKUSecurityException, IOException {
        this.require(StringUtils.isNotBlank((String)dataCollectionId), "Required field 'dataCollectionId' is missing");
        this.require(StringUtils.isNotBlank((String)projectKey), "Required field 'projectKey' is missing");
        this.require(StringUtils.isNotBlank((String)datasetName), "Required field 'datasetName' is missing");
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            DataCollection dataCollection = this.dataCollectionsService.getMandatory(dataCollectionId);
            this.dataCollectionPermissionsService.checkDataCollectionPrivileges((AuthCtx)authCtx, dataCollection, new Privileges.DataCollectionLevelPrivilegeType[]{Privileges.DataCollectionLevelPrivilegeType.WRITE});
            AbstractDataCollectionItemRef.DatasetRef datasetRef = new AbstractDataCollectionItemRef.DatasetRef(projectKey, datasetName);
            this.dataCollectionPermissionsService.checkDataCollectionActuallyContainsItem(dataCollection, (AbstractDataCollectionItemRef)datasetRef);
            this.dataCollectionPermissionsService.checkItemVisibility((AbstractDataCollectionItemRef)datasetRef);
            this.dataCollectionsService.removeItem(dataCollection, (AbstractDataCollectionItemRef)datasetRef);
            t.commit(String.format("Removed dataset '%s.%s' from data collection '%s'", projectKey, datasetName, dataCollectionId));
        }
        return new PublicAPIControllerBase.ResponseMessage(String.format("Removed dataset %s.%s from data collection '%s'", projectKey, datasetName, dataCollectionId));
    }
}

