/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV11000AndV12199;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV11000
extends Migration {
    long migrationTS;

    @Override
    protected void preRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        this.migrationTS = Instant.now().toEpochMilli();
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        jdbcTemplate.update("CREATE TEMPORARY TABLE tmp_mig_time (mig_time BIGINT) ON COMMIT DROP;\nINSERT INTO tmp_mig_time(mig_time) VALUES (?::BIGINT);\n", new Object[]{this.migrationTS});
    }

    @Override
    public void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        if (providedObjectsFolder == null) {
            throw new ValidationException("Migration " + this.getClass().getSimpleName() + " is expecting a provided object folder");
        }
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        Long actionId = MigrationEntitiesUtilsBetweenV11000AndV12199.createMigrationAction(jdbcTemplate, this.migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_project", "blueprint_version_default.json"}), "bp.system.dataiku_project", "bv.system.default", actionId, this.migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_project", "blueprint_version_default.json"}), "bp.system.govern_project", "bv.system.default", actionId, this.migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersionSignoffConfigurations(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_bundle", "blueprint_version_default_signoff.json"}), "bp.system.govern_bundle", "bv.system.default", actionId, this.migrationTS);
    }

    @Override
    public boolean shouldPerformDbOptimizationAfterMigration() {
        return false;
    }
}

