/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV11000AndV12199;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV11200
extends Migration {
    long migrationTS;
    private static final String KEY_ARTIFACT_SEARCH_SETTINGS = "artifactSearchSettings";
    private static final String KEY_ARTIFACT_SEARCH_SOURCE = "artifactSearchSource";

    @Override
    protected void preRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        this.migrationTS = Instant.now().toEpochMilli();
    }

    @Override
    public void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        MigrationEntitiesUtilsBetweenV11000AndV12199.migrateObjects(dbMigrationDAO.getJdbcTemplate(), "custom_pages", "custom_page_id", "custom_page_json", MigrationV11200::migrateCustomPage, cp -> cp.get("id").getAsString());
        MigrationEntitiesUtilsBetweenV11000AndV12199.migrateObjects(dbMigrationDAO.getJdbcTemplate(), "custom_pages_history", "custom_page_id", "custom_page_json", MigrationV11200::migrateCustomPage, cp -> cp.get("id").getAsString());
    }

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        if (providedObjectsFolder == null) {
            throw new ValidationException("Migration " + this.getClass().getSimpleName() + " is expecting a provided object folder");
        }
        long migrationTS = Instant.now().toEpochMilli();
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        Long actionId = MigrationEntitiesUtilsBetweenV11000AndV12199.createMigrationAction(jdbcTemplate, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_bundle", "blueprint_version_default.json"}), "bp.system.dataiku_bundle", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_project", "blueprint_version_default.json"}), "bp.system.dataiku_project", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_dataset", "blueprint_version_default.json"}), "bp.system.dataiku_dataset", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_saved_model", "blueprint_version_default.json"}), "bp.system.dataiku_saved_model", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_saved_model_version", "blueprint_version_default.json"}), "bp.system.dataiku_saved_model_version", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_bundle", "blueprint_version_default.json"}), "bp.system.govern_bundle", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_dataset", "blueprint_version_default.json"}), "bp.system.govern_dataset", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_model", "blueprint_version_default.json"}), "bp.system.govern_model", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_model_version", "blueprint_version_default.json"}), "bp.system.govern_model_version", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_project", "blueprint_version_default.json"}), "bp.system.govern_project", "bv.system.default", actionId, migrationTS);
    }

    @VisibleForTesting
    protected static JsonObject migrateCustomPage(JsonObject customPage) {
        String type = MigrationJsonUtils.getStringSubpath((JsonElement)customPage, "type").orElse("");
        Optional<JsonObject> settings = Optional.empty();
        if ("artifact-table".equals(type)) {
            settings = MigrationJsonUtils.getObjectSubpath((JsonElement)customPage, KEY_ARTIFACT_SEARCH_SETTINGS);
        } else if ("artifact-matrix".equals(type)) {
            settings = MigrationJsonUtils.getObjectSubpath((JsonElement)customPage, "artifactMatrixSettings", KEY_ARTIFACT_SEARCH_SETTINGS);
        }
        settings.ifPresent(MigrationV11200::migrateArtifactSearchSettings);
        return customPage;
    }

    @VisibleForTesting
    protected static JsonObject migrateArtifactSearchSettings(JsonObject artifactSearchSettings) {
        Optional<JsonObject> artifactSearchSource = MigrationJsonUtils.getObjectSubpath((JsonElement)artifactSearchSettings, KEY_ARTIFACT_SEARCH_SOURCE);
        JsonArray filters = new JsonArray();
        if (artifactSearchSource.isPresent()) {
            String sourceType;
            switch (sourceType = MigrationJsonUtils.getStringSubpath((JsonElement)artifactSearchSource.get(), "type").orElse("")) {
                case "blueprints": 
                case "blueprintVersions": 
                case "artifacts": {
                    filters.add((JsonElement)artifactSearchSource.get());
                }
            }
        }
        artifactSearchSettings.add("artifactFilters", (JsonElement)filters);
        artifactSearchSettings.add(KEY_ARTIFACT_SEARCH_SOURCE, (JsonElement)MigrationV11200.buildSourceAll());
        return artifactSearchSettings;
    }

    private static JsonObject buildSourceAll() {
        return (JsonObject)JSON.parse((String)"{\"type\": \"all\"}", JsonObject.class);
    }

    @Override
    public boolean shouldPerformDbOptimizationAfterMigration() {
        return false;
    }
}

