/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.export.writers;

import be.quodlibet.boxable.BaseTable;
import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.VerticalAlignment;
import be.quodlibet.boxable.line.LineStyle;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.gh.core.services.export.ArtifactExportRow;
import com.dataiku.gh.core.services.export.writers.ArtifactExportWriterConfiguration;
import com.dataiku.gh.core.services.export.writers.IArtifactExportWriter;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class ArtifactExportPDFWriter
implements IArtifactExportWriter {
    private static final ArtifactExportWriterConfiguration ARTIFACT_PDF_CONFIG = new ArtifactExportWriterConfiguration(true, true, true, true, true);
    private static final PDType1Font FONT = PDType1Font.HELVETICA;
    private static final PDType1Font FONT_BOLD = PDType1Font.HELVETICA_BOLD;
    private static final LineStyle INVISIBLE_STYLE = new LineStyle(Color.WHITE, 0.0f);
    private static final float FONT_SIZE = 8.0f;
    private static final float[] COLUMN_WIDTH = new float[]{15.0f, 15.0f, 15.0f, 55.0f};
    private final PDDocument document = new PDDocument();
    private final BaseTable table;

    public ArtifactExportPDFWriter() throws IOException {
        PDPage page = new PDPage(PDRectangle.A4);
        this.document.addPage(page);
        float margin = 15.0f;
        float yStart = page.getMediaBox().getHeight() - margin;
        float tableWidth = page.getMediaBox().getWidth() - 2.0f * margin;
        float bottomMargin = 0.0f;
        this.table = new BaseTable(yStart, yStart, bottomMargin, tableWidth, margin, this.document, page, true, true);
    }

    @Override
    public ArtifactExportWriterConfiguration getConfig() {
        return ARTIFACT_PDF_CONFIG;
    }

    @Override
    public void writeSectionHeader(String title, String subtitle) {
        this.table.createRow(10.0f);
        List<String> headers = Arrays.asList("Type", "ID", "Label", "Value");
        try {
            float titleWidth = this.getStringWidthInPixels(title, FONT_BOLD);
            if (titleWidth > 100.0f || StringUtils.isEmpty((CharSequence)subtitle)) {
                titleWidth = 100.0f;
            }
            if (titleWidth > 50.0f && StringUtils.isNotEmpty((CharSequence)subtitle)) {
                titleWidth = 50.0f;
            }
            Row titleRow = this.table.createRow(15.0f);
            Cell titleCell = titleRow.createCell(titleWidth, title);
            Cell subtitleCell = titleRow.createCell(100.0f - titleWidth, subtitle);
            this.styleTitleRow((Cell<PDPage>)titleCell, (Cell<PDPage>)subtitleCell);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Row headerRow = this.table.createRow(15.0f);
        for (int i = 0; i < headers.size(); ++i) {
            headerRow.createCell(COLUMN_WIDTH[i], headers.get(i));
        }
        this.styleHeaderRow((Row<PDPage>)headerRow);
    }

    @Override
    public void writeAttachments(String attachmentType, List<String> attachmentValues) {
        Row pdRow = this.table.createRow(10.0f);
        String sanitizedValue = attachmentValues.stream().map(ArtifactExportPDFWriter::sanitize).collect(Collectors.joining("<br/>"));
        pdRow.createCell(COLUMN_WIDTH[0], ArtifactExportPDFWriter.sanitize(attachmentType));
        pdRow.createCell(COLUMN_WIDTH[1], "");
        pdRow.createCell(COLUMN_WIDTH[2], "");
        pdRow.createCell(COLUMN_WIDTH[3], sanitizedValue);
        this.styleRow((Row<PDPage>)pdRow);
    }

    @Override
    public void writeRow(ArtifactExportRow exportRow) {
        Row pdRow = this.table.createRow(10.0f);
        pdRow.createCell(COLUMN_WIDTH[0], ArtifactExportPDFWriter.sanitize(exportRow.type));
        pdRow.createCell(COLUMN_WIDTH[1], ArtifactExportPDFWriter.sanitize(exportRow.id));
        pdRow.createCell(COLUMN_WIDTH[2], ArtifactExportPDFWriter.sanitize(exportRow.label));
        String sanitizeValue = exportRow.values.stream().map(val -> {
            String prefix = exportRow.values.size() > 1 ? "\u2022 " : "";
            String value = ArtifactExportPDFWriter.sanitize(val);
            return prefix + value;
        }).collect(Collectors.joining("<br/>"));
        pdRow.createCell(COLUMN_WIDTH[3], sanitizeValue);
        this.styleRow((Row<PDPage>)pdRow);
    }

    @Override
    public InputStream getStream() {
        try {
            this.table.draw();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.document.save((OutputStream)outputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.document.close();
    }

    private static String sanitize(String value) {
        String defaultValue = (String)StringUtils.defaultIfEmpty((CharSequence)value, (CharSequence)"");
        return defaultValue.replaceAll("(\r\n|\n)", "<br />");
    }

    private void styleTitleRow(Cell<PDPage> titleCell, Cell<PDPage> subtitleCell) {
        titleCell.setAlign(HorizontalAlignment.LEFT);
        titleCell.setValign(VerticalAlignment.MIDDLE);
        titleCell.setFontSize(12.0f);
        titleCell.setFont((PDFont)FONT_BOLD);
        titleCell.setTextColor(Color.BLACK);
        titleCell.setFillColor(Color.WHITE);
        titleCell.setBorderStyle(INVISIBLE_STYLE);
        titleCell.setBottomBorderStyle(new LineStyle(Color.BLACK, 1.0f));
        titleCell.setLineSpacing(2.1f);
        subtitleCell.copyCellStyle(titleCell);
        subtitleCell.setBottomBorderStyle(new LineStyle(Color.BLACK, 1.0f));
        subtitleCell.setFont((PDFont)FONT);
    }

    private void styleHeaderRow(Row<PDPage> headerRow) {
        for (Cell cell : headerRow.getCells()) {
            cell.setAlign(HorizontalAlignment.LEFT);
            cell.setValign(VerticalAlignment.MIDDLE);
            cell.setBorderStyle(INVISIBLE_STYLE);
            cell.setFont((PDFont)FONT);
            cell.setFontSize(8.0f);
            cell.setTextColor(Color.BLACK);
            cell.setFillColor(new Color(0xF6F6F6));
        }
    }

    private void styleRow(Row<PDPage> row) {
        for (Cell cell : row.getCells()) {
            cell.setAlign(HorizontalAlignment.LEFT);
            cell.setValign(VerticalAlignment.MIDDLE);
            cell.setFontSize(8.0f);
            cell.setFont((PDFont)FONT);
            cell.setFillColor(Color.WHITE);
            cell.setTextColor(Color.BLACK);
            cell.setLeftBorderStyle(INVISIBLE_STYLE);
            cell.setRightBorderStyle(INVISIBLE_STYLE);
            cell.setTopBorderStyle(new LineStyle(new Color(0xDFDFDF), 1.0f));
            cell.setBottomBorderStyle(new LineStyle(new Color(0xDFDFDF), 1.0f));
            cell.setLineSpacing(2.1f);
        }
    }

    private float getStringWidthInPixels(String text, PDType1Font font) throws IOException {
        float stringWidthInPoints = font.getStringWidth(text);
        return stringWidthInPoints / 1000.0f * 2.0f + 3.0f;
    }
}

