/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.common;

import com.databricks.client.jdbc.common.DSTrustManager;
import com.databricks.client.jdbc.common.ProxySettings;
import com.databricks.client.jdbc.common.SSLSettings;
import com.databricks.client.jdbc.common.SSLTransportParameters;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpUriRequest;
import com.databricks.client.jdbc42.internal.apache.http.conn.ssl.NoopHostnameVerifier;
import com.databricks.client.jdbc42.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.databricks.client.jdbc42.internal.apache.http.conn.ssl.SSLSocketFactory;
import com.databricks.client.jdbc42.internal.apache.http.ssl.SSLContexts;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;

public class CommonUtils {
    private static final String PROTOCOL_SSL = "SSL";

    public static SSLSocketFactory getSocketFactory(String string, SSLSettings sSLSettings) throws ErrorException {
        SSLTransportParameters sSLTransportParameters = CommonUtils.createSSLTransportParams(sSLSettings);
        if (null == sSLTransportParameters) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_SSL_PARAMS_NOT_SET.name());
            throw errorException;
        }
        SSLContext sSLContext = CommonUtils.createSSLContext(sSLTransportParameters, string);
        SSLSocketFactory sSLSocketFactory = sSLSettings.m_certNamesMismatch || sSLSettings.m_allowSelfSigned ? new SSLSocketFactory(sSLContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER) : new SSLSocketFactory(sSLContext);
        return sSLSocketFactory;
    }

    public static SSLConnectionSocketFactory getSSLConnectionSocketFactory(String string, SSLSettings sSLSettings) throws ErrorException {
        SSLContext sSLContext;
        Object object;
        if (sSLSettings.m_enableSSL) {
            object = CommonUtils.createSSLTransportParams(sSLSettings);
            sSLContext = CommonUtils.createSSLContext((SSLTransportParameters)object, string);
        } else {
            sSLContext = SSLContexts.createSystemDefault();
        }
        object = sSLSettings.m_certNamesMismatch || sSLSettings.m_allowSelfSigned ? new SSLConnectionSocketFactory(sSLContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE) : new SSLConnectionSocketFactory(sSLContext);
        return object;
    }

    private static SSLTransportParameters createSSLTransportParams(SSLSettings sSLSettings) {
        SSLTransportParameters sSLTransportParameters = new SSLTransportParameters();
        if (null != sSLSettings.m_sslKeyStore) {
            sSLTransportParameters.setTrustStore(sSLSettings.m_sslKeyStore, sSLSettings.m_sslKeyStorePwd);
        }
        if (null != sSLSettings.m_sslTrustStore) {
            sSLTransportParameters.setTrustStore(sSLSettings.m_sslTrustStore, sSLSettings.m_sslTrustStorePwd);
        }
        sSLTransportParameters.requireClientAuth(false);
        sSLTransportParameters.allowSelfSigned(sSLSettings.m_allowSelfSigned);
        sSLTransportParameters.certNamesMismatch(sSLSettings.m_certNamesMismatch);
        sSLTransportParameters.hostNameInSAN(sSLSettings.m_hostNameInSAN);
        return sSLTransportParameters;
    }

    private static SSLContext createSSLContext(SSLTransportParameters sSLTransportParameters, String string) throws ErrorException {
        SSLContext sSLContext;
        try {
            Object object;
            TrustManager[] trustManagerArray;
            sSLContext = SSLContext.getInstance(sSLTransportParameters.getProtocol());
            KeyManager[] keyManagerArray = null;
            if (sSLTransportParameters.isKeyStoreSet) {
                trustManagerArray = KeyManagerFactory.getInstance(sSLTransportParameters.getKeyManagerType());
                object = KeyStore.getInstance(sSLTransportParameters.getKeyStoreType());
                char[] cArray = null;
                if (null != sSLTransportParameters.getKeyPass()) {
                    cArray = sSLTransportParameters.getKeyPass().toCharArray();
                }
                ((KeyStore)object).load(new FileInputStream(sSLTransportParameters.getKeyStore()), cArray);
                trustManagerArray.init((KeyStore)object, cArray);
                keyManagerArray = trustManagerArray.getKeyManagers();
            }
            trustManagerArray = new TrustManager[]{new DSTrustManager(sSLTransportParameters, string)};
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            object = sSLContext.createSSLEngine();
            ((SSLEngine)object).setEnabledProtocols(CommonUtils.removeSSLProtocols(((SSLEngine)object).getEnabledProtocols()));
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        return sSLContext;
    }

    private static String[] removeSSLProtocols(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Input protocols = '");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            stringBuffer.append(string);
            stringBuffer.append(",");
            if (null == string || string.toUpperCase().contains(PROTOCOL_SSL)) continue;
            arrayList.add(string);
        }
        stringBuffer.append("', enabled protocols = '");
        for (String string : arrayList) {
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        stringBuffer.append("'");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isHostInProxyBypassList(ProxySettings proxySettings, HttpUriRequest httpUriRequest) {
        String string = httpUriRequest.getURI().getHost();
        if (proxySettings.m_proxyIgnoreList != null && proxySettings.m_proxyIgnoreList.size() > 0) {
            for (String string2 : proxySettings.m_proxyIgnoreList) {
                if (!string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

