/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeIpamsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Filter;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DescribeIpamsRequestMarshaller
implements Marshaller<Request<DescribeIpamsRequest>, DescribeIpamsRequest> {
    @Override
    public Request<DescribeIpamsRequest> marshall(DescribeIpamsRequest describeIpamsRequest) {
        SdkInternalList describeIpamsRequestIpamIdsList;
        if (describeIpamsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeIpamsRequest> request = new DefaultRequest<DescribeIpamsRequest>(describeIpamsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeIpams");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeIpamsRequestFiltersList = (SdkInternalList)describeIpamsRequest.getFilters();
        if (!describeIpamsRequestFiltersList.isEmpty() || !describeIpamsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeIpamsRequestFiltersListValue : describeIpamsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeIpamsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeIpamsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeIpamsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeIpamsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeIpamsRequest.getMaxResults()));
        }
        if (describeIpamsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeIpamsRequest.getNextToken()));
        }
        if (!(describeIpamsRequestIpamIdsList = (SdkInternalList)describeIpamsRequest.getIpamIds()).isEmpty() || !describeIpamsRequestIpamIdsList.isAutoConstruct()) {
            int ipamIdsListIndex = 1;
            for (String describeIpamsRequestIpamIdsListValue : describeIpamsRequestIpamIdsList) {
                if (describeIpamsRequestIpamIdsListValue != null) {
                    request.addParameter("IpamId." + ipamIdsListIndex, StringUtils.fromString(describeIpamsRequestIpamIdsListValue));
                }
                ++ipamIdsListIndex;
            }
        }
        return request;
    }
}

