/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.zeromq.ZActor;
import org.zeromq.ZAgent;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import org.zeromq.ZMsg;
import org.zeromq.ZPoller;
import org.zeromq.ZStar;
import zmq.Msg;
import zmq.SocketBase;

public class ZProxy {
    private static final String START = Command.START.name();
    private static final String PAUSE = Command.PAUSE.name();
    private static final String STOP = Command.STOP.name();
    private static final String RESTART = Command.RESTART.name();
    private static final String EXIT = Command.EXIT.name();
    private static final String STATUS = Command.STATUS.name();
    private static final String CONFIG = Command.CONFIG.name();
    public static final String STARTED = State.STARTED.name();
    public static final String PAUSED = State.PAUSED.name();
    public static final String STOPPED = State.STOPPED.name();
    public static final String EXITED = State.EXITED.name();
    public static final String ALIVE = State.ALIVE.name();
    private static final AtomicInteger counter = new AtomicInteger();
    private final ZAgent agent;
    private final ZStar.Exit exit;

    public static ZProxy newZProxy(ZContext ctx, String name, ZAgent.SelectorCreator selector, Proxy sockets, String motdelafin, Object ... args) {
        return new ZProxy(ctx, name, selector, sockets, new ZPump(), motdelafin, args);
    }

    public static ZProxy newZProxy(ZContext ctx, String name, Proxy sockets, String motdelafin, Object ... args) {
        return new ZProxy(ctx, name, null, sockets, new ZPump(), motdelafin, args);
    }

    public static ZProxy newProxy(ZContext ctx, String name, ZAgent.SelectorCreator selector, Proxy sockets, String motdelafin, Object ... args) {
        return new ZProxy(ctx, name, selector, sockets, new ZmqPump(), motdelafin, args);
    }

    public static ZProxy newProxy(ZContext ctx, String name, Proxy sockets, String motdelafin, Object ... args) {
        return new ZProxy(ctx, name, null, sockets, new ZmqPump(), motdelafin, args);
    }

    public String start(boolean sync) {
        return this.command(START, sync);
    }

    public String pause(boolean sync) {
        return this.command(PAUSE, sync);
    }

    public String stop(boolean sync) {
        return this.command(STOP, sync);
    }

    public String command(String command, boolean sync) {
        assert (!CONFIG.equals(command));
        assert (!RESTART.equals(command));
        if (STATUS.equals(command)) {
            return this.status(sync);
        }
        if (EXIT.equals(command)) {
            return this.exit();
        }
        String status = this.recvStatus();
        if (this.agent.send(command) && sync) {
            status = this.status(true);
        }
        return status;
    }

    public State command(Command command, boolean sync) {
        return State.valueOf(this.command(command.name(), sync));
    }

    public ZMsg command(Command command, ZMsg msg, boolean sync) {
        if (command == Command.CONFIG) {
            return this.configure(msg);
        }
        if (command == Command.RESTART) {
            String status = this.restart(msg);
            msg = new ZMsg();
            msg.add(status);
            return msg;
        }
        return null;
    }

    public ZMsg configure(ZMsg msg) {
        msg.addFirst(CONFIG);
        if (this.agent.send(msg)) {
            this.recvStatus();
            ZMsg reply = this.agent.recv();
            assert (reply != null);
            this.agent.send(STATUS);
            return reply;
        }
        return null;
    }

    public String restart(ZMsg hot) {
        boolean cold;
        ZMsg msg = new ZMsg();
        msg.add(RESTART);
        boolean bl = cold = hot == null;
        if (cold) {
            msg.add(Boolean.toString(false));
        } else {
            msg.add(Boolean.toString(true));
            msg.append(hot);
        }
        String status = EXITED;
        if (this.agent.send(msg)) {
            status = this.status(false);
        }
        return status;
    }

    @Deprecated
    public String exit(boolean sync) {
        return this.exit();
    }

    public String exit() {
        this.agent.send(EXIT);
        this.exit.awaitSilent();
        this.agent.close();
        return EXITED;
    }

    public String status() {
        return this.status(true);
    }

    public String status(boolean sync) {
        if (this.exit.isExited()) {
            return EXITED;
        }
        try {
            String status = this.recvStatus();
            if (this.agent.send(STATUS) && sync && (EXITED.equals(status = this.recvStatus()) || !this.agent.send(STATUS))) {
                return EXITED;
            }
            return status;
        }
        catch (ZMQException e) {
            return EXITED;
        }
    }

    private String recvStatus() {
        if (!this.agent.sign()) {
            return EXITED;
        }
        ZMsg msg = this.agent.recv();
        if (msg == null) {
            return EXITED;
        }
        String status = msg.popString();
        msg.destroy();
        return status;
    }

    public boolean isStarted() {
        return this.started();
    }

    public boolean started() {
        String status = this.status(true);
        return STARTED.equals(status);
    }

    public ZProxy(ZAgent.SelectorCreator selector, Proxy creator, String motdelafin, Object ... args) {
        this(null, null, selector, creator, null, motdelafin, args);
    }

    public ZProxy(String name, ZAgent.SelectorCreator selector, Proxy creator, String motdelafin, Object ... args) {
        this(null, name, selector, creator, null, motdelafin, args);
    }

    public ZProxy(ZContext ctx, String name, ZAgent.SelectorCreator selector, Proxy sockets, Pump pump, String motdelafin, Object ... args) {
        if (pump == null) {
            pump = new ZmqPump();
        }
        int count = 1;
        Object[] vars = new Object[count += args.length];
        vars[0] = sockets;
        ZActor.Actor shadow = null;
        for (int index = 0; index < args.length; ++index) {
            Object arg = args[index];
            if (arg instanceof ZActor.Actor) {
                shadow = (ZActor.Actor)arg;
            }
            vars[index + 1] = arg;
        }
        int id2 = counter.incrementAndGet();
        ZActor.Actor actor = new ProxyActor(name, pump, id2);
        if (shadow != null) {
            actor = new ZActor.Duo(actor, shadow);
        }
        ZActor zactor = new ZActor(ctx, selector, actor, motdelafin, vars);
        this.agent = zactor.agent();
        this.exit = zactor.exit();
    }

    private static final class ZmqPump
    implements Pump {
        private ZmqPump() {
        }

        @Override
        public boolean flow(Plug splug, ZMQ.Socket source, ZMQ.Socket capture, Plug dplug, ZMQ.Socket destination) {
            long more;
            SocketBase cpt;
            SocketBase src = source.base();
            SocketBase dst = destination.base();
            SocketBase socketBase = cpt = capture == null ? null : capture.base();
            do {
                Msg ctrl;
                boolean rc;
                Msg msg;
                if ((msg = src.recv(0)) == null) {
                    return false;
                }
                more = src.getSocketOpt(13);
                if (more < 0L) {
                    return false;
                }
                if (cpt == null || !(rc = cpt.send(ctrl = new Msg(msg), more > 0L ? 2 : 0))) {
                    // empty if block
                }
                if (rc = dst.send(msg, more > 0L ? 2 : 0)) continue;
                return false;
            } while (more != 0L);
            return true;
        }
    }

    public static class ZPump
    implements Pump {
        private static final Identity IDENTITY = new Identity();
        private final Transformer transformer;

        public ZPump() {
            this(null);
        }

        public ZPump(Transformer transformer) {
            this.transformer = transformer == null ? IDENTITY : transformer;
        }

        @Override
        public boolean flow(Plug splug, ZMQ.Socket source, ZMQ.Socket capture, Plug dplug, ZMQ.Socket destination) {
            boolean destroy;
            ZMsg cpt;
            boolean success;
            ZMsg msg = ZMsg.recvMsg(source);
            if (msg == null) {
                return false;
            }
            if (capture == null || !(success = cpt.send(capture, destroy = msg != (cpt = this.transformer.transform(msg, splug, Plug.CAPTURE))))) {
                // empty if block
            }
            ZMsg dst = this.transformer.transform(msg, splug, dplug);
            success = dst.send(destination);
            msg.destroy();
            return success;
        }

        private static class Identity
        implements Transformer {
            private Identity() {
            }

            @Override
            public ZMsg transform(ZMsg msg, Plug src, Plug dst) {
                return msg;
            }
        }

        public static interface Transformer {
            public ZMsg transform(ZMsg var1, Plug var2, Plug var3);
        }
    }

    private static final class ProxyActor
    extends ZActor.SimpleActor {
        private final State state = new State();
        private final Pump transport;
        private final String name;
        private Proxy provider;
        private Object[] args;
        private ZMQ.Socket frontend;
        private ZMQ.Socket backend;
        private ZMQ.Socket capture;

        public ProxyActor(String name, Pump transport, int id2) {
            this.name = name == null ? String.format("ZProxy-%sd", id2) : name;
            this.transport = transport;
        }

        @Override
        public String premiere(ZMQ.Socket pipe) {
            ZMsg reply = new ZMsg();
            reply.add(ALIVE);
            reply.send(pipe);
            return this.name;
        }

        @Override
        public List<ZMQ.Socket> createSockets(ZContext ctx, Object ... args) {
            this.provider = (Proxy)args[0];
            this.args = new Object[args.length - 1];
            System.arraycopy(args, 1, this.args, 0, this.args.length);
            this.frontend = this.provider.create(ctx, Plug.FRONT, this.args);
            this.capture = this.provider.create(ctx, Plug.CAPTURE, this.args);
            this.backend = this.provider.create(ctx, Plug.BACK, this.args);
            assert (this.frontend != null);
            assert (this.backend != null);
            return Arrays.asList(this.frontend, this.backend);
        }

        @Override
        public void start(ZMQ.Socket pipe, List<ZMQ.Socket> sockets, ZPoller poller) {
            this.state.alive = true;
            this.state.restart = false;
        }

        @Override
        public boolean backstage(ZMQ.Socket pipe, ZPoller poller, int events) {
            assert (this.state.hot == null);
            String cmd = pipe.recvStr();
            if (START.equals(cmd)) {
                if (this.start(poller)) {
                    return this.status().send(pipe);
                }
                this.state.restart = false;
                return false;
            }
            if (STOP.equals(cmd)) {
                this.stop();
                return this.status().send(pipe);
            }
            if (PAUSE.equals(cmd)) {
                this.pause(poller, true);
                return this.status().send(pipe);
            }
            if (RESTART.equals(cmd)) {
                String val = pipe.recvStr();
                boolean hot = Boolean.parseBoolean(val);
                return this.restart(pipe, hot);
            }
            if (STATUS.equals(cmd)) {
                return this.status().send(pipe);
            }
            if (CONFIG.equals(cmd)) {
                ZMsg cfg = ZMsg.recvMsg(pipe);
                boolean rc = this.provider.configure(pipe, cfg, this.frontend, this.backend, this.capture, this.args);
                cfg.destroy();
                return rc;
            }
            if (!EXIT.equals(cmd)) {
                return this.provider.custom(pipe, cmd, this.frontend, this.backend, this.capture, this.args);
            }
            this.state.restart = false;
            return false;
        }

        private ZMsg status() {
            ZMsg reply = new ZMsg();
            if (!this.state.alive) {
                reply.add(EXITED);
            } else if (this.state.paused) {
                reply.add(PAUSED);
            } else if (this.state.started) {
                reply.add(STARTED);
            } else {
                reply.add(STOPPED);
            }
            return reply;
        }

        private boolean start(ZPoller poller) {
            boolean success = true;
            if (!this.state.started) {
                try {
                    success = false;
                    success |= this.provider.configure(this.frontend, Plug.FRONT, this.args);
                    success |= this.provider.configure(this.backend, Plug.BACK, this.args);
                    success |= this.provider.configure(this.capture, Plug.CAPTURE, this.args);
                    this.state.started = true;
                }
                catch (IOException | RuntimeException e) {
                    e.printStackTrace();
                    this.state.restart = false;
                    this.state.started = false;
                    return false;
                }
            }
            this.pause(poller, false);
            return success;
        }

        private boolean pause(ZPoller poller, boolean pause) {
            this.state.paused = pause;
            if (pause) {
                poller.unregister(this.frontend);
                poller.unregister(this.backend);
            } else {
                poller.register(this.frontend, 1);
                poller.register(this.backend, 1);
            }
            return true;
        }

        private boolean stop() {
            this.state.started = false;
            this.state.paused = false;
            this.state.restart = true;
            return true;
        }

        private boolean restart(ZMQ.Socket pipe, boolean hot) {
            this.state.restart = true;
            if (hot) {
                assert (this.provider != null);
                this.state.hot = ZMsg.recvMsg(pipe);
                return true;
            }
            return false;
        }

        @Override
        public long looping(ZMQ.Socket pipe, ZPoller poller) {
            this.state.hot = null;
            return super.looping(pipe, poller);
        }

        @Override
        public boolean stage(ZMQ.Socket socket, ZMQ.Socket pipe, ZPoller poller, int events) {
            if (socket == this.frontend) {
                return this.transport.flow(Plug.FRONT, this.frontend, this.capture, Plug.BACK, this.backend);
            }
            if (socket == this.backend) {
                return this.transport.flow(Plug.BACK, this.backend, this.capture, Plug.FRONT, this.frontend);
            }
            return false;
        }

        @Override
        public boolean looped(ZMQ.Socket pipe, ZPoller poller) {
            if (this.state.restart) {
                if (this.state.hot == null) {
                    return false;
                }
                ZMsg cfg = this.state.hot;
                this.state.hot = null;
                ZMsg dup = cfg.duplicate();
                try {
                    boolean cold = this.provider.restart(dup, this.frontend, Plug.FRONT, this.args);
                    dup.destroy();
                    dup = cfg.duplicate();
                    cold |= this.provider.restart(dup, this.backend, Plug.BACK, this.args);
                    dup.destroy();
                    dup = cfg.duplicate();
                    dup.destroy();
                    cfg.destroy();
                }
                catch (IOException | RuntimeException e) {
                    e.printStackTrace();
                    this.state.restart = false;
                    return false;
                }
                return !(cold |= this.provider.restart(dup, this.capture, Plug.CAPTURE, this.args));
            }
            return true;
        }

        @Override
        public boolean destroyed(ZContext ctx, ZMQ.Socket pipe, ZPoller poller) {
            if (this.capture != null) {
                ctx.destroySocket(this.capture);
            }
            this.state.alive = false;
            if (!this.state.restart) {
                this.status().send(pipe);
            }
            return this.state.restart;
        }

        private static final class State {
            private boolean alive = false;
            private boolean started = false;
            private boolean paused = false;
            private boolean restart = false;
            private ZMsg hot;

            private State() {
            }

            public String toString() {
                return "State [alive=" + this.alive + ", started=" + this.started + ", paused=" + this.paused + ", restart=" + this.restart + ", hot=" + this.hot + "]";
            }
        }
    }

    public static interface Pump {
        public boolean flow(Plug var1, ZMQ.Socket var2, ZMQ.Socket var3, Plug var4, ZMQ.Socket var5);
    }

    public static enum State {
        ALIVE,
        STARTED,
        PAUSED,
        STOPPED,
        EXITED;

    }

    public static enum Command {
        START,
        PAUSE,
        STOP,
        RESTART,
        EXIT,
        STATUS,
        CONFIG;

    }

    public static interface Proxy {
        public ZMQ.Socket create(ZContext var1, Plug var2, Object ... var3);

        public boolean configure(ZMQ.Socket var1, Plug var2, Object ... var3) throws IOException;

        public boolean restart(ZMsg var1, ZMQ.Socket var2, Plug var3, Object ... var4) throws IOException;

        public boolean configure(ZMQ.Socket var1, ZMsg var2, ZMQ.Socket var3, ZMQ.Socket var4, ZMQ.Socket var5, Object ... var6);

        public boolean custom(ZMQ.Socket var1, String var2, ZMQ.Socket var3, ZMQ.Socket var4, ZMQ.Socket var5, Object ... var6);

        public static abstract class SimpleProxy
        implements Proxy {
            @Override
            public boolean restart(ZMsg cfg, ZMQ.Socket socket, Plug place, Object ... args) throws IOException {
                return true;
            }

            @Override
            public boolean configure(ZMQ.Socket pipe, ZMsg cfg, ZMQ.Socket frontend, ZMQ.Socket backend, ZMQ.Socket capture, Object ... args) {
                return true;
            }

            @Override
            public boolean custom(ZMQ.Socket pipe, String cmd, ZMQ.Socket frontend, ZMQ.Socket backend, ZMQ.Socket capture, Object ... args) {
                return true;
            }
        }
    }

    public static enum Plug {
        FRONT,
        BACK,
        CAPTURE;

    }
}

