(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This controller previously was in static/dataiku/js/simple_report/config_ui.js
    app.controller('StdGroupedChartDefController', function($scope, ChartTypeChangeHandler, ChartColumnTypeUtils) {

        $scope.acceptMeasure = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data);
        };

        $scope.acceptDimensionOrHierarchy = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptDimensionOrHierarchy(data);
        };

        $scope.getGroupDimList = (data) => ChartColumnTypeUtils.isHierarchy(data) ? $scope.chart.def.groupHierarchyDimension : $scope.chart.def.groupDimension;
    });
})();
