(function () {
    "use strict";
    angular.module("dataiku.opals").factory("NotebookContextService", NotebookContextService);

    function NotebookContextService($rootScope, $timeout) {
        let currentNotebookData = null;

        function setCurrentNotebook(data) {
            currentNotebookData = data;
            $rootScope.$emit("dataiku.opals.NotebookContextService.setCurrentNotebook");
        }

        function context(stateInfo) {
            return new Promise((resolve, reject) => {
                if (stateInfo.toState.name === "projects.project.notebooks.jupyter_notebook") {
                    function callResolve() {
                        resolve({ ...stateInfo, ...{ context: [...stateInfo.context, currentNotebookData.content.metadata.kernelspec.language] } });
                    }

                    function currentNotebookDataMatchesStateInfo() {
                        return (
                            currentNotebookData.path === `${stateInfo.toParams.projectKey}/${stateInfo.toParams.notebookId}.ipynb` &&
                            (stateInfo.toParams.kernel_name === undefined ||
                                currentNotebookData.content.metadata.kernelspec.name === stateInfo.toParams.kernel_name)
                        );
                    }

                    if (currentNotebookData && currentNotebookDataMatchesStateInfo()) {
                        callResolve();
                        return;
                    }

                    const timeoutPromise = $timeout(() => {
                        reject("NotebookContextService: setCurrentNotebook() not called after 60 seconds");
                        deregister();
                    }, 60000);
                    const deregister = $rootScope.$on("dataiku.opals.NotebookContextService.setCurrentNotebook", () => {
                        if (currentNotebookDataMatchesStateInfo()) {
                            $timeout.cancel(timeoutPromise);
                            callResolve();
                        } else {
                            reject("NotebookContextService: Notebook path or kernel name not matching");
                        }
                        deregister();
                    });
                } else {
                    reject(`NotebookContextService: Nominal route (${stateInfo.toState.name}) not matched`);
                }
            });
        }

        return {
            setCurrentNotebook,
            context,
        };
    }
})();
