(function() {
    'use strict';

    angular.module('dataiku.shared').component('pivotFilterDateFacet', {
        bindings: {
            filterTmpData: '<', // FilterTmpData
            filterFacet: '<', // FilterFacet
            facetUiState: '<', // FacetUiState
            filters: '<', // FrontendChartFilter[]
            index: '<', // number
            getFiltersRequestOptions: '<', // () => FiltersRequestOptions
            dateFilterTypeChange: '&', // ({ $dateFilterType }) => void
            filterTmpDataChange: '&', // ({ $filterTmpData }) => void
        },
        templateUrl: '/static/dataiku/shared/components/pivot-filter-date-facet/pivot-filter-date-facet.component.html',
        controller: function(CHART_FILTERS, ChartFilterUtils, ChartFilters) {
            const ctrl = this;

            ctrl.DATE_FILTER_PARTS = ChartFilterUtils.getDateChartFilterParts();
            ctrl.DATE_TYPES = CHART_FILTERS.DATE_TYPES;

            ctrl.isDateRangeFilter = ChartFilterUtils.isDateRangeFilter.bind(ChartFilterUtils);
            ctrl.isRelativeDateFilter = ChartFilterUtils.isRelativeDateFilter.bind(ChartFilterUtils);
            ctrl.isDatePartFilter = ChartFilterUtils.isDatePartFilter.bind(ChartFilterUtils);
            // Flag used to hide or not the from/to in the UX to avoid flickering
            // And still display them even if user has entered an erroneous date
            ctrl.switchedType= true;

            ctrl.$onChanges = (changesObj) => {
                if (changesObj.facetUiState != null && changesObj.facetUiState.isFirstChange()) {
                    ctrl.switchedType = changesObj.facetUiState.fromDateRangeModel && changesObj.facetUiState.toDateRangeModel;
                }
            };

            ctrl.switchDateFilterType = function(dateFilterType) {
                ctrl.switchedType = true;
                ctrl.dateFilterTypeChange({ $dateFilterType: dateFilterType });
            };

            // TODO move the pivot filter component, the facet should not be responsible for filter transformations
            ctrl.switchDateFilterPart = function(dateFilterPart) {
                ctrl.switchedType = false;
                const newFilterTmpData = _.cloneDeep(ctrl.filterTmpData);
                ChartFilters.switchDateFilterPart(dateFilterPart, newFilterTmpData);
                ChartFilters.switchFilterSelectionType(CHART_FILTERS.FILTER_SELECTION_TYPES.MULTI_SELECT, newFilterTmpData, ctrl.filters, ctrl.index, ctrl.getFiltersRequestOptions())
                    .then(() => ctrl.filterTmpDataChange({ $filterTmpData: newFilterTmpData }));
            };

            ctrl.onDateRangeChange = function(event, facetUiState, filterTmpData) {
                ctrl.switchedType = false;
                facetUiState.fromDateRangeModel = event.from;
                facetUiState.toDateRangeModel = event.to;
                facetUiState.timezoneDateRangeModel = event.tz;
                if (!facetUiState.fromDateRangeModel || !facetUiState.toDateRangeModel || !ChartFilters.hasDateRangeChanged(facetUiState, filterTmpData)) {
                    return;
                }
                ChartFilters.updateDateRange(facetUiState, filterTmpData);
                ctrl.filterTmpDataChange({ $filterTmpData: ctrl.filterTmpData });
            };

            ctrl.onRelativeDateChange = function(facet) {
                ctrl.switchedType = false;
                const { datePart, relativeOption, relativePreset } = facet;
                const filterTmpData = { 
                    ...ctrl.filterTmpData, 
                    dateFilterPart: datePart, 
                    dateFilterOption: relativeOption, 
                    dateFilterRelativePreset: relativePreset
                };
                ctrl.filterTmpDataChange({ $filterTmpData: filterTmpData });

            };

            ctrl.onValuesSelectionChange = function(values) {
                ctrl.switchedType = false;
                ctrl.filterTmpDataChange({ $filterTmpData: { ...ctrl.filterTmpData, values } });
            };
        }
    });
})();
