from dataikuapi.dss.llm_tracing import SpanBuilder
from langchain_core.callbacks import BaseCallbackHandler
from langchain_core.outputs import LLMResult


class CompletionTraceHandler(BaseCallbackHandler):
    span: SpanBuilder

    def __init__(self, span: SpanBuilder):
        self.span = span

    def on_llm_end(self, response: LLMResult, **kwargs) -> None:
        if response.llm_output is not None and "lastTrace" in response.llm_output:
            self.span.append_trace(response.llm_output["lastTrace"])
