<!DOCTYPE html>
<html lang="en">
<head>
    <title>Test report</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
            vertical-align: text-top;
        }
        tr {
            border-bottom: 1px solid #ccc;
        }
        th {
            text-align: left;
            padding: 20px;
        }
        td {
            text-align: left;
            line-height: 0px;
            padding: 20px;
            vertical-align: text-top;
        }
        .step-row {
            background-color: #F6FBFF;
        }
        .status-bar {
            display: inline-block;
            height: 20px;
            margin-right: 5px;
        }
        .status-bar-label {
            display: inline-block;
            margin-right: 20px;
        }

        .icon {
            font-size: 20px;
        }
        .icon-ok {
            color: #4CAF50;
        }
        .icon-warning {
            color: #F28C37;
        }
        .icon-failed {
            color: #CE1228;
        }
        .icon-aborted {
            font-size: 26px;
            color: #BBBBBB;
        }
        .icon-not-computed {
            color: #666666;
        }

        .bar-color-ok {
            background-color: #4CAF50;
        }
        .bar-color-warning {
            background-color: #F28C37;
        }
        .bar-color-failed {
            background-color: #CE1228;
        }
        .bar-color-aborted {
            background-color: #BBBBBB;
        }
        .bar-color-not-computed {
            background-color: #666666;
        }
    </style>

    <#function getOutputIcon output>
        <#switch output>
            <#case "SUCCESS">
                <#return "<span class='icon icon-ok'>&#10004;</span>">
            <#case "WARNING">
                <#return "<span class='icon icon-warning'>&#9888;</span>">
            <#case "FAILED">
                <#return "<span class='icon icon-failed'>&#10005;</span>">
            <#case "ABORTED">
                <#return "<span class='icon icon-aborted'>&#8960;</span>">
            <#case "NOT_COMPUTED">
                <#return "<span class='icon icon-not-computed'>&#8212;</span>">
        </#switch>
    </#function>

    <#function getOutputValue output>
        <#switch output>
            <#case "SUCCESS">
                <#return "Ok">
            <#case "WARNING">
                <#return "Warning">
            <#case "FAILED">
                <#return "Failed">
            <#case "ABORTED">
                <#return "Aborted">
            <#case "NOT_COMPUTED">
                <#return "Not computed">
        </#switch>
    </#function>

    <#function getOutputBar key value max >
        <#local w = value/max*90>
        <#switch key>
            <#case "SUCCESS">
                <#return "<span class='status-bar bar-color-ok' style='width: ${w}%'></span>">
            <#case "WARNING">
                <#return "<span class='status-bar bar-color-warning' style='width: ${w}%'></span>">
            <#case "FAILED">
                <#return "<span class='status-bar bar-color-failed' style='width: ${w}%'></span>">
            <#case "ABORTED">
                <#return "<span class='status-bar bar-color-aborted' style='width: ${w}%'></span>">
            <#case "NOT_COMPUTED">
                <#return "<span class='status-bar bar-color-not-computed' style='width: ${w}%'></span>">
        </#switch>
    </#function>

    <#function getDuration start end>
        <#local t = end - start>
        <#local ms = (t%1000)?abs?string['000ms']>
        <#if (t > 3600000)>
            <#local h = (t/3600000)?floor?string['#0h ']>
            t = t%3600000
        </#if>
        <#if (t > 60000)>
            <#local m = (t/60000)?floor?string['#0m ']>
            t = t%60000
        </#if>
        <#if (t > 1000)>
            <#local s = (t/1000)?floor?string['#0s ']>
        </#if>
        <#return "${h!''}${m!''}${s!''}${ms}">
    </#function>

</head>
<body>
    <h1>Test report on project: ${projectId}</h1>
    <br/>
    <#if bundleId??>
        <p>Bundle: <b>${bundleId}</b>
            <#if activatedOn??> activated on ${activatedOn?datetime?string["MMM dd, yyyy"]} </#if>
            <#if activatedBy??> by ${activatedBy} </#if>
        </p>
    </#if>
    <#if instanceName??>
        <p>Dataiku instance: <b>${instanceName}</b></p>
    </#if>
    <br/><hr>
    <h1>Status test runs</h1>
    <#if (totalCount > 0)>
        <p>
            <#list counters as key, value>
                <span>
                    ${getOutputBar(key value totalCount)}
                </span>
            </#list>
        </p>
        <p>
            <#list counters as key, value>
                <span class="status-bar-label">${getOutputIcon(key)} ${value} ${getOutputValue(key)}</span>
            </#list>
        </p>
        <br/><hr>
        <h1>Status run details</h1>
        <table>
            <colgroup>
                <col style="width: 25%;">
                <col style="width: 25%;">
                <col style="width: 10%">
                <col style="width: 20%;">
                <col style="width: 20%">
            </colgroup>
            <thead>
                <tr>
                    <th>Scenario</th>
                    <th>Step</th>
                    <th>Last status</th>
                    <th>Execution date</th>
                    <th>Run duration</th>
                </tr>
            </thead>
            <tbody>
                <#list scenarioRuns as scenarioRun>
                <tr>
                    <td>${scenarioRun.name}</td>
                    <td></td>
                    <td>${getOutputIcon(scenarioRun.outcome!"NOT_COMPUTED")}</td>
                    <#if scenarioRun.outcome??>
                    <td>${scenarioRun.start?number_to_datetime?string["yyyy-MM-dd HH:mm"]}</td>
                    <td>${getDuration(scenarioRun.end scenarioRun.start)}</td>
                    <#else>
                    <td><i>No run available for this scenario</i></td>
                    </#if>
                </tr>
                <#list scenarioRun.stepRuns as stepRun>
                <tr class="step-row">
                    <td></td>
                    <td>${stepRun.stepName}</td>
                    <td>${getOutputIcon(stepRun.outcome!"NOT_COMPUTED")}</td>
                    <#if stepRun.outcome??>
                    <td>${stepRun.start?number_to_datetime?string["yyyy-MM-dd HH:mm"]}</td>
                    <td>${getDuration(stepRun.start stepRun.end)}</td>
                    <#else>
                    <td><i>No run available for this step</i></td>
                    </#if>
                </tr>

                </#list>
                </#list>
            </tbody>
        </table>
    <#else>
        <p>No scenario runs available</p>
    </#if>
    <br/>
    <br/>
    <i>Generated on ${currentTime?number_to_date?string["yyyy MMM dd"]} at ${currentTime?number_to_time?string["HH:mm '('zzz')'"]} <b>${generatorUserInfo}</b></i>
</body>
</html>
