/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.util.UnsafeUtil;
import com.esotericsoftware.kryo.util.Util;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.nio.ch.DirectBuffer;

public final class UnsafeMemoryOutput
extends ByteBufferOutput {
    private long bufaddress;
    private static final boolean isLittleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    public UnsafeMemoryOutput() {
        this.varIntsEnabled = false;
    }

    public UnsafeMemoryOutput(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public UnsafeMemoryOutput(int bufferSize, int maxBufferSize) {
        super(bufferSize, maxBufferSize);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(OutputStream outputStream) {
        super(outputStream);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(OutputStream outputStream, int bufferSize) {
        super(outputStream, bufferSize);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(long address, int maxBufferSize) {
        super(address, maxBufferSize);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    @Override
    public void setBuffer(ByteBuffer buffer, int maxBufferSize) {
        super.setBuffer(buffer, maxBufferSize);
        this.updateBufferAddress();
    }

    private void updateBufferAddress() {
        this.bufaddress = ((DirectBuffer)((Object)this.niobuffer)).address();
    }

    @Override
    public final void writeInt(int value) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putInt(this.bufaddress + (long)this.position, value);
        this.position += 4;
    }

    @Override
    public final void writeFloat(float value) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putFloat(this.bufaddress + (long)this.position, value);
        this.position += 4;
    }

    @Override
    public final void writeShort(int value) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe().putShort(this.bufaddress + (long)this.position, (short)value);
        this.position += 2;
    }

    @Override
    public final void writeLong(long value) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putLong(this.bufaddress + (long)this.position, value);
        this.position += 8;
    }

    @Override
    public final void writeByte(int value) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeByte(value);
    }

    @Override
    public void writeByte(byte value) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeByte(value);
    }

    @Override
    public final void writeBoolean(boolean value) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeBoolean(value);
    }

    @Override
    public final void writeChar(char value) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe().putChar(this.bufaddress + (long)this.position, value);
        this.position += 2;
    }

    @Override
    public final void writeDouble(double value) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putDouble(this.bufaddress + (long)this.position, value);
        this.position += 8;
    }

    @Override
    public final int writeInt(int value, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeInt(value);
            return 4;
        }
        return this.writeVarInt(value, optimizePositive);
    }

    @Override
    public final int writeLong(long value, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeLong(value);
            return 8;
        }
        return this.writeVarLong(value, optimizePositive);
    }

    @Override
    public final int writeVarInt(int val, boolean optimizePositive) throws KryoException {
        long value = val;
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        long varInt = 0L;
        varInt = value & 0x7FL;
        if ((value >>>= 7) == 0L) {
            this.writeByte((byte)varInt);
            return 1;
        }
        varInt |= 0x80L;
        varInt |= (value & 0x7FL) << 8;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianInt((int)varInt);
            this.position -= 2;
            return 2;
        }
        varInt |= 0x8000L;
        varInt |= (value & 0x7FL) << 16;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianInt((int)varInt);
            --this.position;
            return 3;
        }
        varInt |= 0x800000L;
        varInt |= (value & 0x7FL) << 24;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianInt((int)varInt);
            this.position -= 0;
            return 4;
        }
        varInt |= 0x80000000L;
        varInt |= (value & 0x7FL) << 32;
        this.writeLittleEndianLong(varInt &= 0xFFFFFFFFFL);
        this.position -= 3;
        return 5;
    }

    @Override
    public final int writeVarLong(long value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        int varInt = 0;
        varInt = (int)(value & 0x7FL);
        if ((value >>>= 7) == 0L) {
            this.writeByte(varInt);
            return 1;
        }
        varInt |= 0x80;
        varInt = (int)((long)varInt | (value & 0x7FL) << 8);
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianInt(varInt);
            this.position -= 2;
            return 2;
        }
        varInt |= 0x8000;
        varInt = (int)((long)varInt | (value & 0x7FL) << 16);
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianInt(varInt);
            --this.position;
            return 3;
        }
        varInt |= 0x800000;
        varInt = (int)((long)varInt | (value & 0x7FL) << 24);
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianInt(varInt);
            this.position -= 0;
            return 4;
        }
        varInt = (int)((long)varInt | 0x80000000L);
        long varLong = (long)varInt & 0xFFFFFFFFL;
        varLong |= (value & 0x7FL) << 32;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            this.position -= 3;
            return 5;
        }
        varLong |= 0x8000000000L;
        varLong |= (value & 0x7FL) << 40;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            this.position -= 2;
            return 6;
        }
        varLong |= 0x800000000000L;
        varLong |= (value & 0x7FL) << 48;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            --this.position;
            return 7;
        }
        varLong |= 0x80000000000000L;
        varLong |= (value & 0x7FL) << 56;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            return 8;
        }
        this.writeLittleEndianLong(varLong |= Long.MIN_VALUE);
        this.writeByte((int)(value & 0xFFL));
        return 9;
    }

    private final void writeLittleEndianInt(int val) {
        if (isLittleEndian) {
            this.writeInt(val);
        } else {
            this.writeInt(Util.swapInt(val));
        }
    }

    private final void writeLittleEndianLong(long val) {
        if (isLittleEndian) {
            this.writeLong(val);
        } else {
            this.writeLong(Util.swapLong(val));
        }
    }

    @Override
    public final void writeInts(int[] object, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            int bytesToCopy = object.length << 2;
            this.writeBytes(object, UnsafeUtil.intArrayBaseOffset, 0L, bytesToCopy);
        } else {
            super.writeInts(object, optimizePositive);
        }
    }

    @Override
    public final void writeLongs(long[] object, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            int bytesToCopy = object.length << 3;
            this.writeBytes(object, UnsafeUtil.longArrayBaseOffset, 0L, bytesToCopy);
        } else {
            super.writeLongs(object, optimizePositive);
        }
    }

    @Override
    public final void writeInts(int[] object) throws KryoException {
        int bytesToCopy = object.length << 2;
        this.writeBytes(object, UnsafeUtil.intArrayBaseOffset, 0L, bytesToCopy);
    }

    @Override
    public final void writeLongs(long[] object) throws KryoException {
        int bytesToCopy = object.length << 3;
        this.writeBytes(object, UnsafeUtil.longArrayBaseOffset, 0L, bytesToCopy);
    }

    @Override
    public final void writeFloats(float[] object) throws KryoException {
        int bytesToCopy = object.length << 2;
        this.writeBytes(object, UnsafeUtil.floatArrayBaseOffset, 0L, bytesToCopy);
    }

    @Override
    public final void writeShorts(short[] object) throws KryoException {
        int bytesToCopy = object.length << 1;
        this.writeBytes(object, UnsafeUtil.shortArrayBaseOffset, 0L, bytesToCopy);
    }

    @Override
    public final void writeChars(char[] object) throws KryoException {
        int bytesToCopy = object.length << 1;
        this.writeBytes(object, UnsafeUtil.charArrayBaseOffset, 0L, bytesToCopy);
    }

    @Override
    public final void writeDoubles(double[] object) throws KryoException {
        int bytesToCopy = object.length << 3;
        this.writeBytes(object, UnsafeUtil.doubleArrayBaseOffset, 0L, bytesToCopy);
    }

    @Override
    public void writeBytes(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes((Object)bytes, 0L, (long)bytes.length);
    }

    public final void writeBytes(Object obj, long offset, long count) throws KryoException {
        this.writeBytes(obj, UnsafeUtil.byteArrayBaseOffset, offset, count);
    }

    private final void writeBytes(Object srcArray, long srcArrayTypeOffset, long srcOffset, long count) throws KryoException {
        int copyCount = Math.min(this.capacity - this.position, (int)count);
        while (true) {
            UnsafeUtil.unsafe().copyMemory(srcArray, srcArrayTypeOffset + srcOffset, null, this.bufaddress + (long)this.position, copyCount);
            this.position += copyCount;
            if ((count -= (long)copyCount) == 0L) {
                return;
            }
            srcOffset += (long)copyCount;
            copyCount = Math.min(this.capacity, (int)count);
            this.require(copyCount);
        }
    }
}

