/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import spire.math.Algebraic;
import spire.math.Complex;
import spire.math.Natural$;
import spire.math.NaturalAlgebra;
import spire.math.Number;
import spire.math.Number$;
import spire.math.NumberTag;
import spire.math.Quaternion;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.UInt;
import spire.math.UInt$;
import spire.math.ULong$;

@ScalaSignature(bytes="\u0006\u0001\u0011ef\u0001CA\u0017\u0003_\t\t#!\u000f\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011q\f\u0001\u0007\u0002\u0005\u0005\u0004bBA5\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!a/\u0001\t\u0003\t\u0019\fC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\bbBAt\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0003S\u0004A\u0011AAv\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003kDqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\tU\u0001\u0001\"\u0001\u0003\u0018!9!q\u0004\u0001\u0005\u0002\t\u0005\u0002b\u0002B\u0015\u0001\u0011\u0005\u00131\u0017\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqA!\u000f\u0001\t\u0003\u0012Y\u0004C\u0004\u0003N\u0001!\tAa\u0014\t\u000f\tE\u0003\u0001\"\u0001\u0003T!9!Q\u000b\u0001\u0005\u0002\tM\u0003b\u0002B,\u0001\u0011\u0005!1\u000b\u0005\b\u00053\u0002A\u0011\u0001B*\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0003gCqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0004\u0003^\u0001!\tA!\u001a\t\u000f\t%\u0004\u0001\"\u0012\u0003l!9!q\u000e\u0001\u0005\u0002\tE\u0004b\u0002B;\u0001\u0011\u0005!q\u000f\u0005\b\u0005w\u0002A\u0011\u0001B?\u0011\u001d\u0011\t\t\u0001C\u0001\u0005\u0007CqAa\"\u0001\t\u0003\u0011I\tC\u0004\u0003\u000e\u0002!\tAa$\t\u000f\tm\u0004\u0001\"\u0001\u0003\u0014\"9!\u0011\u0011\u0001\u0005\u0002\te\u0005b\u0002BD\u0001\u0011\u0005!Q\u0014\u0005\b\u0005\u001b\u0003A\u0011\u0001BQ\u0011\u001d\u0011Y\b\u0001C\u0001\u0005KCqA!!\u0001\t\u0003\u0011I\u000bC\u0004\u0003\b\u0002!\tA!,\t\u000f\t5\u0005\u0001\"\u0001\u00032\"9!Q\u0017\u0001\u0007\u0002\t]\u0006b\u0002B_\u0001\u0019\u0005!q\u0018\u0005\b\u0005\u0007\u0004a\u0011\u0001Bc\u0011\u001d\u0011I\r\u0001C\u0001\u0005\u0017DqAa4\u0001\r\u0003\u0011\t\u000eC\u0004\u0003V\u00021\tAa6\t\u000f\tm\u0007A\"\u0001\u0003^\"9!Q\u0017\u0001\u0005\u0002\t\u001d\bb\u0002B_\u0001\u0011\u0005!1\u001e\u0005\b\u0005\u0007\u0004A\u0011\u0001Bx\u0011\u001d\u0011I\r\u0001C\u0001\u0005gDqAa4\u0001\t\u0003\u00119\u0010C\u0004\u0003V\u0002!\tAa?\t\u000f\tm\u0007\u0001\"\u0001\u0003\u0000\"9!Q\u0017\u0001\u0005\u0002\r\u0015\u0001b\u0002B_\u0001\u0011\u00051\u0011\u0002\u0005\b\u0005\u0007\u0004A\u0011AB\u0007\u0011\u001d\u0019\t\u0002\u0001C\u0001\u0007'Aqa!\u0005\u0001\t\u0003\u00199\u0002C\u0004\u0003J\u0002!\taa\u0007\t\u000f\t=\u0007\u0001\"\u0001\u0004 !9!Q\u001b\u0001\u0005\u0002\r\r\u0002b\u0002Bn\u0001\u0011\u00051q\u0005\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011\u001d\u00199\u0004\u0001C\u0001\u0007sAqaa\u0010\u0001\t\u0003\u0019\t\u0005C\u0004\u0004F\u0001!\taa\u0012\t\u000f\r-\u0003\u0001\"\u0001\u0004N!911\n\u0001\u0005\u0002\rE\u0003bBB+\u0001\u0011\u00051q\u000b\u0005\b\u0007+\u0002A\u0011AB.\u0011\u001d\u0019y\u0006\u0001C\u0001\u0007CBqaa\u0018\u0001\t\u0003\u0019)g\u0002\u0005\u00058\u0006=\u0002\u0012AB?\r!\ti#a\f\t\u0002\r5\u0004bBA,\u001d\u0012\u000511\u0010\u0005\f\u0007kq%\u0019!C\u0003\u0003_\t\t\u0007\u0003\u0005\u0004\u00009\u0003\u000bQBA2\u0011\u001d\u0019\tI\u0014C\u0002\u0007\u0007Cqaa\"O\t\u0003\u0019I\tC\u0004\u0004\b:#\ta!&\t\u000f\r\u001de\n\"\u0001\u0004\u001a\"I1Q\u0014(C\u0002\u0013%\u0011Q\u001d\u0005\t\u0007?s\u0005\u0015!\u0003\u0002\\!91q\u0011(\u0005\u0002\r\u0005\u0006\"CBT\u001d\n\u0007I\u0011AAs\u0011!\u0019IK\u0014Q\u0001\n\u0005m\u0003\"CBV\u001d\n\u0007I\u0011AAs\u0011!\u0019iK\u0014Q\u0001\n\u0005mcABB6\u001d\u0002#Y\b\u0003\u0006\u0004Rv\u0013)\u001a!C\u0001\u0003CB!ba=^\u0005#\u0005\u000b\u0011BA2\u0011)\u0019).\u0018BK\u0002\u0013\u0005\u0011Q\u001d\u0005\u000b\t{j&\u0011#Q\u0001\n\u0005m\u0003bBA,;\u0012\u0005Aq\u0010\u0005\b\u0003?jF\u0011AA1\u0011\u001d!))\u0018C\u0001\u0003KDqA!.^\t\u0003!9\tC\u0004\u0003>v#\t\u0001b#\t\u000f\t\rW\f\"\u0001\u0005\u0010\"9!qZ/\u0005\u0002\u0011M\u0005b\u0002Bk;\u0012\u0005Aq\u0013\u0005\b\u00057lF\u0011\u0001CN\u0011%!\u0019\"XA\u0001\n\u0003!y\nC\u0005\u0005\u001au\u000b\n\u0011\"\u0001\u0005\u001c!IAQU/\u0012\u0002\u0013\u0005Aq\u0015\u0005\n\tci\u0016\u0011!C!\tgA\u0011\u0002\"\u000e^\u0003\u0003%\t!a-\t\u0013\u0011]R,!A\u0005\u0002\u0011-\u0006\"\u0003C ;\u0006\u0005I\u0011\tC!\u0011%!y%XA\u0001\n\u0003!y\u000bC\u0005\u0005Vu\u000b\t\u0011\"\u0011\u0003\n\u001dI1q\u0016(\u0002\u0002#\u00051\u0011\u0017\u0004\n\u0007Wr\u0015\u0011!E\u0001\u0007kCq!a\u0016v\t\u0003\u0019)\rC\u0005\u0003:U\f\t\u0011\"\u0012\u0004H\"I1qQ;\u0002\u0002\u0013\u00055Q\u001a\u0005\n\u0007/,\u0018\u0011!CA\u00073D\u0011ba:v\u0003\u0003%I!!>\u0007\r\r%h\nQBv\u0011)\u0019\tn\u001fBK\u0002\u0013\u0005\u0011\u0011\r\u0005\u000b\u0007g\\(\u0011#Q\u0001\n\u0005\r\u0004bBA,w\u0012\u00051Q\u001f\u0005\b\u0003?ZH\u0011AA1\u0011\u001d\u0011)l\u001fC\u0001\u0007wDqA!0|\t\u0003\u0019y\u0010C\u0004\u0003Dn$\t\u0001b\u0001\t\u000f\t=7\u0010\"\u0001\u0005\b!9!Q[>\u0005\u0002\u0011-\u0001b\u0002Bnw\u0012\u0005Aq\u0002\u0005\n\t'Y\u0018\u0011!C\u0001\t+A\u0011\u0002\"\u0007|#\u0003%\t\u0001b\u0007\t\u0013\u0011E20!A\u0005B\u0011M\u0002\"\u0003C\u001bw\u0006\u0005I\u0011AAZ\u0011%!9d_A\u0001\n\u0003!I\u0004C\u0005\u0005@m\f\t\u0011\"\u0011\u0005B!IAqJ>\u0002\u0002\u0013\u0005A\u0011\u000b\u0005\n\t+Z\u0018\u0011!C!\u0005\u00139\u0011\u0002b\u0019O\u0003\u0003E\t\u0001\"\u001a\u0007\u0013\r%h*!A\t\u0002\u0011\u001d\u0004\u0002CA,\u0003?!\t\u0001b\u001c\t\u0015\te\u0012qDA\u0001\n\u000b\u001a9\r\u0003\u0006\u0004\b\u0006}\u0011\u0011!CA\tcB!ba6\u0002 \u0005\u0005I\u0011\u0011C;\u0011)\u00199/a\b\u0002\u0002\u0013%\u0011Q\u001f\u0005\n\u0007Ot\u0015\u0011!C\u0005\u0003k\u0014qAT1ukJ\fGN\u0003\u0003\u00022\u0005M\u0012\u0001B7bi\"T!!!\u000e\u0002\u000bM\u0004\u0018N]3\u0004\u0001M9\u0001!a\u000f\u0002J\u0005=\u0003\u0003BA\u001f\u0003\u000bj!!a\u0010\u000b\t\u0005E\u0012\u0011\t\u0006\u0003\u0003\u0007\nQa]2bY\u0006LA!a\u0012\u0002@\tY1kY1mC:+XNY3s!\u0011\ti$a\u0013\n\t\u00055\u0013q\b\u0002\u0018'\u000e\fG.\u0019(v[\u0016\u0014\u0018nY\"p]Z,'o]5p]N\u0004B!!\u0015\u0002T5\u0011\u0011\u0011I\u0005\u0005\u0003+\n\tE\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0003\u00037\u00022!!\u0018\u0001\u001b\t\ty#A\u0003eS\u001eLG/\u0006\u0002\u0002dA!\u0011QLA3\u0013\u0011\t9'a\f\u0003\tUKe\u000e^\u0001\u000fM>dG\rR5hSR\u001cH*\u001a4u+\u0011\ti'!\u001e\u0015\t\u0005=\u0014\u0011\u0014\u000b\u0005\u0003c\ny\t\u0005\u0003\u0002t\u0005UD\u0002\u0001\u0003\f\u0003o\u001a\u0001\u0015!A\u0001\u0006\u0004\tIHA\u0001B#\u0011\tY(!!\u0011\t\u0005E\u0013QP\u0005\u0005\u0003\u007f\n\tEA\u0004O_RD\u0017N\\4\u0011\t\u0005E\u00131Q\u0005\u0005\u0003\u000b\u000b\tEA\u0002B]fDC!!\u001e\u0002\nB!\u0011\u0011KAF\u0013\u0011\ti)!\u0011\u0003\u0017M\u0004XmY5bY&TX\r\u001a\u0005\b\u0003#\u001b\u0001\u0019AAJ\u0003\u00051\u0007CCA)\u0003+\u000b\t(a\u0019\u0002r%!\u0011qSA!\u0005%1UO\\2uS>t'\u0007C\u0004\u0002\u001c\u000e\u0001\r!!\u001d\u0002\u0003\u0005\fqBZ8mI\u0012Kw-\u001b;t%&<\u0007\u000e^\u000b\u0005\u0003C\u000b9\u000b\u0006\u0003\u0002$\u0006=F\u0003BAS\u0003W\u0003B!a\u001d\u0002(\u0012Y\u0011q\u000f\u0003!\u0002\u0003\u0005)\u0019AA=Q\u0011\t9+!#\t\u000f\u0005EE\u00011\u0001\u0002.BQ\u0011\u0011KAK\u0003K\u000b\u0019'!*\t\u000f\u0005mE\u00011\u0001\u0002&\u0006Qq-\u001a;Ok6\u0014\u0015\u000e^:\u0016\u0005\u0005U\u0006\u0003BA)\u0003oKA!!/\u0002B\t\u0019\u0011J\u001c;\u0002\u001d\u001d,G\u000fR5hSRdUM\\4uQ\u00061Ao\u001c'jgR,\"!!1\u0011\r\u0005\r\u00171[A2\u001d\u0011\t)-a4\u000f\t\u0005\u001d\u0017QZ\u0007\u0003\u0003\u0013TA!a3\u00028\u00051AH]8pizJ!!a\u0011\n\t\u0005E\u0017\u0011I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t).a6\u0003\t1K7\u000f\u001e\u0006\u0005\u0003#\f\t%A\u0004u_\u0006\u0013(/Y=\u0016\u0005\u0005u\u0007CBA)\u0003?\f),\u0003\u0003\u0002b\u0006\u0005#!B!se\u0006L\u0018\u0001\u0003:fm\u0016\u00148/\u001a3\u0016\u0005\u0005m\u0013\u0001\u0002;sS6\fq![:XQ>dW\r\u0006\u0002\u0002nB!\u0011\u0011KAx\u0013\u0011\t\t0!\u0011\u0003\u000f\t{w\u000e\\3b]\u0006QQO\u001c3fe2L\u0018N\\4\u0015\u0005\u0005]\b\u0003BA}\u0005\u0007i!!a?\u000b\t\u0005u\u0018q`\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0002\u0005!!.\u0019<b\u0013\u0011\u0011)!a?\u0003\r=\u0013'.Z2u\u0003!Ig\u000e\u001e,bYV,GCAA[\u0003%awN\\4WC2,X\r\u0006\u0002\u0003\u0010A!\u0011\u0011\u000bB\t\u0013\u0011\u0011\u0019\"!\u0011\u0003\t1{gnZ\u0001\u000bM2|\u0017\r\u001e,bYV,GC\u0001B\r!\u0011\t\tFa\u0007\n\t\tu\u0011\u0011\t\u0002\u0006\r2|\u0017\r^\u0001\fI>,(\r\\3WC2,X\r\u0006\u0002\u0003$A!\u0011\u0011\u000bB\u0013\u0013\u0011\u00119#!\u0011\u0003\r\u0011{WO\u00197f\u0003\u0015!x.\u00138u\u0003\u0019!x\u000eT8oOV\u0011!qB\u0001\ti>\u0014\u0015nZ%oiV\u0011!1\u0007\t\u0005\u0003\u0007\u0014)$\u0003\u0003\u00038\u0005]'A\u0002\"jO&sG/\u0001\u0005u_N#(/\u001b8h)\t\u0011i\u0004\u0005\u0003\u0003@\t\u001dc\u0002\u0002B!\u0005\u0007\u0002B!a2\u0002B%!!QIA!\u0003\u0019\u0001&/\u001a3fM&!!\u0011\nB&\u0005\u0019\u0019FO]5oO*!!QIA!\u0003\u0019!xNU3qeV\u0011!QH\u0001\u0007SNTVM]8\u0016\u0005\u00055\u0018!B5t\u001f:,\u0017!B5t\u001f\u0012$\u0017AB5t\u000bZ,g.\u0001\u0006q_^,'o\u00144Uo>\fqaY8na\u0006\u0014X\r\u0006\u0003\u00026\n\u0005\u0004b\u0002B27\u0001\u0007\u00111M\u0001\u0004e\"\u001cH\u0003BA[\u0005OBqAa\u0019\u001d\u0001\u0004\tY&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003[\u0014i\u0007C\u0004\u0003du\u0001\r!!!\u0002\u0013\u0011*\u0017\u000fJ3rI\u0015\fH\u0003BAw\u0005gBqAa\u0019\u001f\u0001\u0004\tY&A\u0006%KF$#-\u00198hI\u0015\fH\u0003BAw\u0005sBqAa\u0019 \u0001\u0004\tY&A\u0003%Y\u0016\u001c8\u000f\u0006\u0003\u0002n\n}\u0004b\u0002B2A\u0001\u0007\u00111L\u0001\tI1,7o\u001d\u0013fcR!\u0011Q\u001eBC\u0011\u001d\u0011\u0019'\ta\u0001\u00037\n\u0001\u0002J4sK\u0006$XM\u001d\u000b\u0005\u0003[\u0014Y\tC\u0004\u0003d\t\u0002\r!a\u0017\u0002\u0017\u0011:'/Z1uKJ$S-\u001d\u000b\u0005\u0003[\u0014\t\nC\u0004\u0003d\r\u0002\r!a\u0017\u0015\t\u00055(Q\u0013\u0005\b\u0005/#\u0003\u0019AA2\u0003\u0005\u0011H\u0003BAw\u00057CqAa&&\u0001\u0004\t\u0019\u0007\u0006\u0003\u0002n\n}\u0005b\u0002BLM\u0001\u0007\u00111\r\u000b\u0005\u0003[\u0014\u0019\u000bC\u0004\u0003\u0018\u001e\u0002\r!a\u0019\u0015\t\u00055(q\u0015\u0005\b\u0005/C\u0003\u0019\u0001B\u001a)\u0011\tiOa+\t\u000f\t]\u0015\u00061\u0001\u00034Q!\u0011Q\u001eBX\u0011\u001d\u00119J\u000ba\u0001\u0005g!B!!<\u00034\"9!qS\u0016A\u0002\tM\u0012!\u0002\u0013qYV\u001cH\u0003BA.\u0005sCqAa/-\u0001\u0004\t\u0019'\u0001\u0002sI\u00061A%\\5okN$B!a\u0017\u0003B\"9!1X\u0017A\u0002\u0005\r\u0014A\u0002\u0013uS6,7\u000f\u0006\u0003\u0002\\\t\u001d\u0007b\u0002B^]\u0001\u0007\u00111M\u0001\u000bI\u0011Lg\u000f\n;jY\u0012,G\u0003BA.\u0005\u001bDqAa/0\u0001\u0004\t\u0019'\u0001\u0003%I&4H\u0003BA.\u0005'DqAa/1\u0001\u0004\t\u0019'\u0001\u0005%a\u0016\u00148-\u001a8u)\u0011\tYF!7\t\u000f\tm\u0016\u00071\u0001\u0002d\u0005aA\u0005Z5wIA,'oY3oiR!!q\u001cBs!!\t\tF!9\u0002\\\u0005m\u0013\u0002\u0002Br\u0003\u0003\u0012a\u0001V;qY\u0016\u0014\u0004b\u0002B^e\u0001\u0007\u00111\r\u000b\u0005\u0005g\u0011I\u000fC\u0004\u0003dM\u0002\rAa\r\u0015\t\tM\"Q\u001e\u0005\b\u0005G\"\u0004\u0019\u0001B\u001a)\u0011\u0011\u0019D!=\t\u000f\t\rT\u00071\u0001\u00034Q!!1\u0007B{\u0011\u001d\u0011\u0019G\u000ea\u0001\u0005g!BAa\r\u0003z\"9!1M\u001cA\u0002\tMB\u0003\u0002B\u001a\u0005{DqAa\u00199\u0001\u0004\u0011\u0019\u0004\u0006\u0003\u0004\u0002\r\r\u0001\u0003CA)\u0005C\u0014\u0019Da\r\t\u000f\t\r\u0014\b1\u0001\u00034Q!\u00111LB\u0004\u0011\u001d\u0011\u0019G\u000fa\u0001\u00037\"B!a\u0017\u0004\f!9!1M\u001eA\u0002\u0005mC\u0003BA.\u0007\u001fAqAa\u0019=\u0001\u0004\tY&A\u0002q_^$B!a\u0017\u0004\u0016!9!1M\u001fA\u0002\u0005mC\u0003BA.\u00073AqAa\u0019?\u0001\u0004\t\u0019\u0007\u0006\u0003\u0002\\\ru\u0001b\u0002B2\u007f\u0001\u0007\u00111\f\u000b\u0005\u00037\u001a\t\u0003C\u0004\u0003d\u0001\u0003\r!a\u0017\u0015\t\u0005m3Q\u0005\u0005\b\u0005G\n\u0005\u0019AA.)\u0011\u0011yn!\u000b\t\u000f\t\r$\t1\u0001\u0002\\\u00059An\u001c8hI&4HC\u0002Bp\u0007_\u0019\u0019\u0004C\u0004\u00042\r\u0003\r!a\u0017\u0002\u00079,X\u000eC\u0004\u00046\r\u0003\r!a\u0017\u0002\u000b\u0011,gn\\7\u0002\u0015\u0011bWm]:%Y\u0016\u001c8\u000f\u0006\u0003\u0002\\\rm\u0002bBB\u001f\t\u0002\u0007\u0011QW\u0001\u0002]\u0006!1\r[8q)\u0011\tYfa\u0011\t\u000f\ruR\t1\u0001\u00026\u0006\u0001Be\u001a:fCR,'\u000fJ4sK\u0006$XM\u001d\u000b\u0005\u00037\u001aI\u0005C\u0004\u0004>\u0019\u0003\r!!.\u0002\t\u0011\u0012\u0017M\u001d\u000b\u0005\u00037\u001ay\u0005C\u0004\u0003d\u001d\u0003\r!a\u0017\u0015\t\u0005m31\u000b\u0005\b\u0005GB\u0005\u0019AA2\u0003\u0011!\u0013-\u001c9\u0015\t\u0005m3\u0011\f\u0005\b\u0005GJ\u0005\u0019AA.)\u0011\tYf!\u0018\t\u000f\t\r$\n1\u0001\u0002d\u0005\u0019A%\u001e9\u0015\t\u0005m31\r\u0005\b\u0005GZ\u0005\u0019AA.)\u0011\tYfa\u001a\t\u000f\t\rD\n1\u0001\u0002d%\u001a\u0001!X>\u0003\u000b\u0011Kw-\u001b;\u0014\u000f9\u001byg!\u001e\u0002PA!\u0011\u0011KB9\u0013\u0011\u0019\u0019(!\u0011\u0003\r\u0005s\u0017PU3g!\u0011\tifa\u001e\n\t\re\u0014q\u0006\u0002\u0011\u001d\u0006$XO]1m\u0013:\u001cH/\u00198dKN$\"a! \u0011\u0007\u0005uc*\u0001\u0004eK:|W\u000eI\u0001\u0010]\u0006$XO]1m)>\u0014\u0015nZ%oiR!!1GBC\u0011\u001d\u0019iD\u0015a\u0001\u00037\nQ!\u00199qYf$B!a\u0017\u0004\f\"91QR*A\u0002\r=\u0015AA;t!\u0019\t\tf!%\u0002d%!11SA!\u0005)a$/\u001a9fCR,GM\u0010\u000b\u0005\u00037\u001a9\nC\u0004\u0004>Q\u0003\rAa\u0004\u0015\t\u0005m31\u0014\u0005\b\u0007{)\u0006\u0019\u0001B\u001a\u0003\u0015!XM\\\u00199\u0003\u0019!XM\\\u00199AQ!\u00111LBR\u0011\u001d\u0019)\u000b\u0017a\u0001\u0005{\t\u0011a]\u0001\u0005u\u0016\u0014x.A\u0003{KJ|\u0007%A\u0002p]\u0016\fAa\u001c8fA\u0005)A)[4jiB\u001911W;\u000e\u00039\u001bR!^B\\\u0003\u001f\u0002\"b!/\u0004@\u0006\r\u00141LBb\u001b\t\u0019YL\u0003\u0003\u0004>\u0006\u0005\u0013a\u0002:v]RLW.Z\u0005\u0005\u0007\u0003\u001cYLA\tBEN$(/Y2u\rVt7\r^5p]J\u00022aa-^)\t\u0019\t\f\u0006\u0002\u0004JB!\u0011\u0011`Bf\u0013\u0011\u0011I%a?\u0015\r\r\r7qZBj\u0011\u001d\u0019\t\u000e\u001fa\u0001\u0003G\n\u0011\u0001\u001a\u0005\b\u0007+D\b\u0019AA.\u0003\t!H.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\rm71\u001d\t\u0007\u0003#\u001ain!9\n\t\r}\u0017\u0011\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0005E#\u0011]A2\u00037B\u0011b!:z\u0003\u0003\u0005\raa1\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,'aA#oIN910a\u0017\u0002P\r5\b\u0003BA)\u0007_LAa!=\u0002B\t9\u0001K]8ek\u000e$\u0018A\u00013!)\u0011\u00199p!?\u0011\u0007\rM6\u0010C\u0004\u0004Rz\u0004\r!a\u0019\u0015\t\u0005m3Q \u0005\t\u0007{\t\t\u00011\u0001\u0002dQ!\u00111\fC\u0001\u0011!\u0019i$a\u0001A\u0002\u0005\rD\u0003BA.\t\u000bA\u0001b!\u0010\u0002\u0006\u0001\u0007\u00111\r\u000b\u0005\u00037\"I\u0001\u0003\u0005\u0004>\u0005\u001d\u0001\u0019AA2)\u0011\tY\u0006\"\u0004\t\u0011\ru\u0012\u0011\u0002a\u0001\u0003G\"BAa8\u0005\u0012!A1QHA\u0006\u0001\u0004\t\u0019'\u0001\u0003d_BLH\u0003BB|\t/A!b!5\u0002\u000eA\u0005\t\u0019AA2\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"\u0001\"\b+\t\u0005\rDqD\u0016\u0003\tC\u0001B\u0001b\t\u0005.5\u0011AQ\u0005\u0006\u0005\tO!I#A\u0005v]\u000eDWmY6fI*!A1FA!\u0003)\tgN\\8uCRLwN\\\u0005\u0005\t_!)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCABe\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!!\u0005<!QAQHA\u000b\u0003\u0003\u0005\r!!.\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t!\u0019\u0005\u0005\u0004\u0005F\u0011-\u0013\u0011Q\u0007\u0003\t\u000fRA\u0001\"\u0013\u0002B\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00115Cq\t\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002n\u0012M\u0003B\u0003C\u001f\u00033\t\t\u00111\u0001\u0002\u0002\u0006A\u0001.Y:i\u0007>$W\rK\u0004|\t3\"y\u0006\"\u0019\u0011\t\u0005EC1L\u0005\u0005\t;\n\tE\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKz\t\u0001!A\u0002F]\u0012\u0004Baa-\u0002 M1\u0011q\u0004C5\u0003\u001f\u0002\u0002b!/\u0005l\u0005\r4q_\u0005\u0005\t[\u001aYLA\tBEN$(/Y2u\rVt7\r^5p]F\"\"\u0001\"\u001a\u0015\t\r]H1\u000f\u0005\t\u0007#\f)\u00031\u0001\u0002dQ!Aq\u000fC=!\u0019\t\tf!8\u0002d!Q1Q]A\u0014\u0003\u0003\u0005\raa>\u0014\u000fu\u000bY&a\u0014\u0004n\u0006\u0019A\u000f\u001c\u0011\u0015\r\r\rG\u0011\u0011CB\u0011\u001d\u0019\tN\u0019a\u0001\u0003GBqa!6c\u0001\u0004\tY&\u0001\u0003uC&dG\u0003BA.\t\u0013Cqa!\u0010f\u0001\u0004\t\u0019\u0007\u0006\u0003\u0002\\\u00115\u0005bBB\u001fM\u0002\u0007\u00111\r\u000b\u0005\u00037\"\t\nC\u0004\u0004>\u001d\u0004\r!a\u0019\u0015\t\u0005mCQ\u0013\u0005\b\u0007{A\u0007\u0019AA2)\u0011\tY\u0006\"'\t\u000f\ru\u0012\u000e1\u0001\u0002dQ!!q\u001cCO\u0011\u001d\u0019iD\u001ba\u0001\u0003G\"baa1\u0005\"\u0012\r\u0006\"CBiWB\u0005\t\u0019AA2\u0011%\u0019)n\u001bI\u0001\u0002\u0004\tY&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0011%&\u0006BA.\t?!B!!!\u0005.\"IAQ\b9\u0002\u0002\u0003\u0007\u0011Q\u0017\u000b\u0005\u0003[$\t\fC\u0005\u0005>I\f\t\u00111\u0001\u0002\u0002\":Q\f\"\u0017\u0005`\u0011\u0005\u0004f\u0002\u0001\u0005Z\u0011}C\u0011M\u0001\b\u001d\u0006$XO]1m\u0001")
public abstract class Natural
extends ScalaNumber
implements ScalaNumericConversions,
scala.Serializable {
    public static final long serialVersionUID = 0L;

    public static Natural one() {
        return Natural$.MODULE$.one();
    }

    public static Natural zero() {
        return Natural$.MODULE$.zero();
    }

    public static Natural apply(String string) {
        return Natural$.MODULE$.apply(string);
    }

    public static Natural apply(BigInt bigInt) {
        return Natural$.MODULE$.apply(bigInt);
    }

    public static Natural apply(long l) {
        return Natural$.MODULE$.apply(l);
    }

    public static Natural apply(Seq<UInt> seq) {
        return Natural$.MODULE$.apply(seq);
    }

    public static BigInt naturalToBigInt(Natural natural) {
        return Natural$.MODULE$.naturalToBigInt(natural);
    }

    public static NumberTag.CustomTag<Natural> NaturalTag() {
        return Natural$.MODULE$.NaturalTag();
    }

    public static NaturalAlgebra NaturalAlgebra() {
        return Natural$.MODULE$.NaturalAlgebra();
    }

    public char toChar() {
        return ScalaNumericAnyConversions.toChar$((ScalaNumericAnyConversions)this);
    }

    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$((ScalaNumericAnyConversions)this);
    }

    public short toShort() {
        return ScalaNumericAnyConversions.toShort$((ScalaNumericAnyConversions)this);
    }

    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$((ScalaNumericAnyConversions)this);
    }

    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidByte() {
        return ScalaNumericAnyConversions.isValidByte$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidShort() {
        return ScalaNumericAnyConversions.isValidShort$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidInt() {
        return ScalaNumericAnyConversions.isValidInt$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidChar() {
        return ScalaNumericAnyConversions.isValidChar$((ScalaNumericAnyConversions)this);
    }

    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$((ScalaNumericAnyConversions)this);
    }

    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$((ScalaNumericAnyConversions)this, (Object)x);
    }

    public abstract int digit();

    public <A> A foldDigitsLeft(A a, Function2<A, UInt, A> f) {
        return (A)this.recur$1(this, a, f, a);
    }

    public <A> A foldDigitsRight(A a, Function2<A, UInt, A> f) {
        return this.reversed().foldDigitsLeft(a, f);
    }

    public int getNumBits() {
        return this.recur$2(this, 0);
    }

    public int getDigitLength() {
        return this.recur$3(this, 0);
    }

    public List<UInt> toList() {
        return this.recur$4(this, (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public int[] toArray() {
        void var2_2;
        int n = this.getDigitLength();
        int[] arr = new int[n];
        this.recur$5(this, n - 1, arr);
        return var2_2;
    }

    public Natural reversed() {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int d = digit.d();
            Natural tail = digit.tl();
            natural = this.recur$6(tail, new End(d));
        } else {
            natural = this;
        }
        return natural;
    }

    public Natural trim() {
        return this.recur$7(this.reversed()).reversed();
    }

    public boolean isWhole() {
        return true;
    }

    public Object underlying() {
        return this;
    }

    public int intValue() {
        return this.toInt();
    }

    public long longValue() {
        return this.toLong();
    }

    public float floatValue() {
        return this.toBigInt().toFloat();
    }

    public double doubleValue() {
        return this.toBigInt().toDouble();
    }

    public int toInt() {
        return UInt$.MODULE$.toInt$extension(this.digit()) & Integer.MAX_VALUE;
    }

    public long toLong() {
        long l;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int d = end.d();
            l = UInt$.MODULE$.toLong$extension(d);
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int d = digit.d();
            Natural tail = digit.tl();
            l = (tail.toLong() << (int)32L) + UInt$.MODULE$.toLong$extension(d);
        } else {
            throw new MatchError((Object)natural);
        }
        return l;
    }

    public BigInt toBigInt() {
        BigInt bigInt;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int d = end.d();
            bigInt = package$.MODULE$.BigInt().apply(UInt$.MODULE$.toLong$extension(d));
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int d = digit.d();
            Natural tail = digit.tl();
            bigInt = tail.toBigInt().$less$less(32).$plus(package$.MODULE$.BigInt().apply(UInt$.MODULE$.toLong$extension(d)));
        } else {
            throw new MatchError((Object)natural);
        }
        return bigInt;
    }

    public String toString() {
        return this.recur$8(this, "");
    }

    public String toRepr() {
        return this.toList().mkString("Natural(", ", ", ")");
    }

    public boolean isZero() {
        return this.recur$9(this);
    }

    public boolean isOne() {
        boolean bl;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int n = end.d();
            bl = UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1));
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int n = digit.d();
            Natural tail = digit.tl();
            bl = UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1)) && tail.isZero();
        } else {
            throw new MatchError((Object)natural);
        }
        return bl;
    }

    public boolean isOdd() {
        return UInt$.MODULE$.$eq$eq$extension(UInt$.MODULE$.$amp$extension(this.digit(), UInt$.MODULE$.apply(1)), UInt$.MODULE$.apply(1));
    }

    public boolean isEven() {
        return UInt$.MODULE$.$eq$eq$extension(UInt$.MODULE$.$amp$extension(this.digit(), UInt$.MODULE$.apply(1)), UInt$.MODULE$.apply(0));
    }

    public int powerOfTwo() {
        return this.recur$10(this, 0, -1);
    }

    public int compare(int rhs) {
        int n;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int d = end.d();
            n = UInt$.MODULE$.$less$extension(d, rhs) ? -1 : (UInt$.MODULE$.$greater$extension(d, rhs) ? 1 : 0);
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int d = digit.d();
            Natural tail = digit.tl();
            n = tail.isZero() ? (UInt$.MODULE$.$greater$extension(d, rhs) ? 1 : (UInt$.MODULE$.$less$extension(d, rhs) ? -1 : 0)) : 1;
        } else {
            throw new MatchError((Object)natural);
        }
        return n;
    }

    public int compare(Natural rhs) {
        return this.recur$11(this, rhs, 0);
    }

    public final boolean equals(Object rhs) {
        boolean bl;
        Object object = rhs;
        if (object instanceof Natural) {
            Natural natural = (Natural)((Object)object);
            bl = this.$eq$eq$eq(natural);
        } else if (object instanceof UInt) {
            int n = ((UInt)object).signed();
            bl = this.compare(n) == 0;
        } else if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            BigInt bigInt2 = this.toBigInt();
            BigInt bigInt3 = bigInt;
            bl = !(bigInt2 != null ? !bigInt2.equals(bigInt3) : bigInt3 != null);
        } else if (object instanceof SafeLong) {
            SafeLong safeLong = (SafeLong)((Object)object);
            bl = BoxesRunTime.equalsNumNum((java.lang.Number)((Object)SafeLong$.MODULE$.apply(this.toBigInt())), (java.lang.Number)((Object)safeLong));
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            bl = bigDecimal.isWhole() && BoxesRunTime.equalsNumNum((java.lang.Number)this.toBigInt(), (java.lang.Number)bigDecimal);
        } else if (object instanceof Rational) {
            Rational rational = (Rational)((Object)object);
            bl = rational.isWhole() && BoxesRunTime.equalsNumNum((java.lang.Number)((Object)Rational$.MODULE$.apply(this.toBigInt())), (java.lang.Number)((Object)rational));
        } else if (object instanceof Algebraic) {
            Algebraic algebraic = (Algebraic)((Object)object);
            bl = BoxesRunTime.equalsNumNum((java.lang.Number)((Object)algebraic), (java.lang.Number)((Object)this));
        } else if (object instanceof Real) {
            Real real = (Real)object;
            bl = BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this), (java.lang.Number)((Object)real.toRational()));
        } else if (object instanceof Number) {
            Number number = (Number)object;
            Number number2 = Number$.MODULE$.apply(this.toBigInt());
            Number number3 = number;
            bl = !(number2 != null ? !number2.equals(number3) : number3 != null);
        } else {
            Quaternion quaternion;
            Complex complex;
            bl = object instanceof Complex ? BoxesRunTime.equalsNumNum((java.lang.Number)((Object)(complex = (Complex)((Object)object))), (java.lang.Number)((Object)this)) : (object instanceof Quaternion ? BoxesRunTime.equalsNumNum((java.lang.Number)((Object)(quaternion = (Quaternion)((Object)object))), (java.lang.Number)((Object)this)) : this.unifiedPrimitiveEquals(object));
        }
        return bl;
    }

    public boolean $eq$eq$eq(Natural rhs) {
        return this.compare(rhs) == 0;
    }

    public boolean $eq$bang$eq(Natural rhs) {
        return !this.$eq$eq$eq(rhs);
    }

    public boolean $less(Natural rhs) {
        return this.compare(rhs) < 0;
    }

    public boolean $less$eq(Natural rhs) {
        return this.compare(rhs) <= 0;
    }

    public boolean $greater(Natural rhs) {
        return this.compare(rhs) > 0;
    }

    public boolean $greater$eq(Natural rhs) {
        return this.compare(rhs) >= 0;
    }

    public boolean $less(int r) {
        return this.compare(r) < 0;
    }

    public boolean $less$eq(int r) {
        return this.compare(r) <= 0;
    }

    public boolean $greater(int r) {
        return this.compare(r) > 0;
    }

    public boolean $greater$eq(int r) {
        return this.compare(r) >= 0;
    }

    public boolean $less(BigInt r) {
        return this.toBigInt().compare(r) < 0;
    }

    public boolean $less$eq(BigInt r) {
        return this.toBigInt().compare(r) <= 0;
    }

    public boolean $greater(BigInt r) {
        return this.toBigInt().compare(r) > 0;
    }

    public boolean $greater$eq(BigInt r) {
        return this.toBigInt().compare(r) >= 0;
    }

    public abstract Natural $plus(int var1);

    public abstract Natural $minus(int var1);

    public abstract Natural $times(int var1);

    public Natural $div$tilde(int rd) {
        return this.$div(rd);
    }

    public abstract Natural $div(int var1);

    public abstract Natural $percent(int var1);

    public abstract Tuple2<Natural, Natural> $div$percent(int var1);

    public BigInt $plus(BigInt rhs) {
        return this.toBigInt().$plus(rhs);
    }

    public BigInt $minus(BigInt rhs) {
        return this.toBigInt().$minus(rhs);
    }

    public BigInt $times(BigInt rhs) {
        return this.toBigInt().$times(rhs);
    }

    public BigInt $div$tilde(BigInt rhs) {
        return this.toBigInt().$div(rhs);
    }

    public BigInt $div(BigInt rhs) {
        return this.toBigInt().$div(rhs);
    }

    public BigInt $percent(BigInt rhs) {
        return this.toBigInt().$percent(rhs);
    }

    public Tuple2<BigInt, BigInt> $div$percent(BigInt rhs) {
        return this.toBigInt().$div$percent(rhs);
    }

    public Natural $plus(Natural rhs) {
        return Natural.recur$12(this, rhs, 0L);
    }

    public Natural $minus(Natural rhs) {
        if (this.$less(rhs)) {
            throw new ArithmeticException(new StringOps(Predef$.MODULE$.augmentString("negative subtraction: %s - %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, rhs})));
        }
        return Natural.recur$13(this, rhs, 0L);
    }

    public Natural $times(Natural rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int ld = end.d();
            natural = rhs.$times(ld);
        } else if (natural2 instanceof Digit) {
            Natural natural3;
            Digit digit = (Digit)natural2;
            int ld = digit.d();
            Natural ltail = digit.tl();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end = (End)natural4;
                int rd = end.d();
                natural3 = this.$times(rd);
            } else if (natural4 instanceof Digit) {
                Digit digit2 = (Digit)natural4;
                int rd = digit2.d();
                Natural rtail = digit2.tl();
                natural3 = new Digit(UInt$.MODULE$.apply(0), new Digit(UInt$.MODULE$.apply(0), ltail.$times(rtail))).$plus(new Digit(UInt$.MODULE$.apply(0), ltail.$times(rd))).$plus(new Digit(UInt$.MODULE$.apply(0), rtail.$times(ld))).$plus(Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(ld) * UInt$.MODULE$.toLong$extension(rd)));
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Natural pow(Natural rhs) {
        return this._pow$1(Natural$.MODULE$.apply(1L), this, rhs);
    }

    public Natural pow(int rhs) {
        return this._pow$2(Natural$.MODULE$.apply(1L), this, rhs);
    }

    public Natural $div$tilde(Natural rhs) {
        return this.$div(rhs);
    }

    public Natural $div(Natural rhs) {
        Natural natural;
        Natural natural2 = rhs;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int rd = end.d();
            natural = this.$div(rd);
        } else if (natural2 instanceof Digit) {
            Natural natural3;
            Natural natural4 = this;
            if (natural4 instanceof End) {
                natural3 = new End(UInt$.MODULE$.apply(0));
            } else if (natural4 instanceof Digit) {
                Natural natural5;
                int n = rhs.compare(UInt$.MODULE$.apply(1));
                switch (n) {
                    case -1: {
                        throw new IllegalArgumentException("/ by zero");
                    }
                    case 0: {
                        natural5 = this;
                        break;
                    }
                    case 1: {
                        int p = rhs.powerOfTwo();
                        if (p >= 0) {
                            natural5 = this.$greater$greater(p);
                            break;
                        }
                        natural5 = (Natural)((Object)this.longdiv(this, rhs)._1());
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                natural3 = natural5;
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Natural $percent(Natural rhs) {
        Natural natural;
        Natural natural2 = rhs;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int rd = end.d();
            natural = this.$percent(rd);
        } else if (natural2 instanceof Digit) {
            End end;
            Natural natural3 = this;
            if (natural3 instanceof End) {
                End end2 = (End)natural3;
                int ld = end2.d();
                end = new End(ld);
            } else if (natural3 instanceof Digit) {
                Natural natural4;
                int n = rhs.compare(UInt$.MODULE$.apply(1));
                switch (n) {
                    case -1: {
                        throw new IllegalArgumentException("/ by zero");
                    }
                    case 0: {
                        natural4 = new End(UInt$.MODULE$.apply(0));
                        break;
                    }
                    case 1: {
                        int p = rhs.powerOfTwo();
                        if (p >= 0) {
                            natural4 = this.$amp(Natural$.MODULE$.apply(1L).$less$less(p).$minus(UInt$.MODULE$.apply(1)));
                            break;
                        }
                        natural4 = (Natural)((Object)this.longdiv(this, rhs)._2());
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                end = natural4;
            } else {
                throw new MatchError((Object)natural3);
            }
            natural = end;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Tuple2<Natural, Natural> $div$percent(Natural rhs) {
        Tuple2 tuple2;
        Natural natural = rhs;
        if (natural instanceof End) {
            End end = (End)natural;
            int rd = end.d();
            tuple2 = new Tuple2((Object)this.$div(rd), (Object)this.$percent(rd));
        } else if (natural instanceof Digit) {
            Tuple2 tuple22;
            Natural natural2 = this;
            if (natural2 instanceof End) {
                tuple22 = new Tuple2((Object)new End(UInt$.MODULE$.apply(0)), (Object)this);
            } else if (natural2 instanceof Digit) {
                Tuple2 tuple23;
                int n = rhs.compare(UInt$.MODULE$.apply(1));
                switch (n) {
                    case -1: {
                        throw new IllegalArgumentException("/ by zero");
                    }
                    case 0: {
                        tuple23 = new Tuple2((Object)this, (Object)Natural$.MODULE$.apply(0L));
                        break;
                    }
                    case 1: {
                        int p = rhs.powerOfTwo();
                        if (p >= 0) {
                            Natural mask = Natural$.MODULE$.apply(1L).$less$less(p).$minus(UInt$.MODULE$.apply(1));
                            tuple23 = new Tuple2((Object)this.$greater$greater(p), (Object)this.$amp(mask));
                            break;
                        }
                        tuple23 = this.longdiv(this, rhs);
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                tuple22 = tuple23;
            } else {
                throw new MatchError((Object)natural2);
            }
            tuple2 = tuple22;
        } else {
            throw new MatchError((Object)natural);
        }
        return tuple2;
    }

    private Tuple2<Natural, Natural> longdiv(Natural num, Natural denom) {
        Natural rem = num;
        Natural quo = Natural$.MODULE$.apply(0L);
        int remBits = rem.getNumBits();
        int denomBits = denom.getNumBits();
        int shift = remBits - denomBits;
        while (shift >= 0) {
            Natural shifted = denom.$less$less(shift);
            if (shifted.$less$eq(rem)) {
                quo = quo.$plus(Natural$.MODULE$.apply(1L).$less$less(shift));
                rem = rem.$minus(shifted);
                remBits = rem.getNumBits();
                shift = remBits - denomBits;
                continue;
            }
            --shift;
        }
        return new Tuple2((Object)quo, (Object)rem);
    }

    public Natural $less$less(int n2) {
        int m = n2 & 0x1F;
        Natural num = Natural.recur$14(this, 0L, m);
        return (Natural)((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n2 / 32).foldLeft((Object)num, (Function2 & Serializable & scala.Serializable)(n, x$4) -> Natural.$anonfun$$less$less$1(n, BoxesRunTime.unboxToInt((Object)x$4))));
    }

    public Natural chop(int n) {
        return this.recur$15(this, n);
    }

    public Natural $greater$greater(int n) {
        int m = n & 0x1F;
        return Natural.recur$16(this.chop(n / 32).reversed(), 0L, m).reversed();
    }

    public Natural $bar(Natural rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = new End(UInt$.MODULE$.$bar$extension(ld, rd));
            } else if (natural4 instanceof Digit) {
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                natural3 = new Digit(UInt$.MODULE$.$bar$extension(ld, rd), rtail);
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = rhs;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                digit = new Digit(UInt$.MODULE$.$bar$extension(ld, rd), ltail);
            } else if (natural5 instanceof Digit) {
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                digit = new Digit(UInt$.MODULE$.$bar$extension(ld, rd), ltail.$bar(rtail));
            } else {
                throw new MatchError((Object)natural5);
            }
            natural = digit;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Natural $bar(int rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int ld = end.d();
            natural = new End(UInt$.MODULE$.$bar$extension(ld, rhs));
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int ld = digit.d();
            Natural ltail = digit.tl();
            natural = new Digit(UInt$.MODULE$.$bar$extension(ld, rhs), ltail);
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Natural $amp(Natural rhs) {
        return Natural.and$1(this, rhs).trim();
    }

    public Natural $amp(int rhs) {
        return new End(UInt$.MODULE$.$amp$extension(this.digit(), rhs));
    }

    public Natural $up(Natural rhs) {
        return Natural.xor$1(this, rhs).trim();
    }

    public Natural $up(int rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int ld = end.d();
            natural = new End(UInt$.MODULE$.$up$extension(ld, rhs));
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int ld = digit.d();
            Natural ltail = digit.tl();
            natural = new Digit(UInt$.MODULE$.$up$extension(ld, rhs), ltail);
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public boolean foldDigitsLeft$mZc$sp(boolean a, Function2<Object, UInt, Object> f) {
        return this.recur$17(this, a, f, a);
    }

    public byte foldDigitsLeft$mBc$sp(byte a, Function2<Object, UInt, Object> f) {
        return this.recur$18(this, a, f, a);
    }

    public char foldDigitsLeft$mCc$sp(char a, Function2<Object, UInt, Object> f) {
        return this.recur$19(this, a, f, a);
    }

    public double foldDigitsLeft$mDc$sp(double a, Function2<Object, UInt, Object> f) {
        return this.recur$20(this, a, f, a);
    }

    public float foldDigitsLeft$mFc$sp(float a, Function2<Object, UInt, Object> f) {
        return this.recur$21(this, a, f, a);
    }

    public int foldDigitsLeft$mIc$sp(int a, Function2<Object, UInt, Object> f) {
        return this.recur$22(this, a, f, a);
    }

    public long foldDigitsLeft$mJc$sp(long a, Function2<Object, UInt, Object> f) {
        return this.recur$23(this, a, f, a);
    }

    public short foldDigitsLeft$mSc$sp(short a, Function2<Object, UInt, Object> f) {
        return this.recur$24(this, a, f, a);
    }

    public void foldDigitsLeft$mVc$sp(BoxedUnit a, Function2<BoxedUnit, UInt, BoxedUnit> f) {
        this.recur$25(this, a, f, a);
    }

    public boolean foldDigitsRight$mZc$sp(boolean a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mZc$sp(a, f);
    }

    public byte foldDigitsRight$mBc$sp(byte a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mBc$sp(a, f);
    }

    public char foldDigitsRight$mCc$sp(char a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mCc$sp(a, f);
    }

    public double foldDigitsRight$mDc$sp(double a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mDc$sp(a, f);
    }

    public float foldDigitsRight$mFc$sp(float a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mFc$sp(a, f);
    }

    public int foldDigitsRight$mIc$sp(int a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mIc$sp(a, f);
    }

    public long foldDigitsRight$mJc$sp(long a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mJc$sp(a, f);
    }

    public short foldDigitsRight$mSc$sp(short a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mSc$sp(a, f);
    }

    public void foldDigitsRight$mVc$sp(BoxedUnit a, Function2<BoxedUnit, UInt, BoxedUnit> f) {
        this.reversed().foldDigitsLeft$mVc$sp(a, f);
    }

    private final Object recur$1(Natural next, Object sofar, Function2 f$1, Object a$1) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = f$1.apply(a$1, (Object)new UInt(d));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        Object object = f$1.apply(a$1, (Object)new UInt(d));
        return object;
    }

    private final int bit$1(int n, int b) {
        while (!UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
            ++b;
            n = UInt$.MODULE$.$greater$greater$greater$extension(n, 1);
        }
        return b;
    }

    private final int recur$2(Natural next, int b) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                Natural tail = digit.tl();
                b += 32;
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        int n = b + this.bit$1(d, 0);
        return n;
    }

    private final int recur$3(Natural next, int n) {
        block1: {
            Natural natural;
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                Natural tail = digit.tl();
                ++n;
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        int n2 = n + 1;
        return n2;
    }

    private final List recur$4(Natural next, List sofar) {
        int d;
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d2 = digit.d();
                Natural tail = digit.tl();
                int n = d2;
                sofar = sofar.$colon$colon((Object)new UInt(n));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int n = d = end.d();
        List list = sofar.$colon$colon((Object)new UInt(n));
        return list;
    }

    private final void recur$5(Natural next, int i, int[] arr$1) {
        int d;
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d2 = digit.d();
                Natural tail = digit.tl();
                arr$1[i] = d2;
                --i;
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        arr$1[i] = d = end.d();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final Natural recur$6(Natural next, Natural sofar) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = new Digit(d, sofar);
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        Digit digit = new Digit(d, sofar);
        return digit;
    }

    private final Natural recur$7(Natural next) {
        Natural natural;
        block4: {
            Natural natural2;
            while ((natural2 = next) instanceof Digit) {
                Digit digit = (Digit)natural2;
                int n = digit.d();
                Natural tail = digit.tl();
                if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                    next = tail;
                    continue;
                }
                natural = next;
                break block4;
            }
            if (natural2 instanceof End) {
                natural = next;
            } else {
                throw new MatchError((Object)natural2);
            }
        }
        return natural;
    }

    private final String recur$8(Natural next, String s) {
        String string;
        block3: {
            Natural natural;
            block4: {
                Natural r;
                while (true) {
                    if ((natural = next) instanceof End) {
                        End end = (End)natural;
                        int d = end.d();
                        string = new StringBuilder(0).append(((Object)BoxesRunTime.boxToLong((long)UInt$.MODULE$.toLong$extension(d))).toString()).append(s).toString();
                        break block3;
                    }
                    if (!(natural instanceof Digit)) break block4;
                    Tuple2<Natural, Natural> tuple2 = next.$div$percent(Natural$.MODULE$.denom());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Natural q = (Natural)((Object)tuple2._1());
                    Natural r2 = (Natural)((Object)tuple2._2());
                    Tuple2 tuple22 = new Tuple2((Object)q, (Object)r2);
                    Tuple2 tuple23 = tuple22;
                    Natural q2 = (Natural)((Object)tuple23._1());
                    r = (Natural)((Object)tuple23._2());
                    if (q2.isZero()) break;
                    s = new StringOps(Predef$.MODULE$.augmentString("%09d%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)UInt$.MODULE$.toLong$extension(r.digit())), s}));
                    next = q2;
                }
                string = new StringBuilder(0).append(((Object)BoxesRunTime.boxToLong((long)UInt$.MODULE$.toLong$extension(r.digit()))).toString()).append(s).toString();
                break block3;
            }
            throw new MatchError((Object)natural);
        }
        return string;
    }

    private final boolean recur$9(Natural next) {
        boolean bl;
        block2: {
            Natural natural;
            block3: {
                while (true) {
                    if ((natural = next) instanceof End) {
                        End end = (End)natural;
                        int n = end.d();
                        bl = UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0));
                        break block2;
                    }
                    if (!(natural instanceof Digit)) break block3;
                    Digit digit = (Digit)natural;
                    int n = digit.d();
                    Natural tail = digit.tl();
                    if (!UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) break;
                    next = tail;
                }
                bl = false;
                break block2;
            }
            throw new MatchError((Object)natural);
        }
        return bl;
    }

    private static final int test$1(int n) {
        int i;
        if ((n & -n) != n) {
            return -1;
        }
        for (i = 1; i < 32 && UInt$.MODULE$.$bang$eq$extension(UInt$.MODULE$.$greater$greater$greater$extension(n, i), UInt$.MODULE$.apply(0)); ++i) {
        }
        return i - 1;
    }

    private final int recur$10(Natural next, int shift, int bit) {
        int n;
        block3: {
            Natural natural;
            block4: {
                while (true) {
                    if ((natural = next) instanceof End) {
                        End end = (End)natural;
                        int n2 = end.d();
                        int t = Natural.test$1(n2);
                        n = t < 0 ? -1 : (bit < 0 ? shift + t : -1);
                        break block3;
                    }
                    if (!(natural instanceof Digit)) break block4;
                    Digit digit = (Digit)natural;
                    int n3 = digit.d();
                    Natural tail = digit.tl();
                    int t = Natural.test$1(n3);
                    if (t < 0) {
                        shift += 32;
                        next = tail;
                        continue;
                    }
                    if (bit >= 0) break;
                    bit = shift + t;
                    shift += 32;
                    next = tail;
                }
                n = -1;
                break block3;
            }
            throw new MatchError((Object)natural);
        }
        return n;
    }

    private static final int cmp$1(int a, int b, int c) {
        return UInt$.MODULE$.$less$extension(a, b) ? -1 : (UInt$.MODULE$.$greater$extension(a, b) ? 1 : c);
    }

    private final int recur$11(Natural lhs, Natural rhs, int d) {
        int n;
        block6: {
            Natural natural;
            block7: {
                Natural natural2;
                block8: {
                    while (true) {
                        if ((natural = lhs) instanceof End) {
                            int n2;
                            End end = (End)natural;
                            int ld = end.d();
                            Natural natural3 = rhs;
                            if (natural3 instanceof End) {
                                End end2 = (End)natural3;
                                int rd = end2.d();
                                n2 = Natural.cmp$1(ld, rd, d);
                            } else if (natural3 instanceof Digit) {
                                n2 = -rhs.compare(ld);
                            } else {
                                throw new MatchError((Object)natural3);
                            }
                            n = n2;
                            break block6;
                        }
                        if (!(natural instanceof Digit)) break block7;
                        Digit digit = (Digit)natural;
                        int ld = digit.d();
                        Natural ltail = digit.tl();
                        natural2 = rhs;
                        if (natural2 instanceof End) break block8;
                        if (!(natural2 instanceof Digit)) break;
                        Digit digit2 = (Digit)natural2;
                        int rd = digit2.d();
                        Natural rtail = digit2.tl();
                        d = Natural.cmp$1(ld, rd, d);
                        rhs = rtail;
                        lhs = ltail;
                    }
                    throw new MatchError((Object)natural2);
                }
                End end = (End)natural2;
                int rd = end.d();
                int n3 = lhs.compare(rd);
                n = n3;
                break block6;
            }
            throw new MatchError((Object)natural);
        }
        return n;
    }

    private static final Natural recur$12(Natural left, Natural right, long carry) {
        Natural natural;
        Natural natural2 = left;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = right;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry);
            } else if (natural4 instanceof Digit) {
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                long t = UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry;
                natural3 = new Digit(UInt$.MODULE$.apply(t), rtail.$plus(UInt$.MODULE$.apply(t >> 32)));
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = right;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                long t = UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry;
                digit = new Digit(UInt$.MODULE$.apply(t), ltail.$plus(UInt$.MODULE$.apply(t >> 32)));
            } else if (natural5 instanceof Digit) {
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                long t = UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry;
                digit = new Digit(UInt$.MODULE$.apply(t), Natural.recur$12(ltail, rtail, t >> 32));
            } else {
                throw new MatchError((Object)natural5);
            }
            natural = digit;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    private static final Natural recur$13(Natural left, Natural right, long carry) {
        Natural natural;
        Natural natural2 = left;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = right;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry);
            } else if (natural4 instanceof Digit) {
                long t;
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                Natural tl = rtail.$minus(UInt$.MODULE$.apply(-((t = UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry) >> 32)));
                natural3 = tl instanceof End && UInt$.MODULE$.$eq$eq$extension(tl.digit(), UInt$.MODULE$.apply(0)) ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), tl);
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = right;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                long t = UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry;
                Natural tl = ltail.$minus(UInt$.MODULE$.apply(-(t >> 32)));
                digit = tl instanceof End && UInt$.MODULE$.$eq$eq$extension(tl.digit(), UInt$.MODULE$.apply(0)) ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), tl);
            } else if (natural5 instanceof Digit) {
                long t;
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                Natural tl = Natural.recur$13(ltail, rtail, -((t = UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry) >> 32));
                digit = tl instanceof End && UInt$.MODULE$.$eq$eq$extension(tl.digit(), UInt$.MODULE$.apply(0)) ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), tl);
            } else {
                throw new MatchError((Object)natural5);
            }
            natural = digit;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    private final Natural _pow$1(Natural t, Natural b, Natural e) {
        while (!e.isZero()) {
            if (e.isOdd()) {
                Natural natural = t.$times(b);
                e = e.$greater$greater(1);
                b = b.$times(b);
                t = natural;
                continue;
            }
            e = e.$greater$greater(1);
            b = b.$times(b);
        }
        return t;
    }

    private final Natural _pow$2(Natural t, Natural b, int e) {
        while (!UInt$.MODULE$.$eq$eq$extension(e, UInt$.MODULE$.apply(0))) {
            if (UInt$.MODULE$.$eq$eq$extension(UInt$.MODULE$.$amp$extension(e, UInt$.MODULE$.apply(1)), UInt$.MODULE$.apply(1))) {
                Natural natural = t.$times(b);
                e = UInt$.MODULE$.$greater$greater$extension(e, 1);
                b = b.$times(b);
                t = natural;
                continue;
            }
            e = UInt$.MODULE$.$greater$greater$extension(e, 1);
            b = b.$times(b);
        }
        return t;
    }

    private static final Natural recur$14(Natural next, long carry, int m$1) {
        Natural natural;
        Natural natural2 = next;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int d = end.d();
            natural = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(d) << m$1 | carry);
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int d = digit.d();
            Natural tail = digit.tl();
            long t = UInt$.MODULE$.toLong$extension(d) << m$1 | carry;
            natural = new Digit(UInt$.MODULE$.apply(t), Natural.recur$14(tail, t >> 32, m$1));
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public static final /* synthetic */ Digit $anonfun$$less$less$1(Natural n, int x$4) {
        return new Digit(UInt$.MODULE$.apply(0), n);
    }

    private final Natural recur$15(Natural next, int n) {
        Natural natural;
        block2: {
            block3: {
                Natural natural2;
                while (true) {
                    if (n <= 0) {
                        natural = next;
                        break block2;
                    }
                    natural2 = next;
                    if (natural2 instanceof End) break block3;
                    if (!(natural2 instanceof Digit)) break;
                    Digit digit = (Digit)natural2;
                    Natural tail = digit.tl();
                    --n;
                    next = tail;
                }
                throw new MatchError((Object)natural2);
            }
            End end = new End(UInt$.MODULE$.apply(0));
            natural = end;
        }
        return natural;
    }

    private static final Natural recur$16(Natural next, long carry, int m$2) {
        Natural natural;
        Natural natural2 = next;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int d = end.d();
            natural = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(d) >> m$2 | carry);
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int d = digit.d();
            Natural tail = digit.tl();
            long t = (UInt$.MODULE$.toLong$extension(d) | carry) << 32 - m$2;
            natural = new Digit(UInt$.MODULE$.apply(t >> 32), Natural.recur$16(tail, t & 0xFFFFFFFFL, m$2));
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    private static final Natural and$1(Natural lhs, Natural rhs) {
        End end;
        Natural natural = lhs;
        if (natural instanceof End) {
            End end2;
            End end3 = (End)natural;
            int ld = end3.d();
            Natural natural2 = rhs;
            if (natural2 instanceof End) {
                End end4 = (End)natural2;
                int rd = end4.d();
                end2 = new End(UInt$.MODULE$.$amp$extension(ld, rd));
            } else if (natural2 instanceof Digit) {
                Digit digit = (Digit)natural2;
                int rd = digit.d();
                end2 = new End(UInt$.MODULE$.$amp$extension(ld, rd));
            } else {
                throw new MatchError((Object)natural2);
            }
            end = end2;
        } else if (natural instanceof Digit) {
            Natural natural3;
            Digit digit = (Digit)natural;
            int ld = digit.d();
            Natural ltail = digit.tl();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end5 = (End)natural4;
                int rd = end5.d();
                natural3 = new End(UInt$.MODULE$.$amp$extension(ld, rd));
            } else if (natural4 instanceof Digit) {
                Digit digit2 = (Digit)natural4;
                int rd = digit2.d();
                Natural rtail = digit2.tl();
                natural3 = new Digit(UInt$.MODULE$.$amp$extension(ld, rd), Natural.and$1(ltail, rtail));
            } else {
                throw new MatchError((Object)natural4);
            }
            end = natural3;
        } else {
            throw new MatchError((Object)natural);
        }
        return end;
    }

    private static final Natural xor$1(Natural lhs, Natural rhs) {
        Natural natural;
        Natural natural2 = lhs;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = new End(UInt$.MODULE$.$up$extension(ld, rd));
            } else if (natural4 instanceof Digit) {
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                natural3 = new Digit(UInt$.MODULE$.$up$extension(ld, rd), rtail);
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = rhs;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                digit = new Digit(UInt$.MODULE$.$up$extension(ld, rd), ltail);
            } else if (natural5 instanceof Digit) {
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                digit = new Digit(UInt$.MODULE$.$up$extension(ld, rd), ltail.$up(rtail));
            } else {
                throw new MatchError((Object)natural5);
            }
            natural = digit;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    private final boolean recur$17(Natural next, boolean sofar, Function2 f$2, boolean a$2) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToBoolean((Object)f$2.apply((Object)BoxesRunTime.boxToBoolean((boolean)a$2), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)f$2.apply((Object)BoxesRunTime.boxToBoolean((boolean)a$2), (Object)new UInt(d)));
        return bl;
    }

    private final byte recur$18(Natural next, byte sofar, Function2 f$3, byte a$3) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToByte((Object)f$3.apply((Object)BoxesRunTime.boxToByte((byte)a$3), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        byte by = BoxesRunTime.unboxToByte((Object)f$3.apply((Object)BoxesRunTime.boxToByte((byte)a$3), (Object)new UInt(d)));
        return by;
    }

    private final char recur$19(Natural next, char sofar, Function2 f$4, char a$4) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToChar((Object)f$4.apply((Object)BoxesRunTime.boxToCharacter((char)a$4), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        char c = BoxesRunTime.unboxToChar((Object)f$4.apply((Object)BoxesRunTime.boxToCharacter((char)a$4), (Object)new UInt(d)));
        return c;
    }

    private final double recur$20(Natural next, double sofar, Function2 f$5, double a$5) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToDouble((Object)f$5.apply((Object)BoxesRunTime.boxToDouble((double)a$5), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        double d2 = BoxesRunTime.unboxToDouble((Object)f$5.apply((Object)BoxesRunTime.boxToDouble((double)a$5), (Object)new UInt(d)));
        return d2;
    }

    private final float recur$21(Natural next, float sofar, Function2 f$6, float a$6) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToFloat((Object)f$6.apply((Object)BoxesRunTime.boxToFloat((float)a$6), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        float f = BoxesRunTime.unboxToFloat((Object)f$6.apply((Object)BoxesRunTime.boxToFloat((float)a$6), (Object)new UInt(d)));
        return f;
    }

    private final int recur$22(Natural next, int sofar, Function2 f$7, int a$7) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToInt((Object)f$7.apply((Object)BoxesRunTime.boxToInteger((int)a$7), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        int n = BoxesRunTime.unboxToInt((Object)f$7.apply((Object)BoxesRunTime.boxToInteger((int)a$7), (Object)new UInt(d)));
        return n;
    }

    private final long recur$23(Natural next, long sofar, Function2 f$8, long a$8) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToLong((Object)f$8.apply((Object)BoxesRunTime.boxToLong((long)a$8), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        long l = BoxesRunTime.unboxToLong((Object)f$8.apply((Object)BoxesRunTime.boxToLong((long)a$8), (Object)new UInt(d)));
        return l;
    }

    private final short recur$24(Natural next, short sofar, Function2 f$9, short a$9) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToShort((Object)f$9.apply((Object)BoxesRunTime.boxToShort((short)a$9), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        short s = BoxesRunTime.unboxToShort((Object)f$9.apply((Object)BoxesRunTime.boxToShort((short)a$9), (Object)new UInt(d)));
        return s;
    }

    private final void recur$25(Natural next, BoxedUnit sofar, Function2 f$10, BoxedUnit a$10) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = (BoxedUnit)f$10.apply((Object)a$10, (Object)new UInt(d));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        BoxedUnit boxedUnit = (BoxedUnit)f$10.apply((Object)a$10, (Object)new UInt(d));
    }

    public Natural() {
        ScalaNumericAnyConversions.$init$((ScalaNumericAnyConversions)this);
    }

    public static class Digit
    extends Natural
    implements Product {
        public static final long serialVersionUID = 0L;
        private final int d;
        private final Natural tl;

        public int d() {
            return this.d;
        }

        public Natural tl() {
            return this.tl;
        }

        @Override
        public int digit() {
            return this.d();
        }

        public Natural tail() {
            return this.tl();
        }

        @Override
        public Natural $plus(int n) {
            Digit digit;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                digit = this;
            } else {
                long t = UInt$.MODULE$.toLong$extension(this.d()) + UInt$.MODULE$.toLong$extension(n);
                digit = new Digit(UInt$.MODULE$.apply(t), this.tail().$plus(UInt$.MODULE$.apply(t >> 32)));
            }
            return digit;
        }

        @Override
        public Natural $minus(int n) {
            Digit digit;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                digit = this;
            } else {
                long t = UInt$.MODULE$.toLong$extension(this.d()) - UInt$.MODULE$.toLong$extension(n);
                digit = new Digit(UInt$.MODULE$.apply(t), this.tail().$minus(UInt$.MODULE$.apply(-(t >> 32))));
            }
            return digit;
        }

        @Override
        public Natural $times(int n) {
            return UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0)) ? new End(n) : (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1)) ? this : Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(this.d()) * UInt$.MODULE$.toLong$extension(n)).$plus(new Digit(UInt$.MODULE$.apply(0), this.tl().$times(n))));
        }

        @Override
        public Natural $div(int n) {
            return (Natural)((Object)this.$div$percent(n)._1());
        }

        @Override
        public Natural $percent(int n) {
            return (Natural)((Object)this.$div$percent(n)._2());
        }

        @Override
        public Tuple2<Natural, Natural> $div$percent(int n) {
            Tuple2 tuple2;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                throw new IllegalArgumentException("/ by zero");
            }
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1))) {
                tuple2 = new Tuple2((Object)this, (Object)Natural$.MODULE$.apply((Seq<UInt>)Predef$.MODULE$.genericWrapArray((Object)new UInt[]{new UInt(UInt$.MODULE$.apply(0))})));
            } else {
                Natural natural = this.reversed();
                if (!(natural instanceof Digit)) {
                    throw new IllegalArgumentException("bug in reversed");
                }
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                int q = UInt$.MODULE$.$div$extension(d, n);
                int r = UInt$.MODULE$.$percent$extension(d, n);
                Tuple2 tuple22 = this.recur$26(tail, r, new End(q), n);
                tuple2 = tuple22;
            }
            return tuple2;
        }

        public Digit copy(int d, Natural tl) {
            return new Digit(d, tl);
        }

        public int copy$default$1() {
            return this.d();
        }

        public Natural copy$default$2() {
            return this.tl();
        }

        public String productPrefix() {
            return "Digit";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = new UInt(this.d());
                    break;
                }
                case 1: {
                    object = this.tl();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Digit;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        private final Tuple2 recur$26(Natural next, int rem, Natural sofar, int n$1) {
            long r;
            long q;
            block1: {
                Natural natural;
                while (true) {
                    long t = ULong$.MODULE$.$plus$extension(ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(rem) << 32), ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(next.digit())));
                    q = ULong$.MODULE$.toLong$extension(ULong$.MODULE$.$div$extension(t, ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(n$1))));
                    r = ULong$.MODULE$.toLong$extension(ULong$.MODULE$.$percent$extension(t, ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(n$1))));
                    natural = next;
                    if (natural instanceof End) break block1;
                    if (!(natural instanceof Digit)) break;
                    Digit digit = (Digit)natural;
                    Natural tail = digit.tl();
                    sofar = new Digit(UInt$.MODULE$.apply(q), sofar);
                    rem = UInt$.MODULE$.apply(r);
                    next = tail;
                }
                throw new MatchError((Object)natural);
            }
            Tuple2 tuple2 = new Tuple2((Object)new Digit(UInt$.MODULE$.apply(q), sofar), (Object)new End(UInt$.MODULE$.apply(r)));
            return tuple2;
        }

        public Digit(int d, Natural tl) {
            this.d = d;
            this.tl = tl;
            Product.$init$((Product)this);
        }
    }

    public static class End
    extends Natural
    implements Product {
        public static final long serialVersionUID = 0L;
        private final int d;

        public int d() {
            return this.d;
        }

        @Override
        public int digit() {
            return this.d();
        }

        @Override
        public Natural $plus(int n) {
            long t;
            return UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0)) ? this : ((t = UInt$.MODULE$.toLong$extension(this.d()) + UInt$.MODULE$.toLong$extension(n)) <= 0xFFFFFFFFL ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), new End(UInt$.MODULE$.apply(1))));
        }

        @Override
        public Natural $minus(int n) {
            End end;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                end = this;
            } else {
                long t = UInt$.MODULE$.toLong$extension(this.d()) - UInt$.MODULE$.toLong$extension(n);
                if (t >= 0L) {
                    end = new End(UInt$.MODULE$.apply((int)t));
                } else {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("illegal subtraction: %s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, new UInt(n)})));
                }
            }
            return end;
        }

        @Override
        public Natural $times(int n) {
            return UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0)) ? new End(n) : (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1)) ? this : Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(this.d()) * UInt$.MODULE$.toLong$extension(n)));
        }

        @Override
        public Natural $div(int n) {
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                throw new IllegalArgumentException("/ by zero");
            }
            return new End(UInt$.MODULE$.$div$extension(this.d(), n));
        }

        @Override
        public Natural $percent(int n) {
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                throw new IllegalArgumentException("/ by zero");
            }
            return new End(UInt$.MODULE$.$percent$extension(this.d(), n));
        }

        @Override
        public Tuple2<Natural, Natural> $div$percent(int n) {
            return new Tuple2((Object)this.$div(n), (Object)this.$percent(n));
        }

        public End copy(int d) {
            return new End(d);
        }

        public int copy$default$1() {
            return this.d();
        }

        public String productPrefix() {
            return "End";
        }

        public int productArity() {
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return new UInt(this.d());
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof End;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public End(int d) {
            this.d = d;
            Product.$init$((Product)this);
        }
    }
}

