/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.log.Logger;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;

public class FileLogger
implements Logger {
    private LogRecord logRecord;
    protected byte[] encryptionBuffer;
    private DynamicByteArrayOutputStream logOutputBuffer;
    private FormatIdOutputStream logicalOut;
    private ArrayInputStream logIn;
    private LogToFile logFactory;

    public FileLogger(LogToFile logToFile) {
        this.logFactory = logToFile;
        this.logOutputBuffer = new DynamicByteArrayOutputStream(1024);
        this.logicalOut = new FormatIdOutputStream(this.logOutputBuffer);
        this.logIn = new ArrayInputStream();
        this.logRecord = new LogRecord();
    }

    public void close() throws IOException {
        if (this.logOutputBuffer != null) {
            this.logOutputBuffer.close();
            this.logOutputBuffer = null;
        }
        this.logIn = null;
        this.logFactory = null;
        this.logicalOut = null;
        this.logRecord = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LogInstant logAndDo(RawTransaction rawTransaction, Loggable loggable) throws StandardException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            LogCounter logCounter;
            block19: {
                byte[] byArray;
                this.logOutputBuffer.reset();
                TransactionId transactionId = rawTransaction.getId();
                this.logRecord.setValue(transactionId, loggable);
                bl2 = true;
                this.logicalOut.writeObject(this.logRecord);
                bl2 = false;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                ByteArray byteArray = loggable.getPreparedLog();
                if (byteArray != null) {
                    byArray = byteArray.getArray();
                    n = byteArray.getLength();
                    n2 = byteArray.getOffset();
                    this.logIn.setData(byArray);
                    this.logIn.setPosition(n2);
                    this.logIn.setLimit(n);
                } else {
                    byArray = null;
                    n = 0;
                }
                this.logicalOut.writeInt(n);
                n3 = this.logOutputBuffer.getPosition() + n;
                logCounter = null;
                int n4 = 0;
                try {
                    if (this.logFactory.databaseEncrypted()) {
                        n4 = n3;
                        if (n4 % this.logFactory.getEncryptionBlockSize() != 0) {
                            n4 = n4 + this.logFactory.getEncryptionBlockSize() - n4 % this.logFactory.getEncryptionBlockSize();
                        }
                        if (this.encryptionBuffer == null || this.encryptionBuffer.length < n4) {
                            this.encryptionBuffer = new byte[n4];
                        }
                        System.arraycopy(this.logOutputBuffer.getByteArray(), 0, this.encryptionBuffer, 0, n3 - n);
                        if (n > 0) {
                            System.arraycopy(byArray, n2, this.encryptionBuffer, n3 - n, n);
                        }
                        int n5 = this.logFactory.encrypt(this.encryptionBuffer, 0, n4, this.encryptionBuffer, 0);
                    }
                    if ((loggable.group() & 3) != 0) {
                        LogToFile logToFile = this.logFactory;
                        synchronized (logToFile) {
                            long l = 0L;
                            l = this.logFactory.databaseEncrypted() ? this.logFactory.appendLogRecord(this.encryptionBuffer, 0, n4, null, -1, 0) : this.logFactory.appendLogRecord(this.logOutputBuffer.getByteArray(), 0, n3, byArray, n2, n);
                            logCounter = new LogCounter(l);
                            loggable.doMe(rawTransaction, logCounter, this.logIn);
                            break block19;
                        }
                    }
                    long l = 0L;
                    l = this.logFactory.databaseEncrypted() ? this.logFactory.appendLogRecord(this.encryptionBuffer, 0, n4, null, -1, 0) : this.logFactory.appendLogRecord(this.logOutputBuffer.getByteArray(), 0, n3, byArray, n2, n);
                    logCounter = new LogCounter(l);
                    loggable.doMe(rawTransaction, logCounter, this.logIn);
                }
                catch (StandardException standardException) {
                    throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", standardException, loggable));
                }
                catch (IOException iOException) {
                    throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", iOException, loggable));
                }
                finally {
                    this.logIn.clearLimit();
                }
            }
            return logCounter;
        }
        catch (IOException iOException) {
            if (bl2) {
                throw StandardException.newException("XSLB1.S", iOException, loggable);
            }
            throw StandardException.newException("XSLB2.S", iOException, loggable);
        }
    }

    @Override
    public LogInstant logAndUndo(RawTransaction rawTransaction, Compensation compensation, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        boolean bl = false;
        try {
            this.logOutputBuffer.reset();
            TransactionId transactionId = rawTransaction.getId();
            this.logRecord.setValue(transactionId, compensation);
            bl = true;
            this.logicalOut.writeObject(this.logRecord);
            bl = false;
            this.logicalOut.writeLong(((LogCounter)logInstant).getValueAsLong());
            int n = this.logOutputBuffer.getPosition();
            long l = 0L;
            if (this.logFactory.databaseEncrypted()) {
                int n2 = n;
                if (n2 % this.logFactory.getEncryptionBlockSize() != 0) {
                    n2 = n2 + this.logFactory.getEncryptionBlockSize() - n2 % this.logFactory.getEncryptionBlockSize();
                }
                if (this.encryptionBuffer == null || this.encryptionBuffer.length < n2) {
                    this.encryptionBuffer = new byte[n2];
                }
                System.arraycopy(this.logOutputBuffer.getByteArray(), 0, this.encryptionBuffer, 0, n);
                int n3 = this.logFactory.encrypt(this.encryptionBuffer, 0, n2, this.encryptionBuffer, 0);
                l = this.logFactory.appendLogRecord(this.encryptionBuffer, 0, n2, null, 0, 0);
            } else {
                l = this.logFactory.appendLogRecord(this.logOutputBuffer.getByteArray(), 0, n, null, 0, 0);
            }
            LogCounter logCounter = new LogCounter(l);
            try {
                compensation.doMe(rawTransaction, logCounter, limitObjectInput);
            }
            catch (StandardException standardException) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", standardException, compensation));
            }
            catch (IOException iOException) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", iOException, compensation));
            }
            return logCounter;
        }
        catch (IOException iOException) {
            if (bl) {
                throw StandardException.newException("XSLB1.S", iOException, compensation);
            }
            throw StandardException.newException("XSLB2.S", iOException, compensation);
        }
    }

    @Override
    public void flush(LogInstant logInstant) throws StandardException {
        this.logFactory.flush(logInstant);
    }

    @Override
    public void flushAll() throws StandardException {
        this.logFactory.flushAll();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reprepare(RawTransaction var1_1, TransactionId var2_2, LogInstant var3_3, LogInstant var4_4) throws StandardException {
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = null;
        var8_8 = null;
        try {
            block16: {
                if (var4_4 != null) break block16;
                var9_9 = (StreamLogScan)this.logFactory.openBackwardsScan(var3_3);
                ** GOTO lbl34
            }
            if (var4_4.lessThan(var3_3)) {
                if (var8_8 == null) return;
            }
            ** GOTO lbl-1000
        }
        catch (ClassNotFoundException var9_11) {
            try {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", var9_11, new Object[0]));
                catch (IOException var9_12) {
                    throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", var9_12, new Object[0]));
                }
                catch (StandardException var9_13) {
                    throw this.logFactory.markCorrupt(StandardException.newException("XSLA8.D", var9_13, new Object[]{var2_2, var7_7, null}));
                }
            }
            catch (Throwable var13_17) {
                if (var8_8 == null) throw var13_17;
                try {
                    var8_8.close();
                    throw var13_17;
                }
                catch (IOException var14_18) {
                    throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", var14_18, new Object[]{var2_2}));
                }
            }
        }
        try {
            var8_8.close();
            return;
        }
        catch (IOException var10_14) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", var10_14, new Object[]{var2_2}));
        }
lbl-1000:
        // 1 sources

        {
            var9_9 = (StreamLogScan)this.logFactory.openBackwardsScan(((LogCounter)var4_4).getValueAsLong(), var3_3);
lbl34:
            // 2 sources

            var8_8 = new ArrayInputStream(new byte[4096]);
            while ((var10_15 = var9_9.getNextRecord((ArrayInputStream)var8_8, var2_2, 0)) != null) {
                ++var6_6;
                if (var10_15.isCLR()) {
                    ++var5_5;
                    var10_15.skipLoggable();
                    var11_16 = var8_8.readLong();
                    var9_9.resetPosition(new LogCounter(var11_16));
                    continue;
                }
                if (!var10_15.requiresPrepareLocks() || (var7_7 = var10_15.getRePreparable()) == null) continue;
                var7_7.reclaimPrepareLocks(var1_1, var1_1.newLockingPolicy(1, 4, true));
            }
            if (var8_8 == null) return;
        }
        try {
            var8_8.close();
            return;
        }
        catch (IOException var9_10) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", var9_10, new Object[]{var2_2}));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void undo(RawTransaction var1_1, TransactionId var2_2, LogInstant var3_3, LogInstant var4_4) throws StandardException {
        block18: {
            block17: {
                var5_5 = 0;
                var6_6 = 0;
                var7_7 = 0;
                var9_8 = null;
                var10_9 = null;
                var11_10 = null;
                try {
                    block19: {
                        if (var4_4 != null) break block19;
                        var8_11 = (StreamLogScan)this.logFactory.openBackwardsScan(var3_3);
                        ** GOTO lbl42
                    }
                    if (var4_4.lessThan(var3_3)) {
                        if (var9_8 == null) break block17;
                    }
                    ** GOTO lbl-1000
                }
                catch (ClassNotFoundException var12_16) {
                    try {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", var12_16, new Object[0]));
                        catch (IOException var12_17) {
                            throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", var12_17, new Object[0]));
                        }
                        catch (StandardException var12_18) {
                            throw this.logFactory.markCorrupt(StandardException.newException("XSLA8.D", var12_18, new Object[]{var2_2, var10_9, var9_8}));
                        }
                    }
                    catch (Throwable var15_22) {
                        if (var9_8 != null) {
                            var9_8.releaseResource(var1_1);
                        }
                        if (var11_10 == null) throw var15_22;
                        try {
                            var11_10.close();
                            throw var15_22;
                        }
                        catch (IOException var16_23) {
                            throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", var16_23, new Object[]{var2_2}));
                        }
                    }
                }
                var9_8.releaseResource(var1_1);
            }
            if (var11_10 == null) return;
            try {
                var11_10.close();
                return;
            }
            catch (IOException var12_12) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", var12_12, new Object[]{var2_2}));
            }
lbl-1000:
            // 1 sources

            {
                var12_13 = ((LogCounter)var4_4).getValueAsLong();
                var8_11 = (StreamLogScan)this.logFactory.openBackwardsScan(var12_13, var3_3);
lbl42:
                // 2 sources

                var11_10 = new ArrayInputStream(new byte[4096]);
                while ((var12_14 = var8_11.getNextRecord((ArrayInputStream)var11_10, var2_2, 0)) != null) {
                    ++var7_7;
                    if (var12_14.isCLR()) {
                        ++var6_6;
                        var12_14.skipLoggable();
                        var13_19 = var11_10.readLong();
                        var8_11.resetPosition(new LogCounter(var13_19));
                        continue;
                    }
                    var10_9 = var12_14.getUndoable();
                    if (var10_9 == null) continue;
                    var13_20 = var11_10.readInt();
                    var14_21 = var11_10.getPosition();
                    var11_10.setLimit(var13_20);
                    var9_8 = var10_9.generateUndo(var1_1, (LimitObjectInput)var11_10);
                    ++var5_5;
                    if (var9_8 == null) continue;
                    var11_10.setLimit(var14_21, var13_20);
                    var1_1.logAndUndo((Compensation)var9_8, new LogCounter(var8_11.getInstant()), (LimitObjectInput)var11_10);
                    var9_8.releaseResource(var1_1);
                    var9_8 = null;
                }
                if (var9_8 == null) break block18;
            }
            var9_8.releaseResource(var1_1);
        }
        if (var11_10 == null) return;
        try {
            var11_10.close();
            return;
        }
        catch (IOException var12_15) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", var12_15, new Object[]{var2_2}));
        }
    }

    protected long redo(RawTransaction rawTransaction, TransactionFactory transactionFactory, StreamLogScan streamLogScan, long l, long l2) throws IOException, StandardException, ClassNotFoundException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TransactionId transactionId = null;
        long l3 = 0L;
        this.logIn.setData(this.logOutputBuffer.getByteArray());
        StreamLogScan streamLogScan2 = null;
        Loggable loggable = null;
        long l4 = 0L;
        try {
            long l5;
            LogRecord logRecord;
            while ((logRecord = streamLogScan.getNextRecord(this.logIn, null, 0)) != null) {
                ++n;
                l5 = 0L;
                l3 = streamLogScan.getInstant();
                l4 = streamLogScan.getLogRecordEnd();
                if (l != 0L && l3 < l && !logRecord.isFirst() && !logRecord.isComplete() && !logRecord.isPrepare()) continue;
                transactionId = logRecord.getTransactionId();
                if (!transactionFactory.findTransaction(transactionId, rawTransaction)) {
                    if (l != 0L && l3 < l && (logRecord.isPrepare() || logRecord.isComplete())) {
                        ++n5;
                        continue;
                    }
                    if (l2 == 0L && !logRecord.isFirst()) {
                        throw StandardException.newException("XSLAO.D", MessageService.getTextMessage("L012", transactionId));
                    }
                    ++n4;
                    rawTransaction.setTransactionId(logRecord.getLoggable(), transactionId);
                } else {
                    if (l2 == 0L && logRecord.isFirst()) {
                        throw StandardException.newException("XSLAO.D", MessageService.getTextMessage("L013", transactionId));
                    }
                    if (logRecord.isFirst()) {
                        ++n4;
                        continue;
                    }
                }
                loggable = logRecord.getLoggable();
                if (loggable.needsRedo(rawTransaction)) {
                    ++n2;
                    if (logRecord.isCLR()) {
                        ++n3;
                        if (l5 == 0L) {
                            l5 = this.logIn.readLong();
                        }
                        if (streamLogScan2 == null) {
                            streamLogScan2 = (StreamLogScan)this.logFactory.openForwardsScan(l5, (LogInstant)null);
                        } else {
                            streamLogScan2.resetPosition(new LogCounter(l5));
                        }
                        this.logIn.clearLimit();
                        LogRecord logRecord2 = streamLogScan2.getNextRecord(this.logIn, null, 0);
                        Undoable undoable = logRecord2.getUndoable();
                        ((Compensation)loggable).setUndoOp(undoable);
                    }
                    int n6 = this.logIn.readInt();
                    this.logIn.setLimit(n6);
                    loggable.doMe(rawTransaction, new LogCounter(l3), this.logIn);
                    loggable.releaseResource(rawTransaction);
                    loggable = null;
                }
                if (!logRecord.isComplete()) continue;
                ++n5;
                rawTransaction.commit();
            }
            l5 = streamLogScan.getLogRecordEnd();
            if (l5 != 0L && LogCounter.getLogFileNumber(l4) < LogCounter.getLogFileNumber(l5)) {
                l4 = l5;
            }
        }
        catch (StandardException standardException) {
            throw StandardException.newException("XSLA7.D", standardException, loggable);
        }
        finally {
            streamLogScan.close();
            streamLogScan = null;
            if (streamLogScan2 != null) {
                streamLogScan2.close();
                streamLogScan2 = null;
            }
            if (loggable != null) {
                loggable.releaseResource(rawTransaction);
            }
        }
        return l4;
    }

    protected Loggable readLogRecord(StreamLogScan streamLogScan, int n) throws IOException, StandardException, ClassNotFoundException {
        Loggable loggable = null;
        ArrayInputStream arrayInputStream = new ArrayInputStream(new byte[n]);
        LogRecord logRecord = streamLogScan.getNextRecord(arrayInputStream, null, 0);
        if (logRecord != null) {
            loggable = logRecord.getLoggable();
        }
        return loggable;
    }
}

