/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$AlternateConfig$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.History$;
import org.apache.spark.internal.config.Kryo$;
import org.apache.spark.internal.config.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

public final class SparkConf$
implements Logging,
scala.Serializable {
    public static SparkConf$ MODULE$;
    private final Map<String, SparkConf.DeprecatedConfig> deprecatedConfigs;
    private final Map<String, Seq<SparkConf.AlternateConfig>> org$apache$spark$SparkConf$$configsWithAlternatives;
    private final Map<String, Tuple2<String, SparkConf.AlternateConfig>> allAlternatives;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkConf$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<String, SparkConf.DeprecatedConfig> deprecatedConfigs() {
        return this.deprecatedConfigs;
    }

    public Map<String, Seq<SparkConf.AlternateConfig>> org$apache$spark$SparkConf$$configsWithAlternatives() {
        return this.org$apache$spark$SparkConf$$configsWithAlternatives;
    }

    private Map<String, Tuple2<String, SparkConf.AlternateConfig>> allAlternatives() {
        return this.allAlternatives;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExecutorStartupConf(String name) {
        if (name.startsWith("spark.auth")) {
            String string = name;
            String string2 = SecurityManager$.MODULE$.SPARK_AUTH_SECRET_CONF();
            if (string == null) {
                if (string2 != null) {
                    return true;
                }
            } else if (!string.equals(string2)) return true;
        }
        if (name.startsWith("spark.rpc")) return true;
        if (name.startsWith("spark.network")) return true;
        if (!this.isSparkPortConf(name)) return false;
        return true;
    }

    public boolean isSparkPortConf(String name) {
        return name.startsWith("spark.") && name.endsWith(".port") || name.startsWith("spark.port.");
    }

    public Option<String> getDeprecatedConfig(String key, java.util.Map<String, String> conf) {
        return this.org$apache$spark$SparkConf$$configsWithAlternatives().get((Object)key).flatMap((Function1 & Serializable & scala.Serializable)alts -> alts.collectFirst((PartialFunction)new scala.Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final java.util.Map conf$1;

            public final <A1 extends SparkConf.AlternateConfig, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (this.conf$1.containsKey(A1.key())) {
                    String value = (String)this.conf$1.get(A1.key());
                    if (A1.translation() != null) {
                        return (B1)A1.translation().apply((Object)value);
                    }
                    return (B1)value;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkConf.AlternateConfig x1) {
                SparkConf.AlternateConfig alternateConfig = x1;
                return this.conf$1.containsKey(alternateConfig.key());
            }
            {
                this.conf$1 = conf$1;
            }
        }));
    }

    public void logDeprecationWarning(String key) {
        Object object = new Object();
        try {
            this.deprecatedConfigs().get((Object)key).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("The configuration key '").append(key).append("' has been deprecated as of Spark ").append(cfg.version()).append(" and ").append("may be removed in the future. ").append(cfg.deprecationMessage()).toString());
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            this.allAlternatives().get((Object)key).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String newKey = (String)tuple2._1();
                    SparkConf.AlternateConfig cfg = (SparkConf.AlternateConfig)tuple2._2();
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(126).append("The configuration key '").append(key).append("' has been deprecated as of Spark ").append(cfg.version()).append(" and ").append("may be removed in the future. Please use the new key '").append(newKey).append("' instead.").toString());
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkConf$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        Seq configs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SparkConf.DeprecatedConfig[]{new SparkConf.DeprecatedConfig("spark.cache.class", "0.8", "The spark.cache.class property is no longer being used! Specify storage levels using the RDD.persist() method instead."), new SparkConf.DeprecatedConfig("spark.yarn.user.classpath.first", "1.3", "Please use spark.{driver,executor}.userClassPathFirst instead."), new SparkConf.DeprecatedConfig("spark.kryoserializer.buffer.mb", "1.4", "Please use spark.kryoserializer.buffer instead. The default value for spark.kryoserializer.buffer.mb was previously specified as '0.064'. Fractional values are no longer accepted. To specify the equivalent now, one may use '64k'."), new SparkConf.DeprecatedConfig("spark.rpc", "2.0", "Not used anymore."), new SparkConf.DeprecatedConfig("spark.scheduler.executorTaskBlacklistTime", "2.1.0", "Please use the new excludedOnFailure options, spark.excludeOnFailure.*"), new SparkConf.DeprecatedConfig("spark.yarn.am.port", "2.0.0", "Not used anymore"), new SparkConf.DeprecatedConfig("spark.executor.port", "2.0.0", "Not used anymore"), new SparkConf.DeprecatedConfig("spark.rpc.numRetries", "2.2.0", "Not used anymore"), new SparkConf.DeprecatedConfig("spark.rpc.retry.wait", "2.2.0", "Not used anymore"), new SparkConf.DeprecatedConfig("spark.shuffle.service.index.cache.entries", "2.3.0", "Not used anymore. Please use spark.shuffle.service.index.cache.size"), new SparkConf.DeprecatedConfig("spark.yarn.credentials.file.retention.count", "2.4.0", "Not used anymore."), new SparkConf.DeprecatedConfig("spark.yarn.credentials.file.retention.days", "2.4.0", "Not used anymore."), new SparkConf.DeprecatedConfig("spark.yarn.services", "3.0.0", "Feature no longer available."), new SparkConf.DeprecatedConfig("spark.executor.plugins", "3.0.0", "Feature replaced with new plugin API. See Monitoring documentation."), new SparkConf.DeprecatedConfig("spark.blacklist.enabled", "3.1.0", "Please use spark.excludeOnFailure.enabled"), new SparkConf.DeprecatedConfig("spark.blacklist.task.maxTaskAttemptsPerExecutor", "3.1.0", "Please use spark.excludeOnFailure.task.maxTaskAttemptsPerExecutor"), new SparkConf.DeprecatedConfig("spark.blacklist.task.maxTaskAttemptsPerNode", "3.1.0", "Please use spark.excludeOnFailure.task.maxTaskAttemptsPerNode"), new SparkConf.DeprecatedConfig("spark.blacklist.application.maxFailedTasksPerExecutor", "3.1.0", "Please use spark.excludeOnFailure.application.maxFailedTasksPerExecutor"), new SparkConf.DeprecatedConfig("spark.blacklist.stage.maxFailedTasksPerExecutor", "3.1.0", "Please use spark.excludeOnFailure.stage.maxFailedTasksPerExecutor"), new SparkConf.DeprecatedConfig("spark.blacklist.application.maxFailedExecutorsPerNode", "3.1.0", "Please use spark.excludeOnFailure.application.maxFailedExecutorsPerNode"), new SparkConf.DeprecatedConfig("spark.blacklist.stage.maxFailedExecutorsPerNode", "3.1.0", "Please use spark.excludeOnFailure.stage.maxFailedExecutorsPerNode"), new SparkConf.DeprecatedConfig("spark.blacklist.timeout", "3.1.0", "Please use spark.excludeOnFailure.timeout"), new SparkConf.DeprecatedConfig("spark.blacklist.application.fetchFailure.enabled", "3.1.0", "Please use spark.excludeOnFailure.application.fetchFailure.enabled"), new SparkConf.DeprecatedConfig("spark.scheduler.blacklist.unschedulableTaskSetTimeout", "3.1.0", "Please use spark.scheduler.excludeOnFailure.unschedulableTaskSetTimeout"), new SparkConf.DeprecatedConfig("spark.blacklist.killBlacklistedExecutors", "3.1.0", "Please use spark.excludeOnFailure.killExcludedExecutors"), new SparkConf.DeprecatedConfig("spark.yarn.blacklist.executor.launch.blacklisting.enabled", "3.1.0", "Please use spark.yarn.executor.launch.excludeOnFailure.enabled"), new SparkConf.DeprecatedConfig("spark.network.remoteReadNioBufferConversion", "3.5.2", "Please open a JIRA ticket to report it if you need to use this configuration.")}));
        this.deprecatedConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)configs.map((Function1 & Serializable & scala.Serializable)cfg -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cfg.key()), cfg), Seq$.MODULE$.canBuildFrom()));
        this.org$apache$spark$SparkConf$$configsWithAlternatives = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.files.userClassPathFirst", "1.3", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)History$.MODULE$.UPDATE_INTERVAL_S().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.history.fs.update.interval.seconds", "1.4", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.history.fs.updateInterval", "1.3", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.history.updateInterval", "1.3", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)History$.MODULE$.CLEANER_INTERVAL_S().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.history.fs.cleaner.interval.seconds", "1.4", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)History$.MODULE$.MAX_LOG_AGE_S().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.history.fs.cleaner.maxAge.seconds", "1.4", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.am.waitTime"), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.applicationMaster.waitTries", "1.3", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)s -> new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(s)).toLong() * 10L).append("s").toString()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.REDUCER_MAX_SIZE_IN_FLIGHT().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.reducer.maxMbInFlight", "1.4", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Kryo$.MODULE$.KRYO_SERIALIZER_BUFFER_SIZE().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.kryoserializer.buffer.mb", "1.4", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)s -> new StringBuilder(1).append((int)(new StringOps(Predef$.MODULE$.augmentString(s)).toDouble() * (double)1000)).append("k").toString()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Kryo$.MODULE$.KRYO_SERIALIZER_MAX_BUFFER_SIZE().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.kryoserializer.buffer.max.mb", "1.4", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SHUFFLE_FILE_BUFFER_SIZE().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.shuffle.file.buffer.kb", "1.4", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.EXECUTOR_LOGS_ROLLING_MAX_SIZE().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.executor.logs.rolling.size.maxBytes", "1.4", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.IO_COMPRESSION_SNAPPY_BLOCKSIZE().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.io.compression.snappy.block.size", "1.4", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.IO_COMPRESSION_LZ4_BLOCKSIZE().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.io.compression.lz4.block.size", "1.4", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.streaming.fileStream.minRememberDuration"), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.streaming.minRememberDuration", "1.5", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.max.executor.failures"), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.max.worker.failures", "1.5", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.MEMORY_OFFHEAP_ENABLED().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.unsafe.offHeap", "1.6", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.jars"), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.jar", "2.0", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.MAX_REMOTE_BLOCK_SIZE_FETCH_TO_MEM().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.reducer.maxReqSizeShuffleToMem", "2.3", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.maxRemoteBlockSizeFetchToMem", "3.0", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.LISTENER_BUS_EVENT_QUEUE_CAPACITY().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.scheduler.listenerbus.eventqueue.size", "2.3", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.DRIVER_MEMORY_OVERHEAD().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.driver.memoryOverhead", "2.3", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.executor.memoryOverhead", "2.3", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.KEYTAB().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.keytab", "3.0", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.PRINCIPAL().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.principal", "3.0", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.KERBEROS_RELOGIN_PERIOD().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.kerberos.relogin.period", "3.0", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.KERBEROS_FILESYSTEMS_TO_ACCESS().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.access.namenodes", "2.2", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.access.hadoopFileSystems", "3.0", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.kafka.consumer.cache.capacity"), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.sql.kafkaConsumerCache.capacity", "3.0", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.MAX_EXECUTOR_FAILURES().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.max.executor.failures", "3.5", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.EXECUTOR_ATTEMPT_FAILURE_VALIDITY_INTERVAL_MS().key()), (Object)new .colon.colon((Object)new SparkConf.AlternateConfig("spark.yarn.executor.failuresValidityInterval", "3.5", SparkConf$AlternateConfig$.MODULE$.apply$default$3()), (List)Nil$.MODULE$))}));
        this.allAlternatives = ((TraversableOnce)this.org$apache$spark$SparkConf$$configsWithAlternatives().keys().flatMap((Function1 & Serializable & scala.Serializable)key -> (Seq)((TraversableLike)MODULE$.org$apache$spark$SparkConf$$configsWithAlternatives().apply(key)).map((Function1 & Serializable & scala.Serializable)cfg -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cfg.key()), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), cfg)), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

