/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.activity.DSSUsageStatsInternalDB;
import com.dataiku.dip.activity.HierarchicalMultimap;
import com.dataiku.dip.activity.IDSSUsageStatsInternalDB;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.ActivityDoneEvent;
import com.dataiku.dip.server.notifications.backend.JobDoneEvent;
import com.dataiku.dip.server.notifications.backend.JobStatusUpdatedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionTasksService {
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private DSSUsageStatsInternalDB dbService;
    HierarchicalMultimap<IDSSUsageStatsInternalDB.ConnectionTask> recipeRunningTasks = new HierarchicalMultimap();
    List<IDSSUsageStatsInternalDB.ConnectionTask> internalRunningSQL = new ArrayList<IDSSUsageStatsInternalDB.ConnectionTask>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.monitoring.connectiontasks");

    private List<IDSSUsageStatsInternalDB.ConnectionTask> buildConnectionTasksForActivity(String jobProjectKey, String jobId, String activityId, String initiator, SerializedJobActivityStatus sjas) {
        IDSSUsageStatsInternalDB.ConnectionTask ct;
        ArrayList<IDSSUsageStatsInternalDB.ConnectionTask> ret = new ArrayList<IDSSUsageStatsInternalDB.ConnectionTask>();
        for (HiveRun hiveRun : sjas.runningThings.hive) {
            ct = new IDSSUsageStatsInternalDB.ConnectionTask();
            ct.startTime = hiveRun.startedOn;
            ct.endTime = hiveRun.doneOn;
            ct.connectionId = "HADOOP";
            ct.initiator = initiator;
            ct.taskType = ConnectionTaskType.HIVE_FROM_RECIPE;
            ct.projectKey = jobProjectKey;
            ct.taskData.addProperty("jobId", jobId);
            ct.taskData.addProperty("activityId", activityId);
            ret.add(ct);
        }
        for (SQLQueryRun sQLQueryRun : sjas.runningThings.sql) {
            ct = new IDSSUsageStatsInternalDB.ConnectionTask();
            ct.startTime = sQLQueryRun.startedOn;
            ct.endTime = sQLQueryRun.doneOn;
            ct.connectionId = sQLQueryRun.connection;
            ct.initiator = initiator;
            ct.taskType = ConnectionTaskType.SQL_FROM_RECIPE;
            ct.projectKey = jobProjectKey;
            ct.taskData.addProperty("jobId", jobId);
            ct.taskData.addProperty("activityId", activityId);
            ret.add(ct);
        }
        return ret;
    }

    private void setMemoryForActivity(String jobProjectKey, String jobId, String activityId, String initiator, SerializedJobActivityStatus sjas) {
        assert (Thread.holdsLock(this));
        this.clearMemoryForActivity(jobProjectKey, jobId, activityId);
        for (IDSSUsageStatsInternalDB.ConnectionTask ct : this.buildConnectionTasksForActivity(jobProjectKey, jobId, activityId, initiator, sjas)) {
            this.recipeRunningTasks.putAt(ct, jobProjectKey, jobId, activityId);
        }
    }

    private void clearMemoryForActivity(String jobProjectKey, String jobId, String activityId) {
        assert (Thread.holdsLock(this));
        this.recipeRunningTasks.clearPrefix(jobProjectKey, jobId, activityId);
    }

    private void clearMemoryForJob(String jobProjectKey, String jobId) {
        assert (Thread.holdsLock(this));
        this.recipeRunningTasks.clearPrefix(jobProjectKey, jobId);
    }

    public List<IDSSUsageStatsInternalDB.ConnectionTask> listAllCurrentlyRunning() {
        ArrayList<IDSSUsageStatsInternalDB.ConnectionTask> ret = new ArrayList<IDSSUsageStatsInternalDB.ConnectionTask>();
        ret.addAll(this.recipeRunningTasks.values());
        ret.addAll(this.internalRunningSQL);
        return ret;
    }

    public ConnectionTasksHistory getHistory(String connectionId, long since) throws SQLException {
        ConnectionTasksHistory ret = new ConnectionTasksHistory();
        ret.lastTasks = this.dbService.getLastConnectionTasks(connectionId, 200);
        ret.perProject = this.dbService.getConnectionTasksPerProject(connectionId, since);
        ret.perUser = this.dbService.getConnectionTasksPerUser(connectionId, since);
        ret.summary = this.dbService.getConnectionTasksSummary(connectionId, since);
        return ret;
    }

    public ACRunningSQLQuery acquireSQLQueryFromNobetook(String login, String connection, String projectKey, String notebookId) {
        ACRunningSQLQuery q = new ACRunningSQLQuery(ConnectionTaskType.SQL_FROM_NOTEBOOK, login, connection);
        q.connTask.projectKey = projectKey;
        q.connTask.taskData.addProperty("notebookId", notebookId);
        return q;
    }

    private void dumpRunning() {
        for (IDSSUsageStatsInternalDB.ConnectionTask ct : this.listAllCurrentlyRunning()) {
            logger.trace(() -> "Currently running " + JSON.log((Object)ct));
        }
    }

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init ConnectionTasksService");
        this.pubSub.subscribe("job-status-updated", (DSSEventListener)new DSSEventListener<JobStatusUpdatedEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(JobStatusUpdatedEvent evt) {
                logger.trace((Object)"Process status update of job");
                ConnectionTasksService connectionTasksService = ConnectionTasksService.this;
                synchronized (connectionTasksService) {
                    ConnectionTasksService.this.clearMemoryForJob(evt.jobDef.projectKey, evt.jobDef.id);
                    for (SerializedJobActivityStatus sjas : evt.status.activities.values()) {
                        if (sjas.state != ActivityState.RUNNING) continue;
                        ConnectionTasksService.this.setMemoryForActivity(evt.jobDef.projectKey, evt.jobDef.id, sjas.activityId, evt.jobDef.initiator, sjas);
                    }
                }
                if (logger.isTraceEnabled()) {
                    ConnectionTasksService.this.dumpRunning();
                }
            }
        });
        this.pubSub.subscribe("job-activity-done", (DSSEventListener)new DSSEventListener<ActivityDoneEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(ActivityDoneEvent evt) {
                logger.info((Object)("Process activity done event for " + evt.jobDef.id));
                ConnectionTasksService connectionTasksService = ConnectionTasksService.this;
                synchronized (connectionTasksService) {
                    ConnectionTasksService.this.clearMemoryForActivity(evt.jobDef.projectKey, evt.jobDef.id, evt.status.activityId);
                }
                for (IDSSUsageStatsInternalDB.ConnectionTask ct : ConnectionTasksService.this.buildConnectionTasksForActivity(evt.jobDef.projectKey, evt.jobDef.id, evt.status.activityId, evt.jobDef.initiator, evt.status)) {
                    try {
                        ConnectionTasksService.this.dbService.storeConnectionTask(ct);
                    }
                    catch (SQLException e) {
                        logger.info((Object)"Could not store connection task", (Throwable)e);
                    }
                }
                ConnectionTasksService.this.dumpRunning();
            }
        });
        this.pubSub.subscribe("job-done", (DSSEventListener)new DSSEventListener<JobDoneEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(JobDoneEvent evt) {
                logger.info((Object)("Removing all traces of job " + JSON.log((Object)evt.jobDef)));
                ConnectionTasksService connectionTasksService = ConnectionTasksService.this;
                synchronized (connectionTasksService) {
                    ConnectionTasksService.this.clearMemoryForJob(evt.jobDef.projectKey, evt.jobDef.id);
                }
                ConnectionTasksService.this.dumpRunning();
            }
        });
        logger.debug((Object)"Done init ConnectionTasksService");
    }

    public static class HiveRun {
        public long startedOn;
        public long doneOn;
        public Set<String> applicationIds = new HashSet<String>();
    }

    public static enum ConnectionTaskType {
        SQL_FROM_RECIPE,
        SQL_FROM_NOTEBOOK,
        SQL_FROM_API,
        HIVE_FROM_RECIPE,
        HIVE_FROM_NOTEBOOK,
        MR_FROM_RECIPE;

    }

    public static class SQLQueryRun {
        public String connection;
        public Long startedOn;
        public Long doneOn;
    }

    public static class ConnectionTasksHistory {
        public List<PerTypeDataPoint> summary = new ArrayList<PerTypeDataPoint>();
        public List<IDSSUsageStatsInternalDB.ConnectionTask> lastTasks = new ArrayList<IDSSUsageStatsInternalDB.ConnectionTask>();
        public List<PerProjectDataPoint> perProject = new ArrayList<PerProjectDataPoint>();
        public List<PerUserDataPoint> perUser = new ArrayList<PerUserDataPoint>();
    }

    public class ACRunningSQLQuery
    implements AutoCloseable {
        IDSSUsageStatsInternalDB.ConnectionTask connTask = new IDSSUsageStatsInternalDB.ConnectionTask();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ACRunningSQLQuery(ConnectionTaskType type, String login, String connection) {
            this.connTask.connectionId = connection;
            this.connTask.startTime = System.currentTimeMillis();
            this.connTask.initiator = login;
            this.connTask.taskType = type;
            ConnectionTasksService connectionTasksService = ConnectionTasksService.this;
            synchronized (connectionTasksService) {
                ConnectionTasksService.this.internalRunningSQL.add(this.connTask);
            }
            logger.info((Object)"Start SQL Query");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws SQLException {
            this.connTask.endTime = System.currentTimeMillis();
            ConnectionTasksService connectionTasksService = ConnectionTasksService.this;
            synchronized (connectionTasksService) {
                ConnectionTasksService.this.internalRunningSQL.remove(this.connTask);
            }
            try {
                ConnectionTasksService.this.dbService.storeConnectionTask(this.connTask);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to store connection task", (Throwable)e);
            }
            logger.info((Object)"Done SQL Query");
        }
    }

    public static class PerUserDataPoint {
        public String user;
        public List<PerTypeDataPoint> types = new ArrayList<PerTypeDataPoint>();
    }

    public static class PerProjectDataPoint {
        public String project;
        public List<PerTypeDataPoint> types = new ArrayList<PerTypeDataPoint>();
    }

    public static class PerTypeDataPoint {
        public ConnectionTaskType type;
        public int nbTasks;
        public long totalElapsedTime;
    }
}

