/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agentreview;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.j2ts.annotations.UIData;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@UIModel
@PartOfPublicAPI
public enum AgentReviewStatus {
    EMPTY(0),
    SKIPPED(1),
    PASS(2),
    CONFLICT(3),
    FAIL(4);

    @UIData
    public static final Map<AgentReviewStatus, Integer> SEVERITY;
    private final int severity;

    private AgentReviewStatus(int severity) {
        this.severity = severity;
    }

    public int getSeverity() {
        return this.severity;
    }

    @Nonnull
    public static AgentReviewStatus aggregateLikes(List<Boolean> likes) {
        AgentReviewStatus ret = EMPTY;
        boolean anyLike = likes.stream().anyMatch(Boolean.TRUE::equals);
        boolean anyDislike = likes.stream().anyMatch(Boolean.FALSE::equals);
        if (anyLike || anyDislike) {
            ret = anyLike & !anyDislike ? PASS : (!anyLike & anyDislike ? FAIL : CONFLICT);
        }
        return ret;
    }

    static {
        SEVERITY = new HashMap<AgentReviewStatus, Integer>();
        for (AgentReviewStatus status : AgentReviewStatus.values()) {
            SEVERITY.put(status, status.severity);
        }
    }
}

