/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agentreview;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import javax.annotation.Nullable;

@UIModel
@PartOfPublicAPI
public class AgentReviewTrait {
    @UINullable
    public String id;
    public String name;
    public String description;
    @Nullable
    public String llmId;
    public String criteria;
    public boolean enabled = true;
    public boolean needsReference = true;
    public boolean needsExpectations = false;

    public static AgentReviewTrait reference(@Nullable String llmId) {
        AgentReviewTrait trait = new AgentReviewTrait();
        trait.id = SecretKeyGenerator.generate((int)10);
        trait.name = "Reference";
        trait.description = "Compare the correctness of the answer to the reference, given the query";
        trait.needsReference = true;
        trait.needsExpectations = false;
        trait.llmId = llmId;
        trait.criteria = "The Agent's Answer conveys the same meaning as the Reference Answer.\nOnly semantic equivalence or near-equivalence is acceptable.\nAny contradiction, significant omission, or added meaning results in outcome = false.\nDo not judge correctness or quality beyond this comparison.\n";
        return trait;
    }

    public static AgentReviewTrait expectations(@Nullable String llmId) {
        AgentReviewTrait trait = new AgentReviewTrait();
        trait.id = SecretKeyGenerator.generate((int)10);
        trait.name = "Expectations";
        trait.description = "The answer matches the expectations";
        trait.needsReference = false;
        trait.needsExpectations = true;
        trait.llmId = llmId;
        trait.criteria = "The Agent's execution (Answer and Trajectory combined) satisfies the defined Expectations.\nEach expected element must be present in the answer, either explicitly or through clear paraphrase.\nNo expected element may be missing.\nAdditional information is acceptable only if it does not alter or go beyond the Expectations.\nDo not judge factual correctness or answer quality beyond checking alignment with the Expectations.\n";
        return trait;
    }
}

