/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.aigenerations.SqlAssistantConversation;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SqlAssistantConversationsDAO;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLAssistantService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private SqlAssistantConversationsDAO conversationsDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsService connectionsService;
    private static final DKULogger logger = DKULogger.getLogger(SQLAssistantService.class);

    public FutureResponse<SQLAssistantAnswer> computeAnswer(AuthCtx owner, String userMessage, @Nullable String currentSqlQuery, @Nullable SQLErrorContext currentSqlErrorContext, AbstractSQLConnection connection, @Nullable RequestOrigin requestOrigin, @Nullable String projectKey, @Nullable String notebookId, @Nullable String cellId, @Nullable String conversationId, List<SerializedDataset> datasets, List<SqlAssistantConversation.SelectedTable> selectedTables, SqlAssistantConversation.TableListingMode tableListingMode) throws Exception {
        SQLAssistantAnswerFutureThread futureThread = new SQLAssistantAnswerFutureThread(owner, userMessage, currentSqlQuery, currentSqlErrorContext, connection, requestOrigin, projectKey, notebookId, cellId, conversationId, datasets, selectedTables, tableListingMode);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<SQLAssistantAnswer>>(){});
    }

    public void checkUserCanUseSQLAssistant() {
        LicenseStatusService.LicensingStatus licensingStatus = this.licenseStatusService.getLicensingStatus();
        if (licensingStatus == null || licensingStatus.community) {
            throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
        }
        GeneralSettingsDAO.AIDrivenAnalyticsSettings aiDrivenAnalyticsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().aiDrivenAnalyticsSettings;
        if (!aiDrivenAnalyticsSettings.isAssistantEnabled(GeneralSettingsDAO.AiAssistant.SQL_ASSISTANT)) {
            throw new IllegalStateException("SQL Assistant is not enabled");
        }
    }

    public SqlAssistantConversation.QueryConversation getConversation(String projectKey, String notebookId, String cellId, AuthCtx authCtx) throws DKUSecurityException {
        String userId = authCtx.getAssociatedDSSUserMand();
        return this.conversationsDAO.getConversation(projectKey, notebookId, cellId, userId);
    }

    public void deleteConversation(String projectKey, String notebookId, String cellId, AuthCtx authCtx) throws DKUSecurityException {
        String userId = authCtx.getAssociatedDSSUserMand();
        this.conversationsDAO.deleteUserConversation(projectKey, notebookId, cellId, userId);
    }

    public void deleteCellConversations(String projectKey, String notebookId, String cellId) {
        this.conversationsDAO.deleteCellConversations(projectKey, notebookId, cellId);
    }

    public void deleteNotebookConversations(String projectKey, String notebookId) {
        this.conversationsDAO.deleteNotebookConversations(projectKey, notebookId);
    }

    public List<SqlAssistantConversation.Message> loadConversationHistory(AuthCtx authCtx, String projectKey, String notebookId, String cellId) {
        try {
            SqlAssistantConversation.QueryConversation conversation = this.getConversation(projectKey, notebookId, cellId, authCtx);
            if (conversation.messages.isEmpty()) {
                return new ArrayList<SqlAssistantConversation.Message>();
            }
            return new ArrayList<SqlAssistantConversation.Message>(conversation.messages);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to load persisted conversation history, starting fresh", (Throwable)e);
            return new ArrayList<SqlAssistantConversation.Message>();
        }
    }

    public List<TableContext> buildTablesContext(AuthCtx authCtx, String projectKey, AbstractSQLConnection sqlConnection, SQLDialect dialect, List<SerializedDataset> datasets, List<SqlAssistantConversation.SelectedTable> selectedTables) {
        ArrayList<TableContext> tablesContext = new ArrayList<TableContext>();
        HashMap<String, SerializedDataset> datasetsByTableKey = new HashMap<String, SerializedDataset>();
        for (SerializedDataset sds : datasets) {
            DatasetHandler.DatasetParams datasetParams = sds.getParams();
            if (!(datasetParams instanceof AbstractSQLDatasetHandler.AbstractSQLConfig)) continue;
            AbstractSQLDatasetHandler.AbstractSQLConfig sqlConfig = (AbstractSQLDatasetHandler.AbstractSQLConfig)datasetParams;
            AbstractSQLDatasetHandler.AbstractSQLConfig config = sqlConfig.getResolved(projectKey);
            if (config.connection == null || !config.connection.equals(sqlConnection.name) || StringUtils.isBlank((String)config.table)) continue;
            String key = this.buildQualifiedTableName(config.catalog, config.schema, config.table);
            datasetsByTableKey.put(key, sds);
        }
        ArrayList<SqlAssistantConversation.SelectedTable> externalTables = new ArrayList<SqlAssistantConversation.SelectedTable>();
        HashMap<String, SqlAssistantConversation.SelectedTable> externalTablesByFieldKey = new HashMap<String, SqlAssistantConversation.SelectedTable>();
        for (SqlAssistantConversation.SelectedTable selection : selectedTables) {
            String tableKey = this.buildQualifiedTableName(selection.catalog, selection.schema, selection.table);
            SerializedDataset projectDataset = (SerializedDataset)datasetsByTableKey.get(tableKey);
            if (projectDataset != null) {
                try {
                    Dataset dataset = Dataset.fromSerialized(projectDataset);
                    tablesContext.add(this.buildTableContextFromDataset(dataset, projectKey, dialect));
                }
                catch (IllegalArgumentException e) {
                    logger.warn((Object)("Failed to get schema for dataset " + selection.table + ": " + e.getMessage()));
                    tablesContext.add(this.buildEmptyTableContext(selection.catalog, selection.schema, selection.table));
                }
                continue;
            }
            externalTables.add(selection);
            String fieldKey = this.buildQualifiedTableName(selection.catalog, selection.schema, selection.table);
            externalTablesByFieldKey.put(fieldKey, selection);
        }
        if (!externalTables.isEmpty()) {
            try {
                ConnectionsService.FieldsRequest fr = new ConnectionsService.FieldsRequest();
                fr.tables = externalTables.stream().map(s -> new SQLUtils.SQLTable(s.catalog, s.schema, s.table)).toList();
                List<SQLUtils.SQLField> allFields = this.connectionsService.listSQLFields(sqlConnection, fr, authCtx, projectKey);
                Map<String, List<SQLUtils.SQLField>> fieldsByTable = allFields.stream().collect(Collectors.groupingBy(f -> this.buildQualifiedTableName(f.catalog, f.schema, f.table)));
                for (Map.Entry<String, List<SQLUtils.SQLField>> entry : fieldsByTable.entrySet()) {
                    SqlAssistantConversation.SelectedTable original = (SqlAssistantConversation.SelectedTable)externalTablesByFieldKey.remove(entry.getKey());
                    if (original == null || entry.getValue().isEmpty()) continue;
                    tablesContext.add(this.buildTableContextFromFields(original.catalog, original.schema, original.table, entry.getValue()));
                }
                for (SqlAssistantConversation.SelectedTable unresolved : externalTablesByFieldKey.values()) {
                    logger.warn((Object)("SQL Assistant failed to fetch schema for table: " + unresolved.table + " (connection: " + sqlConnection.name + ")"));
                    tablesContext.add(this.buildEmptyTableContext(unresolved.catalog, unresolved.schema, unresolved.table));
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to fetch schemas for external tables", (Throwable)e);
                for (SqlAssistantConversation.SelectedTable table : externalTables) {
                    tablesContext.add(this.buildEmptyTableContext(table.catalog, table.schema, table.table));
                }
            }
        }
        return tablesContext;
    }

    private TableContext buildTableContextFromFields(String catalog, String schema, String table, List<SQLUtils.SQLField> fields) {
        TableContext ctx = new TableContext();
        ctx.qualifiedName = this.buildQualifiedTableName(catalog, schema, table);
        ctx.catalog = catalog;
        ctx.schema = schema;
        ctx.columns = fields.stream().map(f -> new ColumnInfo(f.name, f.type != null ? f.type : "VARCHAR")).toList();
        return ctx;
    }

    private TableContext buildEmptyTableContext(String catalog, String schema, String table) {
        TableContext ctx = new TableContext();
        ctx.qualifiedName = this.buildQualifiedTableName(catalog, schema, table);
        ctx.catalog = catalog;
        ctx.schema = schema;
        ctx.columns = new ArrayList<ColumnInfo>();
        return ctx;
    }

    private TableContext buildTableContextFromDataset(Dataset dataset, String projectKey, SQLDialect dialect) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(projectKey);
        TableContext ctx = new TableContext();
        ctx.qualifiedName = this.buildQualifiedTableName(config.catalog, config.schema, config.table);
        ctx.catalog = config.catalog;
        ctx.schema = config.schema;
        ctx.columns = dataset.getSchema().getColumns().stream().map(col -> new ColumnInfo(col.getName(), dialect.getSQLType((SchemaColumn)col, (Dataset)dataset).sqlDecl)).toList();
        return ctx;
    }

    private String buildQualifiedTableName(String catalog, String schema, String table) {
        StringBuilder sb = new StringBuilder();
        if (catalog != null && !catalog.isEmpty()) {
            sb.append(catalog).append(".");
        }
        if (schema != null && !schema.isEmpty()) {
            sb.append(schema).append(".");
        }
        sb.append(table);
        return sb.toString();
    }

    private class SQLAssistantAnswerFutureThread
    extends SimpleFutureThread<SQLAssistantAnswer> {
        private final String userMessage;
        @Nullable
        private final String currentSqlQuery;
        @Nullable
        private final SQLErrorContext currentSqlErrorContext;
        @Nullable
        private final RequestOrigin requestOrigin;
        private final AuthCtx authCtx;
        private final AbstractSQLConnection connection;
        @Nullable
        private final String projectKey;
        @Nullable
        private final String notebookId;
        @Nullable
        private final String cellId;
        private final String conversationId;
        private final List<SerializedDataset> datasets;
        private final List<SqlAssistantConversation.SelectedTable> selectedTables;
        private final SQLDialect dialect;
        private final SqlAssistantConversation.TableListingMode tableListingMode;

        SQLAssistantAnswerFutureThread(AuthCtx owner, @Nullable String userMessage, @Nullable String currentSqlQuery, SQLErrorContext currentSqlErrorContext, @Nullable AbstractSQLConnection connection, @Nullable RequestOrigin requestOrigin, @Nullable String projectKey, @Nullable String notebookId, @Nullable String cellId, String conversationId, List<SerializedDataset> datasets, List<SqlAssistantConversation.SelectedTable> selectedTables, SqlAssistantConversation.TableListingMode tableListingMode) throws Exception {
            super(owner);
            this.userMessage = userMessage;
            this.currentSqlQuery = currentSqlQuery;
            this.currentSqlErrorContext = currentSqlErrorContext;
            this.authCtx = owner;
            this.connection = connection;
            this.dialect = connection.getDialect();
            this.requestOrigin = requestOrigin;
            this.projectKey = projectKey;
            this.notebookId = notebookId;
            this.cellId = cellId;
            this.conversationId = StringUtils.isNotBlank((String)conversationId) ? conversationId : SecretKeyGenerator.generateSmall();
            this.datasets = datasets;
            this.selectedTables = selectedTables;
            this.tableListingMode = tableListingMode;
        }

        private boolean isPersistenceEnabled() {
            return StringUtils.isNotBlank((String)this.projectKey) && StringUtils.isNotBlank((String)this.notebookId) && StringUtils.isNotBlank((String)this.cellId);
        }

        private void checkNotebookAndCellExist() throws IOException {
            try (Transaction ignored = SQLAssistantService.this.transactionService.beginRead();){
                SQLNotebook notebook = (SQLNotebook)SQLAssistantService.this.sqlNotebooksDAO.getMandatoryUnsafe(this.projectKey, this.notebookId);
                boolean cellExists = notebook.cells.stream().anyMatch(cell -> cell.id.equals(this.cellId));
                if (!cellExists) {
                    throw new NotFoundException("SQL notebook cell does not exist: " + this.projectKey + "." + this.notebookId + "." + this.cellId);
                }
            }
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"sql_assistant_answer", (String)"SQL Assistant");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SQLAssistantAnswer compute() {
            NDC.push((String)"sql-assistant-answer");
            try {
                if (this.isPersistenceEnabled()) {
                    try {
                        this.checkNotebookAndCellExist();
                    }
                    catch (IOException e) {
                        SQLAssistantAnswer sQLAssistantAnswer = this.handleFailedRequest(e, e.getMessage());
                        NDC.pop();
                        return sQLAssistantAnswer;
                    }
                }
                List<Object> tablesContext = this.selectedTables != null && !this.selectedTables.isEmpty() ? SQLAssistantService.this.buildTablesContext(this.authCtx, this.projectKey, this.connection, this.dialect, this.datasets, this.selectedTables) : new ArrayList();
                if (this.isPersistenceEnabled()) {
                    this.persistNewUserMessage(this.selectedTables);
                }
                List<SqlAssistantConversation.Message> conversationHistory = SQLAssistantService.this.loadConversationHistory(this.authCtx, this.projectKey, this.notebookId, this.cellId);
                AIServerSQLAssistantAnswerRequest answerRequest = this.createAIServerSQLAssistantAnswerRequest(tablesContext, conversationHistory);
                SQLAssistantAnswer response = this.requestAIServerAndProcessResponse(answerRequest);
                if (this.isPersistenceEnabled()) {
                    try {
                        this.checkNotebookAndCellExist();
                    }
                    catch (IOException e) {
                        SQLAssistantAnswer sQLAssistantAnswer = this.handleFailedRequest(e, e.getMessage());
                        NDC.pop();
                        return sQLAssistantAnswer;
                    }
                    this.persistNewResponse(response);
                }
                SQLAssistantAnswer sQLAssistantAnswer = response;
                return sQLAssistantAnswer;
            }
            finally {
                NDC.pop();
            }
        }

        private void persistNewUserMessage(List<SqlAssistantConversation.SelectedTable> selectedTables) {
            try {
                String userId = this.authCtx.getAssociatedDSSUserMand();
                SqlAssistantConversation.QueryConversation conversation = SQLAssistantService.this.conversationsDAO.getConversation(this.projectKey, this.notebookId, this.cellId, userId);
                if (!this.conversationId.equals(conversation.conversationId)) {
                    conversation = new SqlAssistantConversation.QueryConversation();
                    conversation.conversationId = this.conversationId;
                }
                SqlAssistantConversation.Message userMsg = new SqlAssistantConversation.Message(SqlAssistantConversation.MessageRole.USER, this.userMessage);
                conversation.messages.add(userMsg);
                conversation.selectedTables = selectedTables != null ? new ArrayList<SqlAssistantConversation.SelectedTable>(selectedTables) : new ArrayList();
                conversation.tableListingMode = this.tableListingMode;
                SQLAssistantService.this.conversationsDAO.saveConversation(this.projectKey, this.notebookId, this.cellId, userId, conversation);
                logger.debug((Object)("Persisted SQL Assistant user message for conversation " + conversation.conversationId));
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to persist SQL Assistant user message", (Throwable)e);
            }
        }

        private void persistNewResponse(SQLAssistantAnswer response) {
            try {
                String userId = this.authCtx.getAssociatedDSSUserMand();
                SqlAssistantConversation.QueryConversation conversation = SQLAssistantService.this.conversationsDAO.getConversation(this.projectKey, this.notebookId, this.cellId, userId);
                if (Boolean.TRUE.equals(response.ok)) {
                    SqlAssistantConversation.Message assistantMsg = new SqlAssistantConversation.Message(SqlAssistantConversation.MessageRole.ASSISTANT, response.answer);
                    conversation.messages.add(assistantMsg);
                    if (StringUtils.isNotBlank((String)response.sqlQuery)) {
                        SqlAssistantConversation.Message sqlMsg = new SqlAssistantConversation.Message(SqlAssistantConversation.MessageRole.ASSISTANT_SQL_QUERY, response.sqlQuery);
                        conversation.messages.add(sqlMsg);
                    }
                }
                conversation.statusNotes = response.statusNotes != null ? new ArrayList<SqlAssistantConversation.StatusNote>(response.statusNotes) : new ArrayList<SqlAssistantConversation.StatusNote>();
                SQLAssistantService.this.conversationsDAO.saveConversation(this.projectKey, this.notebookId, this.cellId, userId, conversation);
                response.conversationId = conversation.conversationId;
                logger.debug((Object)("Persisted SQL Assistant response for conversation " + conversation.conversationId));
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to persist SQL Assistant response", (Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private SQLAssistantAnswer requestAIServerAndProcessResponse(AIServerSQLAssistantAnswerRequest chatRequest) {
            GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            try (InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.authCtx, generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);){
                AIServerSQLAssistantAnswerResponse resp = (AIServerSQLAssistantAnswerResponse)apiClient.postObject("/v1/sql-assistant/answer", AIServerSQLAssistantAnswerResponse.class, (Object)chatRequest);
                if (resp.status == AIServerResponseStatus.error) {
                    SQLAssistantAnswer sQLAssistantAnswer2 = this.handleFailedRequest(null, resp.answer);
                    return sQLAssistantAnswer2;
                }
                SQLAssistantAnswer finalResp = new SQLAssistantAnswer();
                finalResp.ok = true;
                finalResp.sqlQuery = resp.sqlQuery != null ? resp.sqlQuery : "";
                finalResp.sqlQueryName = resp.sqlQueryName;
                finalResp.answer = resp.answer;
                finalResp.requestId = resp.requestId;
                ArrayList<SqlAssistantConversation.StatusNote> statusNotes = new ArrayList<SqlAssistantConversation.StatusNote>();
                if (resp.conversationTruncated) {
                    statusNotes.add(new SqlAssistantConversation.StatusNote(SqlAssistantConversation.StatusNote.Level.WARNING, "The conversation history was truncated. Consider starting a new conversation for better results."));
                }
                if (resp.tablesContextTruncated) {
                    statusNotes.add(new SqlAssistantConversation.StatusNote(SqlAssistantConversation.StatusNote.Level.WARNING, "The tables information were truncated. Consider selecting fewer tables."));
                }
                if (!statusNotes.isEmpty()) {
                    finalResp.statusNotes = statusNotes;
                }
                SQLAssistantAnswer sQLAssistantAnswer = finalResp;
                return sQLAssistantAnswer;
            }
            catch (IOException e) {
                return this.handleFailedRequest(e, "Could not connect to SQL Assistant");
            }
            catch (DKUSecurityException | IllegalArgumentException e) {
                return this.handleFailedRequest((Exception)e, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }

        private AIServerSQLAssistantAnswerRequest createAIServerSQLAssistantAnswerRequest(List<TableContext> tablesContext, List<SqlAssistantConversation.Message> conversationHistory) {
            LicenseStatusService.LicensingStatus licensingStatus = SQLAssistantService.this.licenseStatusService.getLicensingStatus();
            GeneralSettingsDAO.AIDrivenAnalyticsSettings aiDrivenAnalyticsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().aiDrivenAnalyticsSettings;
            AIServerSQLAssistantAnswerRequest request = new AIServerSQLAssistantAnswerRequest();
            request.licenseId = licensingStatus != null && licensingStatus.licenseContent != null ? licensingStatus.licenseContent.licenseId : null;
            request.telemetryEnabled = aiDrivenAnalyticsSettings.telemetryEnabled;
            request.requestOrigin = this.requestOrigin;
            request.userMessage = this.userMessage;
            request.currentSqlQuery = this.currentSqlQuery;
            request.currentErrorContext = this.currentSqlErrorContext;
            request.conversationHistory = conversationHistory;
            request.tablesContext = tablesContext;
            request.dialect = this.dialect.getId();
            request.conversationId = this.conversationId;
            return request;
        }

        private SQLAssistantAnswer handleFailedRequest(@Nullable Exception e, String text) {
            if (e != null) {
                logger.error((Object)"Exception while processing SQL chat request", (Throwable)e);
            }
            SQLAssistantAnswer finalResp = new SQLAssistantAnswer();
            finalResp.ok = false;
            finalResp.statusNotes = List.of(new SqlAssistantConversation.StatusNote(SqlAssistantConversation.StatusNote.Level.ERROR, text));
            return finalResp;
        }
    }

    @UIModel
    public static class SQLErrorContext {
        public String error;
        public String query;
    }

    public static enum RequestOrigin {
        SQL_NOTEBOOK;

    }

    public static class TableContext {
        public String qualifiedName;
        public List<ColumnInfo> columns;
        @Nullable
        public String catalog;
        @Nullable
        public String schema;
    }

    public static class ColumnInfo {
        public String name;
        public String type;

        public ColumnInfo() {
        }

        public ColumnInfo(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    @UIModel
    public static class SQLAssistantAnswer {
        public Boolean ok;
        public List<SqlAssistantConversation.StatusNote> statusNotes;
        public String answer;
        @Nullable
        public String sqlQuery;
        @Nullable
        public String sqlQueryName;
        public String requestId;
        public String conversationId;
    }

    public static class AIServerSQLAssistantAnswerResponse {
        public AIServerResponseStatus status;
        public String requestId;
        public String sqlQuery;
        public String answer;
        public String sqlQueryName;
        public boolean tablesContextTruncated;
        public boolean conversationTruncated;
    }

    public static class AIServerSQLAssistantAnswerRequest {
        public String licenseId;
        public String userMessage;
        public List<TableContext> tablesContext;
        public String dialect;
        public boolean telemetryEnabled;
        public RequestOrigin requestOrigin;
        public String currentSqlQuery;
        public SQLErrorContext currentErrorContext;
        public List<SqlAssistantConversation.Message> conversationHistory;
        public String conversationId;
    }

    public static enum AIServerResponseStatus {
        success,
        error;

    }
}

