/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.businessapps;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.businessapps.BusinessAppsDAO;
import com.dataiku.dip.businessapps.model.BusinessApp;
import com.dataiku.dip.businessapps.model.BusinessAppDescriptor;
import com.dataiku.dip.businessapps.model.BusinessAppSettings;
import com.dataiku.dip.businessapps.model.BusinessAppState;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelibpoi.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessAppInstallService {
    public static final String BACKUP_PREFIX = "BACKUP.";
    private static final String DESCRIPTOR_FILENAME = "business-app.json";
    private static final String IMAGE_FILE = "business-app.png";
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private BusinessAppsDAO businessAppsDAO;
    private static final Logger logger = Logger.getLogger((String)"dku.businessapp.install");

    public String installFromZip(File archiveFile, AuthCtx installUser) throws Exception {
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"business-app-install", (String)archiveFile.getName());){
            BusinessAppDescriptor desc = this.prepareInstallation(archiveFile, tmpDir);
            BusinessAppInstallService.checkDescriptorField(desc.id, "id");
            BusinessAppInstallService.checkDescriptorField(desc.version, "version");
            BusinessAppInstallService.checkDescriptorField(desc.name, "name");
            BusinessAppInstallService.checkDescriptorField(desc.webAppId, "webAppId");
            BusinessApp existingApp = this.businessAppsDAO.getOrNull(desc.id, BusinessAppsDAO.ReadOption.READ_DESCRIPTOR);
            File targetDir = BusinessAppsDAO.getInstalledBusinessAppFolder(desc.id);
            if (existingApp == null && targetDir.exists()) {
                throw new IllegalStateException("Business Application directory exists but descriptor is missing.");
            }
            if (existingApp != null && existingApp.desc != null && desc.version.equals(existingApp.desc.version)) {
                throw new IllegalStateException(String.format("Business Application version %s  is already installed.", desc.version));
            }
            String string = this.finalizeInstallation(installUser, existingApp != null, targetDir, tmpDir, desc);
            return string;
        }
    }

    private BusinessAppDescriptor prepareInstallation(File archiveFile, AutoDelete tmpDir) throws IOException {
        BusinessAppDescriptor desc;
        block41: {
            try (ZipFile zip = new ZipFile(archiveFile);){
                ZipEntry imageEntry;
                ExportedProject manifest;
                ZipEntry descEntry = zip.getEntry("project-resources/business-app.json");
                if (descEntry == null) {
                    throw new IOException("Missing descriptor: project-resources/business-app.json not found in " + archiveFile.getName());
                }
                if (descEntry.getSize() > 0xA00000L) {
                    throw new IOException(String.format("Unexpected manifest file size (must be less than 10MB): %d", descEntry.getSize()));
                }
                try (InputStream inputStream = zip.getInputStream(descEntry);){
                    desc = (BusinessAppDescriptor)JSON.parse((byte[])IOUtils.toByteArray((InputStream)inputStream), BusinessAppDescriptor.class);
                }
                String businessAppId = desc.id;
                logger.info((Object)("Installing Business Application " + businessAppId));
                ZipEntry manifestEntry = zip.getEntry("export-manifest.json");
                if (manifestEntry == null) {
                    throw new IOException("Missing manifest: export-manifest.json not found in " + archiveFile.getName());
                }
                try (InputStream inputStream = zip.getInputStream(manifestEntry);){
                    manifest = (ExportedProject)JSON.parse((byte[])IOUtils.toByteArray((InputStream)inputStream), ExportedProject.class);
                }
                if (manifest.requiredConnections != null && !manifest.requiredConnections.isEmpty()) {
                    if (desc.connections == null) {
                        desc.connections = new LinkedHashMap<String, String>();
                    }
                    for (DatasetConnectionUtils.UsedConnection connection : manifest.requiredConnections.values()) {
                        if (connection.type == null) continue;
                        desc.connections.put(connection.name, connection.type);
                    }
                }
                if ((imageEntry = zip.getEntry("project-resources/business-app.png")) != null) {
                    File imageFile = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{IMAGE_FILE});
                    try (InputStream inputStream = zip.getInputStream(imageEntry);){
                        FileUtils.copyToFile((InputStream)inputStream, (File)imageFile);
                    }
                } else {
                    logger.warn((Object)"Unable to find entry in zip for image: project-resources/business-app.png");
                }
                if (!StringUtils.isNotBlank((String)desc.codeEnvName)) break block41;
                boolean codeEnvDefined = false;
                Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
                while (zipFileEntries.hasMoreElements()) {
                    ZipEntry ceEntry = zipFileEntries.nextElement();
                    if (!ceEntry.getName().startsWith("project-resources/code-env")) continue;
                    codeEnvDefined = true;
                    String substring = ceEntry.getName().substring("project-resources/".length());
                    File destFile = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{substring});
                    if (ceEntry.isDirectory()) {
                        DKUFileUtils.mkdirs((File)destFile);
                        continue;
                    }
                    InputStream inputStream = zip.getInputStream(ceEntry);
                    try {
                        FileUtils.copyToFile((InputStream)inputStream, (File)destFile);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                if (!codeEnvDefined) {
                    throw new IOException(String.format("A code env name is defined (%s) but its definition is missing: No project-resource/code-env directory in %s", desc.codeEnvName, archiveFile.getName()));
                }
            }
        }
        File businessAppDescriptor = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{DESCRIPTOR_FILENAME});
        JSON.prettyToFile((Object)desc, (File)businessAppDescriptor);
        File applicationZipFile = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"app.zip"});
        FileUtils.copyFile((File)archiveFile, (File)applicationZipFile);
        return desc;
    }

    private String finalizeInstallation(AuthCtx installUser, boolean isUpdate, File targetDir, AutoDelete tmpDir, BusinessAppDescriptor manifest) throws IOException {
        BusinessAppState state;
        this.initializeSettings(targetDir, tmpDir, manifest);
        BusinessAppState.BusinessAppActionRecord record = new BusinessAppState.BusinessAppActionRecord();
        record.ts = System.currentTimeMillis();
        record.user = installUser.getIdentifier();
        record.action = isUpdate ? BusinessAppState.BusinessAppActionType.UPGRADE : BusinessAppState.BusinessAppActionType.INSTALL;
        File stateFile = new File(targetDir, "state.json");
        if (isUpdate) {
            if (!stateFile.exists()) {
                throw new IOException("Business Application state file does not exist: " + String.valueOf(stateFile));
            }
            state = (BusinessAppState)JSON.parseFile((File)stateFile, BusinessAppState.class);
        } else {
            state = new BusinessAppState();
        }
        state.actions.add(record);
        File backupDir = new File(targetDir.getParentFile(), BACKUP_PREFIX + targetDir.getName());
        try {
            if (isUpdate) {
                FileUtils.moveDirectory((File)targetDir, (File)backupDir);
            }
            assert (!targetDir.isDirectory());
            try {
                DKUFileUtils.mkdirsParent((File)targetDir);
                FileUtils.moveDirectory((File)tmpDir, (File)targetDir);
                JSON.prettyToFile((Object)state, (File)stateFile);
            }
            catch (Exception e) {
                DKUFileUtils.deleteDirectory((File)targetDir);
                throw e;
            }
            try {
                DKUFileUtils.deleteDirectory((File)backupDir);
            }
            catch (Exception e) {
                logger.info((Object)"Failed when deleting the backup directory. Will try again later.", (Throwable)e);
            }
            logger.info((Object)("Installation of Business Application " + manifest.id + " done."));
            return manifest.id;
        }
        catch (Exception ex) {
            if (isUpdate) {
                logger.error((Object)"Failed to install new version of Business Application, rolling back the old files");
                DKUFileUtils.deleteDirectory((File)targetDir);
                FileUtils.moveDirectory((File)backupDir, (File)targetDir);
            }
            throw ex;
        }
    }

    private void initializeSettings(File targetDir, AutoDelete tmpDir, BusinessAppDescriptor manifest) throws IOException {
        File settingsFile = new File(targetDir, "settings.json");
        BusinessAppSettings settings = settingsFile.exists() ? (BusinessAppSettings)JSON.parseFile((File)settingsFile, BusinessAppSettings.class) : new BusinessAppSettings();
        settings.remapping.connections = this.initializeConnectionsRemapping(manifest, settings.remapping.connections);
        JSON.prettyToFile((Object)settings, (File)new File((File)tmpDir, "settings.json"));
    }

    private List<ProjectRemappingSettings.ConnectionRemapping> initializeConnectionsRemapping(BusinessAppDescriptor manifest, List<ProjectRemappingSettings.ConnectionRemapping> remappingList) throws IOException {
        Map<String, DSSConnection> availableConnections = this.connectionsDAO.listUnsafe();
        Map requiredConnections = Objects.requireNonNullElseGet(manifest.connections, HashMap::new);
        ArrayList<ProjectRemappingSettings.ConnectionRemapping> result = new ArrayList<ProjectRemappingSettings.ConnectionRemapping>();
        for (String connectionName : requiredConnections.keySet()) {
            List<DSSConnection> acceptableConnections;
            String connectionType = (String)requiredConnections.get(connectionName);
            Optional<ProjectRemappingSettings.ConnectionRemapping> existingRemapping = remappingList.stream().filter(c2 -> c2.source.equals(connectionName)).findFirst();
            String target = existingRemapping.map(connectionRemapping -> connectionRemapping.target).orElse(null);
            DSSConnection matchingConnection = availableConnections.get(connectionName);
            if (target == null && matchingConnection != null && matchingConnection.type.equals(connectionType)) {
                target = connectionName;
            }
            if (target == null && (acceptableConnections = availableConnections.values().stream().filter(connection -> connection.owner == null && connection.type.equals(connectionType)).toList()).size() == 1) {
                target = acceptableConnections.get((int)0).name;
            }
            ProjectRemappingSettings.ConnectionRemapping e = new ProjectRemappingSettings.ConnectionRemapping();
            e.source = connectionName;
            e.target = target;
            result.add(e);
        }
        return result;
    }

    private static void checkDescriptorField(String businessAppDescriptor, String fieldName) {
        if (StringUtils.isBlank((String)businessAppDescriptor)) {
            throw new IllegalArgumentException(String.format("Missing or empty value for '%s' in %s", fieldName, DESCRIPTOR_FILENAME));
        }
    }
}

