/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ClusterDependentKernelHandle;
import com.dataiku.dip.cluster.ClusterDependentKernelItem;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.IClusterDependentKernelsManager;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;

public abstract class ClusterDependentKernelsManager<T extends ClusterDependentKernelHandle>
implements IClusterDependentKernelsManager<T> {
    private static final long IDLE_CLEANUP_DELAY = 300000L;
    private static final Object KERNEL_ACQUIRE_LOCK = new Object();
    private final Map<String, T> currentKernels = Maps.newHashMap();
    private final Map<String, T> startingKernels = Maps.newConcurrentMap();
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.kernels.cluster_dependent.manager");

    public ClusterDependentKernelsManager() {
        Timer expirationTimer = new Timer(StringUtils.capitalize((String)this.getPrefix()) + "Kernels-cleanup", true);
        long delay = 300000L;
        expirationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                logger.info((Object)("Perform routine cleanup on " + ClusterDependentKernelsManager.this.getPrefix() + " kernels (" + ClusterDependentKernelsManager.this.currentKernels.size() + " kernels running)"));
                ClusterDependentKernelsManager.this.cleanUpKernels();
            }
        }, delay, delay);
    }

    @Override
    public boolean isUsable() {
        return true;
    }

    private void cleanUpKernels() {
        List<T> idleKernels = this.getIdleKernels();
        logger.info((Object)("Found " + idleKernels.size() + " idle kernels to release"));
        for (ClusterDependentKernelHandle kernel : idleKernels) {
            this.destroyKernel(kernel);
        }
    }

    private synchronized List<T> getIdleKernels() {
        ArrayList idleKeys = Lists.newArrayList();
        ArrayList idleKernels = Lists.newArrayList();
        for (Map.Entry<String, T> kernelEntry : this.currentKernels.entrySet()) {
            ClusterDependentKernelHandle kernel = (ClusterDependentKernelHandle)kernelEntry.getValue();
            if (kernel.getRefCount() > 0 || kernel.getIdle() <= 300000L) continue;
            idleKeys.add(kernelEntry.getKey());
            idleKernels.add(kernel);
        }
        for (String key : idleKeys) {
            this.currentKernels.remove(key);
        }
        return idleKernels;
    }

    public synchronized List<ClusterDependentKernelItem> getKernelItems() {
        ArrayList items = Lists.newArrayList();
        for (ClusterDependentKernelHandle kernel : this.currentKernels.values()) {
            items.add(new ClusterDependentKernelItem(kernel));
        }
        return items;
    }

    public synchronized void abort(String kernelKeyOrId) {
        ClusterDependentKernelHandle kernel = null;
        for (Map.Entry<String, T> kernelEntry : this.currentKernels.entrySet()) {
            if (kernelEntry.getKey().equals(kernelKeyOrId)) {
                kernel = (ClusterDependentKernelHandle)kernelEntry.getValue();
                continue;
            }
            if (!((ClusterDependentKernelHandle)kernelEntry.getValue()).getKernelId().equals(kernelKeyOrId)) continue;
            kernel = (ClusterDependentKernelHandle)kernelEntry.getValue();
        }
        if (kernel != null) {
            this.releaseAndKillKernel(kernel);
        } else {
            logger.info((Object)("Could not find kernel " + kernelKeyOrId + " to abort"));
        }
    }

    public T getStarting(String kernelId) {
        return (T)((ClusterDependentKernelHandle)this.startingKernels.get(kernelId));
    }

    protected abstract T instantiateKernel(String var1, String var2);

    public abstract String getPrefix();

    protected abstract String getKey(ClusterSettings var1);

    private void destroyKernel(T kernel) {
        try {
            kernel.killWithoutMercy();
        }
        catch (Exception e) {
            logger.error((Object)"Failure while destroying the kernel", (Throwable)e);
        }
        logger.info((Object)("Released " + this.getPrefix() + " kernel " + kernel.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T newKernel(String key, ClusterSettings clusterSettings) throws Exception {
        String kernelId = SecretKeyGenerator.generate((int)8);
        logger.infoV("Creating kernel id=%s for clusterId=%s", new Object[]{kernelId, clusterSettings.getClusterId()});
        T kernel = this.instantiateKernel(kernelId, key);
        this.startingKernels.put(kernelId, kernel);
        try {
            ((ClusterDependentKernelHandle)kernel).start(clusterSettings);
            logger.info((Object)(StringUtils.capitalize((String)this.getPrefix()) + " kernel " + kernel.getId() + " started and ready to work"));
            T t = kernel;
            return t;
        }
        finally {
            this.startingKernels.remove(kernelId);
        }
    }

    @Override
    public synchronized void invalidateKernels() {
        this.currentKernels.clear();
    }

    @Override
    public synchronized void releaseKernel(T kernel) {
        logger.info((Object)("Release " + this.getPrefix() + " kernel " + kernel.getId()));
        ((ClusterDependentKernelHandle)kernel).releaseNow();
        ((ClusterDependentKernelHandle)kernel).touch();
        if (((ClusterDependentKernelHandle)kernel).decRefCount() <= 0 && kernel != this.currentKernels.get(((ClusterDependentKernelHandle)kernel).getKey())) {
            logger.info((Object)("Not reusing this " + this.getPrefix() + " kernel"));
            this.destroyKernel(kernel);
        }
    }

    @Override
    public synchronized void releaseAndKillKernel(T kernel) {
        if (this.currentKernels.get(((ClusterDependentKernelHandle)kernel).getKey()) == kernel) {
            this.currentKernels.remove(((ClusterDependentKernelHandle)kernel).getKey());
        }
        this.destroyKernel(kernel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T acquireKernel(ClusterSettings clusterSettings) throws Exception {
        Object object = KERNEL_ACQUIRE_LOCK;
        synchronized (object) {
            ClusterDependentKernelHandle currentKernel;
            String key = this.getKey(clusterSettings);
            logger.info((Object)("Acquiring a " + this.getPrefix() + " kernel for " + key));
            ClusterDependentKernelsManager clusterDependentKernelsManager = this;
            synchronized (clusterDependentKernelsManager) {
                currentKernel = (ClusterDependentKernelHandle)this.currentKernels.get(key);
            }
            boolean needsNewKernel = false;
            if (currentKernel == null) {
                logger.info((Object)("Synchronous failure to get existing " + this.getPrefix() + " kernel, starting a new one (existing=" + Joiner.on((String)",").join(this.currentKernels.keySet()) + ")"));
                needsNewKernel = true;
            } else if (currentKernel.isFinished()) {
                logger.info((Object)("Found existing " + this.getPrefix() + " kernel for " + key + " but it's already stopped, starting a new one"));
                needsNewKernel = true;
            }
            if (needsNewKernel) {
                currentKernel = this.newKernel(key, clusterSettings);
                ClusterDependentKernelsManager clusterDependentKernelsManager2 = this;
                synchronized (clusterDependentKernelsManager2) {
                    this.currentKernels.put(key, currentKernel);
                }
            }
            ClusterDependentKernelHandle kernel = currentKernel;
            int refCount = kernel.incRefCount();
            logger.info((Object)("Acquired " + this.getPrefix() + " kernel " + kernel.getId() + " (refCount=" + refCount + "), setting job"));
            kernel.acquireNow();
            kernel.touch();
            return (T)kernel;
        }
    }
}

