/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvImportUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.containers.exec.ContainerExecImagesBuilder;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class CodeEnvUtilsBase {
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.codeenv.utils");

    protected CodeEnvUtilsBase() {
    }

    protected static File f(File f, String ... chunks) {
        return new File(f, StringUtils.join((Object[])chunks, (String)"/"));
    }

    protected static String readCodeEnvStaticResourceFile(CodeEnvModel.EnvLang language, String ... chunks) throws IOException {
        String path = "code-envs/" + language.toString().toLowerCase() + "/" + StringUtils.join((Object[])chunks, (String)"/");
        File f = ApplicationConfigurator.getResourceFile((String)path);
        return FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
    }

    protected static String readCodeEnvStaticResourceFileWithVersionOverride(CodeEnvModel.EnvLang language, String version, String ... chunks) throws IOException {
        String versionPath = "code-envs/" + language.toString().toLowerCase() + "/" + version + "/" + StringUtils.join((Object[])chunks, (String)"/");
        if (DKUApp.getResourceFile((String)versionPath).exists()) {
            return FileUtils.readFileToString((File)DKUApp.getResourceFile((String)versionPath), (Charset)StandardCharsets.UTF_8);
        }
        String basePath = "code-envs/" + language.toString().toLowerCase() + "/" + StringUtils.join((Object[])chunks, (String)"/");
        return FileUtils.readFileToString((File)DKUApp.getResourceFile((String)basePath), (Charset)StandardCharsets.UTF_8);
    }

    public static void addLogHeader(AuthCtx authCtx, File log, String message, String command) throws FileNotFoundException {
        CodeEnvUtilsBase.addLogHeader(authCtx, log, message, command, null);
    }

    public static void addLogHeader(AuthCtx authCtx, File log, String message, String command, String extra) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(log, true));){
            writer.println();
            writer.println("*********************************************************");
            writer.println("*********************************************************");
            writer.println("*");
            writer.println("* " + message);
            writer.println("*");
            writer.println("* " + (authCtx == null ? "nobody" : authCtx.toString()) + " at " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(new Date()));
            writer.println("*");
            writer.println("* command : " + command);
            writer.println("*");
            if (StringUtils.isNotBlank((String)extra)) {
                writer.println("* extra :");
                writer.println(extra);
                writer.println("*");
            }
            writer.println("*********************************************************");
            writer.println("*********************************************************");
        }
    }

    public static StandardPythonInterpreter getDefaultInterpreterForPlugin(List<StandardPythonInterpreter> availableInterpreters, @Nullable List<StandardPythonInterpreter> acceptedPythonInterpreters) {
        StandardPythonInterpreter chosenInterpreter;
        if (acceptedPythonInterpreters == null || acceptedPythonInterpreters.isEmpty()) {
            if (!availableInterpreters.isEmpty()) {
                chosenInterpreter = availableInterpreters.get(0);
                logger.info((Object)"Plugin has no acceptedInterpreter: choosing available interpreter.");
            } else {
                chosenInterpreter = StandardPythonInterpreter.PYTHON39;
                logger.error((Object)"Plugin has no acceptedInterpreter and no interpreter was found on the machine. Using a default.");
            }
        } else if (availableInterpreters.isEmpty()) {
            chosenInterpreter = StandardPythonInterpreter.PYTHON39;
            logger.error((Object)"Plugin has acceptedInterpreter and no interpreter was found on the machine. Using a default.");
        } else {
            StandardPythonInterpreter goodInterpreter = StandardPythonInterpreter.getPreferredInIntersectionOrNull(acceptedPythonInterpreters, availableInterpreters);
            if (goodInterpreter != null) {
                chosenInterpreter = goodInterpreter;
                logger.info((Object)"Interpreter accepted by plugin and available on the machine.");
            } else {
                chosenInterpreter = acceptedPythonInterpreters.get(0);
                logger.info((Object)"No available interpreter is accepted by the plugin. Using first acceptedInterpreter as default.");
            }
        }
        logger.info((Object)("Plugin default interpreter : " + String.valueOf((Object)chosenInterpreter)));
        return chosenInterpreter;
    }

    public static File preparePluginImport(File envFolder, CodeEnvModel.EnvLang envLang, CodeEnvModel.AbstractEnvDesc envDesc, List<StandardPythonInterpreter> availableInterpreters) throws IOException {
        AutoDelete unzipDir = CodeEnvImportUtils.getTempImportFolder("import-plugin-" + envFolder.getName());
        DKUFileUtils.copyDirectory((File)envFolder, (File)unzipDir);
        logger.info((Object)("Requested env desc " + JSON.log((Object)envDesc)));
        File descFile = new File((File)unzipDir, "desc.json");
        CodeEnvModel.AbstractEnvDesc updatedEnvDesc = switch (envLang) {
            case CodeEnvModel.EnvLang.PYTHON -> {
                CodeEnvModel.PythonPluginEnvDesc pluginEnvDesc = (CodeEnvModel.PythonPluginEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.PythonPluginEnvDesc.class);
                logger.info((Object)("Plugin env desc " + JSON.log((Object)pluginEnvDesc)));
                CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.deepCopy((Object)((CodeEnvModel.PythonEnvDesc)envDesc));
                desc.conda |= pluginEnvDesc.forceConda;
                desc.installJupyterSupport = pluginEnvDesc.installJupyterSupport;
                if (((CodeEnvModel.PythonEnvDesc)envDesc).pythonInterpreter == null) {
                    desc.pythonInterpreter = CodeEnvUtilsBase.getDefaultInterpreterForPlugin(availableInterpreters, pluginEnvDesc.acceptedPythonInterpreters);
                }
                desc.installCorePackages = pluginEnvDesc.installCorePackages;
                desc.corePackagesSet = pluginEnvDesc.corePackagesSet;
                yield desc;
            }
            case CodeEnvModel.EnvLang.R -> {
                CodeEnvModel.RPluginEnvDesc pluginEnvDesc = (CodeEnvModel.RPluginEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.RPluginEnvDesc.class);
                logger.info((Object)("Plugin env desc " + JSON.log((Object)pluginEnvDesc)));
                CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.deepCopy((Object)((CodeEnvModel.REnvDesc)envDesc));
                desc.conda |= pluginEnvDesc.forceConda;
                desc.installCorePackages = pluginEnvDesc.installCorePackages;
                desc.installJupyterSupport = pluginEnvDesc.installJupyterSupport;
                yield desc;
            }
            default -> throw new Error("unreachable");
        };
        JSON.prettyToFile((Object)updatedEnvDesc, (File)descFile);
        logger.info((Object)("Effective env desc " + JSON.log((Object)updatedEnvDesc)));
        return unzipDir;
    }

    public static File prepareBusinessAppImport(File envFolder, CodeEnvModel.EnvLang envLang, CodeEnvModel.AbstractEnvDesc envDesc, List<StandardPythonInterpreter> availableInterpreters) throws IOException {
        AutoDelete unzipDir = CodeEnvImportUtils.getTempImportFolder("import-business-app-" + envFolder.getName());
        DKUFileUtils.copyDirectory((File)envFolder, (File)unzipDir);
        logger.info((Object)("Requested env desc " + JSON.log((Object)envDesc)));
        File descFile = new File((File)unzipDir, "desc.json");
        CodeEnvModel.AbstractEnvDesc updatedEnvDesc = switch (envLang) {
            case CodeEnvModel.EnvLang.PYTHON -> {
                CodeEnvModel.PythonBusinessAppEnvDesc businessAppEnvDesc = (CodeEnvModel.PythonBusinessAppEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.PythonBusinessAppEnvDesc.class);
                logger.info((Object)("Business Application env desc " + JSON.log((Object)businessAppEnvDesc)));
                CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.deepCopy((Object)((CodeEnvModel.PythonEnvDesc)envDesc));
                desc.conda |= businessAppEnvDesc.forceConda;
                desc.installJupyterSupport = businessAppEnvDesc.installJupyterSupport;
                if (((CodeEnvModel.PythonEnvDesc)envDesc).pythonInterpreter == null) {
                    desc.pythonInterpreter = CodeEnvUtilsBase.getDefaultInterpreterForPlugin(availableInterpreters, businessAppEnvDesc.acceptedPythonInterpreters);
                }
                desc.installCorePackages = businessAppEnvDesc.installCorePackages;
                desc.corePackagesSet = businessAppEnvDesc.corePackagesSet;
                yield desc;
            }
            case CodeEnvModel.EnvLang.R -> {
                CodeEnvModel.RBusinessAppEnvDesc businessAppEnvDesc = (CodeEnvModel.RBusinessAppEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.RBusinessAppEnvDesc.class);
                logger.info((Object)("Business Application env desc " + JSON.log((Object)businessAppEnvDesc)));
                CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.deepCopy((Object)((CodeEnvModel.REnvDesc)envDesc));
                desc.conda |= businessAppEnvDesc.forceConda;
                desc.installCorePackages = businessAppEnvDesc.installCorePackages;
                desc.installJupyterSupport = businessAppEnvDesc.installJupyterSupport;
                yield desc;
            }
            default -> throw new Error("unreachable");
        };
        JSON.prettyToFile((Object)updatedEnvDesc, (File)descFile);
        logger.info((Object)("Effective env desc " + JSON.log((Object)updatedEnvDesc)));
        return unzipDir;
    }

    public static void removeCodeEnvImages(CodeEnvModel.AbstractEnvDesc envDesc, CodeEnvModel.EnvLang envLang, String envName) throws InterruptedException, IOException {
        ContainerSettings containerSettings = new ClusterSelector().selectGlobal().getContainerSettings();
        ArrayList<Pair> configurations = new ArrayList<Pair>();
        if (envDesc.allContainerConfs) {
            for (ContainerExecRuntimeConfig config : containerSettings.executionConfigs) {
                configurations.add(new Pair((Object)config.name, (Object)config));
            }
        } else {
            for (Object confName : envDesc.containerConfs) {
                ContainerExecRuntimeConfig config = containerSettings.getByNameOrNull((String)confName);
                if (config == null) continue;
                configurations.add(new Pair((Object)config.name, (Object)config));
            }
        }
        SparkSettings sparkSettings = new ClusterSelector().selectGlobal().getSparkSettings();
        if (envDesc.allSparkKubernetesConfs) {
            for (SparkExecutionConfig conf : sparkSettings.executionConfigs) {
                if (!conf.kubernetesSettings.managedKubernetes) continue;
                configurations.add(new Pair((Object)conf.name, (Object)conf.kubernetesSettings));
            }
        } else {
            for (String confName : envDesc.sparkKubernetesConfs) {
                SparkExecutionConfig conf = sparkSettings.getByNameOrNull(confName);
                if (conf == null || !conf.kubernetesSettings.managedKubernetes) continue;
                configurations.add(new Pair((Object)conf.name, (Object)conf.kubernetesSettings));
            }
        }
        HashSet<String> deletedTags = new HashSet<String>();
        for (Pair containerConfigAndName : configurations) {
            ContainerExecUtils.ContainerBaseConfig containerConfig = (ContainerExecUtils.ContainerBaseConfig)containerConfigAndName.second;
            List<String> tagsToDelete = ContainerExecImagesHelper.getCodeEnvImageTags(containerConfig.dockerHost, containerConfig.baseImage, containerConfig.baseImageType, envLang, envName, null);
            for (String tag : tagsToDelete) {
                for (String imageToDelete : ContainerExecImagesBuilder.getImagesToDelete(tag, Sets.newHashSet((Object[])new String[]{containerConfig.repositoryURL}))) {
                    if (deletedTags.contains(imageToDelete)) continue;
                    deletedTags.add(imageToDelete);
                    ProcessBuilder pb = new ProcessBuilder("docker", "rmi");
                    pb.command().add(imageToDelete);
                    ContainerExecUtils.enrichDockerEnv(containerConfig, pb.environment());
                    try {
                        DKUtils.execAndLogThrows((ProcessBuilder)pb);
                    }
                    catch (IOException e) {
                        logger.error((Object)("Could not remove docker image: " + imageToDelete), (Throwable)e);
                    }
                }
            }
        }
        ContainerExecImagesHelper.unregisterImagesForEnv(envLang, envName);
    }

    public static Set<String> getEnvNamesSet() throws IOException {
        HashSet names = Sets.newHashSet();
        for (CodeEnvModel.CodeEnvListItem item : switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> ((AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class)).listCodeEnvs();
            case ApplicationConfigurator.DSSNodeType.DESIGN -> ((DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class)).listCodeEnvs();
            default -> throw new Error("unreachable");
        }) {
            names.add(item.envName);
        }
        return names;
    }

    public static CodeEnvModel.CodeEnvListItem getListItemFromDesc(CodeEnvModel.AbstractEnvDesc desc, CodeEnvModel.EnvLang envLang, String envName) {
        CodeEnvModel.CodeEnvListItem item = new CodeEnvModel.CodeEnvListItem();
        item.envName = envName;
        item.envLang = envLang;
        item.deploymentMode = desc.deploymentMode;
        item.owner = desc.owner;
        item.containerConfs = desc.containerConfs;
        item.allContainerConfs = desc.allContainerConfs;
        item.allSparkKubernetesConfs = desc.allSparkKubernetesConfs;
        item.sparkKubernetesConfs = desc.sparkKubernetesConfs;
        return item;
    }

    public static CodeEnvModel.CodeEnvListItem getListItemFromDesc(CodeEnvModel.PythonEnvDesc desc, String envName) {
        CodeEnvModel.CodeEnvListItem item = CodeEnvUtilsBase.getListItemFromDesc(desc, CodeEnvModel.EnvLang.PYTHON, envName);
        item.pythonInterpreter = CodeEnvUtilsBase.getPythonInterpreter(desc);
        item.upstreamPreset = desc.upstreamPreset;
        return item;
    }

    public static StandardPythonInterpreter getPythonInterpreter(CodeEnvModel.PythonEnvDesc desc) {
        if (desc.deploymentMode == null) {
            return desc.pythonInterpreter;
        }
        switch (desc.deploymentMode) {
            case DESIGN_NON_MANAGED: 
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case EXTERNAL_CONDA_NAMED: {
                return null;
            }
        }
        return desc.pythonInterpreter;
    }

    @VisibleForTesting
    public static String validateAndGetRenamedResourcePath(String path, String newName) {
        CodeEnvUtilsBase.validateResourceName(newName);
        return Paths.get(path, new String[0]).resolveSibling(newName).normalize().toString();
    }

    @VisibleForTesting
    public static File resolveSafely(File resourcesFolder, String path) throws IOException {
        File file = new File(resourcesFolder, path);
        if (!DKUFileUtils.isWithin((File)resourcesFolder, (File)file)) {
            throw new IOException("Resource " + path + " not within resources folder");
        }
        return file;
    }

    private static void validateResourceName(String newName) {
        if (StringUtils.isBlank((String)newName)) {
            throw new DKUControllerBase.MalformedRequestException("New name cannot be blank");
        }
        Pattern ILLEGAL_CHARACTERS = Pattern.compile("[<>:\"/\\\\|?*\\x00-\\x1F]");
        if (ILLEGAL_CHARACTERS.matcher(newName).find()) {
            throw new DKUControllerBase.MalformedRequestException("New name contains illegal characters (< > : \" / \\ | ? * or control characters).");
        }
        if (newName.getBytes(StandardCharsets.UTF_8).length > 255) {
            throw new DKUControllerBase.MalformedRequestException("New name cannot exceed 255 bytes");
        }
        if (".".equals(newName) || "..".equals(newName)) {
            throw new DKUControllerBase.MalformedRequestException("New name cannot be '.' or '..'");
        }
    }
}

