/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio;

import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;

public class CodeStudioRegistry {
    private static final Map<String, CodeStudioMeta> library = Maps.newLinkedHashMap();

    public static CodeStudioMeta getMeta(CodeStudioTemplate codeStudioTemplate) {
        return CodeStudioRegistry.getMeta(codeStudioTemplate.type);
    }

    public static synchronized CodeStudioMeta getMeta(String type) {
        if (library.containsKey(type)) {
            return library.get(type);
        }
        throw UnavailableDSSObjectException.fromObjectTypeAndType("code_studio_template", type);
    }

    public static boolean hasMeta(CodeStudioTemplate codeStudioTemplate) {
        return CodeStudioRegistry.hasMeta(codeStudioTemplate.type);
    }

    public static synchronized boolean hasMeta(String type) {
        return library.containsKey(type);
    }

    public static synchronized Iterable<CodeStudioMeta> getAllMeta() {
        return new ArrayList<CodeStudioMeta>(library.values());
    }

    public static synchronized void register(CodeStudioMeta meta) {
        library.put(meta.getType(), meta);
    }

    public static synchronized void deregister(String type) {
        library.remove(type);
    }
}

