/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.analysis.model.llm.LLMModelSnippetData;
import com.dataiku.dip.connections.AbstractAzureAIConnection;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.openai.AzureAIFoundryModelHandlingMode;
import com.dataiku.dip.llm.online.openai.OpenAIImageHandling;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;

public class AzureAIFoundryConnection
extends AbstractAzureAIConnection<AzureAIFoundryDeployment, AbstractLLMConnection.IHardcodedConnectionModel<AbstractAzureAIConnection.AbstractAzureAIModel>, CustomAzureAIFoundryModel> {
    public static final String connectionType = "AzureAIFoundry";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.azureaifoundry");

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testAzureAIFoundry(this, authCtx);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    public static class CustomAzureAIFoundryModel
    extends AbstractAzureAIConnection.AbstractCustomAzureAIModel {
        @Override
        protected AzureAIFoundryModel initModel() {
            return new AzureAIFoundryModel(AzureAIFoundryModelHandlingMode.DEFAULT);
        }
    }

    public static class AzureAIFoundryModel
    extends AbstractAzureAIConnection.AbstractAzureAIModel {
        public AzureAIFoundryModelHandlingMode modelHandlingMode;

        public AzureAIFoundryModel(AzureAIFoundryModelHandlingMode modelHandlingMode) {
            this.modelHandlingMode = modelHandlingMode;
        }

        @Override
        public LLMStructuredRef asStructuredRef(String connection) {
            return LLMStructuredRef.forAzureAIConnection(connection, this.getId(), LLMStructuredRef.LLMType.AZURE_AI_FOUNDRY_DEPLOYMENT);
        }

        @Override
        public AbstractAzureAIConnection.AbstractAzureAIModel toFineTunedModel(LLMModelSnippetData snippetData) {
            throw new IllegalStateException("Fine-tuned models are not supported for this connection type");
        }
    }

    public static class AzureAIFoundryDeployment
    extends AbstractAzureAIConnection.AbstractAzureAIDeployment {
        public AzureAIFoundryModelHandlingMode modelHandlingMode = AzureAIFoundryModelHandlingMode.DEFAULT;

        @Override
        protected String getType() {
            return "Azure AI Foundry";
        }

        @Override
        protected OpenAIImageHandling getDefaultImageHandlingMode() {
            return OpenAIImageHandling.NONE;
        }

        @Override
        protected AzureAIFoundryModel initModel() {
            return new AzureAIFoundryModel(this.modelHandlingMode);
        }

        @Override
        AbstractAzureAIConnection.AzureOpenAIMaxTokensAPIMode getMaxTokensAPIMode() {
            return this.modelHandlingMode.usesModernMaxTokens() ? AbstractAzureAIConnection.AzureOpenAIMaxTokensAPIMode.MODERN : AbstractAzureAIConnection.AzureOpenAIMaxTokensAPIMode.LEGACY;
        }
    }
}

