/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithDatabricksCredentials;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.externalinfras.databricks.DatabricksHTTPClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DatabricksModelDeploymentConnection
extends DSSConnection
implements ConnectionWithDatabricksCredentials,
ConnectionWithEncryptedFields {
    public Params params = new Params();
    public static final String DATABRICKS_MODEL_DEPLOYMENT_CONNECTION_TYPE = "DatabricksModelDeployment";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.databricksmodeldeployment");

    public DatabricksModelDeploymentConnection() {
        this.allowWrite = false;
        this.allowManagedDatasets = false;
        this.allowManagedFolders = false;
    }

    @Override
    public String getType() {
        return DATABRICKS_MODEL_DEPLOYMENT_CONNECTION_TYPE;
    }

    @Override
    public ConnectionWithDatabricksCredentials.IDatabricksParams getNonResolvedParams() {
        return this.params;
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public com.dataiku.dip.utils.Params getDkuPropertiesAsParams() {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.params.dkuProperties);
    }

    @Override
    public boolean useOfflineConsentForOauth2() {
        return true;
    }

    @Override
    public String getDefaultAuthScope() {
        return "2ff814a6-3304-4ab8-85cb-cd0e6f879c1d/.default offline_access";
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials.class));
        ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials creds = this.getResolvedDatabricksCredentials(ctx);
        return clazz.cast(creds);
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential("", this.params.personalAccessToken);
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.personalAccessToken = vc.expand(this.params.personalAccessToken);
    }

    @Override
    protected List<AbstractSQLConnection.CustomDatabaseProperty> getDkuPropertiesInternal() {
        return this.params.dkuProperties;
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.personalAccessToken = cryptoService.decryptIfEncrypted(this.params.personalAccessToken);
        this.params.oauth2ClientSecret = cryptoService.decryptIfEncrypted(this.params.oauth2ClientSecret);
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.personalAccessToken = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.personalAccessToken);
        this.params.oauth2ClientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.oauth2ClientSecret);
    }

    public String getAuthToken(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.isFreelyUsableBy(authCtx)) {
            throw new UnauthorizedException("Access to this connection is not authorized.", "connection-access-denied");
        }
        try {
            ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials creds = this.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials.class);
            switch (creds.authType) {
                case PERSONAL_ACCESS_TOKEN: {
                    return creds.personalToken;
                }
                case OAUTH2_APP: {
                    return creds.oauth2AccessToken;
                }
            }
            throw new Error("Unreachable");
        }
        catch (DKUSecurityException | IOException | SQLException e) {
            throw new UnauthorizedException("Unable to get credentials", "connection-access-denied", e);
        }
    }

    public DatabricksHTTPClient getClient(AuthCtx authCtx, int connectTimeout, int socketTimeout) throws UnauthorizedException {
        return new DatabricksHTTPClient(this.params.getHostBaseURL(), this.getProxySettings(), this.getAuthToken(authCtx), connectTimeout, socketTimeout);
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testDatabricksModelDeployment(this, authCtx);
    }

    public static class Params
    implements ConnectionWithDatabricksCredentials.IDatabricksParams {
        @Nullable
        public String host;
        public int port = 443;
        public String httpPath;
        public boolean ssl = true;
        public ConnectionWithDatabricksCredentials.AuthType authType = ConnectionWithDatabricksCredentials.AuthType.PERSONAL_ACCESS_TOKEN;
        public String personalAccessToken;
        public String oauth2ClientId;
        public String oauth2ClientSecret;
        public String oauth2Scope;
        public String azureTenantId;
        public String oauth2AuthorizationEndpoint;
        public String oauth2tokenEndpoint;
        public boolean refreshTokenRotation;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

        public String getHostBaseURL() {
            if (this.host == null) {
                throw ErrorContext.ice((String)"The value of host is not defined in the Databricks Model Deployment connection settings");
            }
            String stripped_host = this.host.replace("https://", "").replace("http://", "");
            if (stripped_host.endsWith("/")) {
                stripped_host = StringUtils.chop((String)stripped_host);
            }
            return (this.ssl ? "https" : "http") + "://" + stripped_host + ":" + this.port + (String)(StringUtils.isNotEmpty((String)this.httpPath) ? "/" + this.httpPath : "");
        }

        @Override
        public ConnectionWithDatabricksCredentials.AuthType getAuthType() {
            return this.authType;
        }

        @Override
        public String getOAuth2ClientId() {
            return this.oauth2ClientId;
        }

        @Override
        public String getOAuth2ClientSecret() {
            return this.oauth2ClientSecret;
        }

        @Override
        public String getOAuth2AuthorizationEndpoint() {
            return this.oauth2AuthorizationEndpoint;
        }

        @Override
        public String getOAuth2TokenEndpoint() {
            return this.oauth2tokenEndpoint;
        }

        @Override
        public String getOAuth2AzureTenantId() {
            return this.azureTenantId;
        }

        @Override
        public String getOAuth2Scope() {
            return this.oauth2Scope;
        }

        @Override
        public boolean getRefreshTokenRotation() {
            return this.refreshTokenRotation;
        }
    }
}

