/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.InstanceLicenseKind;
import com.dataiku.dip.utils.DKULogger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class GoogleUserAgentBuilder {
    public static final String LICENSE_FLAG_NONE = "";
    public static final String LICENSE_FLAG_INTERNAL = "internal";
    private static final String DSS_VERSION_UNKNOWN = "Unknown";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.gcp.useragent");

    public static String buildWithSpringContext() {
        SpringUtils springUtils = SpringUtils.getInstance();
        if (springUtils != null) {
            try {
                LicenseStatusService licenseStatusService = (LicenseStatusService)springUtils.getACBF().getBean(LicenseStatusService.class);
                return GoogleUserAgentBuilder.build(licenseStatusService);
            }
            catch (NoSuchBeanDefinitionException e) {
                logger.warn((Object)"Cannot determine the licensing status: no LicensingStatusService instance registered in Spring context.");
                return GoogleUserAgentBuilder.build(LICENSE_FLAG_NONE);
            }
        }
        logger.warn((Object)"Cannot determine the licensing status: Spring context is not available.");
        return GoogleUserAgentBuilder.build(LICENSE_FLAG_NONE);
    }

    public static String build(String licenseFlag) {
        return GoogleUserAgentBuilder.build(ApplicationConfigurator.getDSSVersion(), licenseFlag);
    }

    public static String build(LicenseStatusService licenseStatusService) {
        LicenseStatusService.LicensingStatus licensingStatus = licenseStatusService != null ? licenseStatusService.getLicensingStatus() : null;
        return GoogleUserAgentBuilder.build(ApplicationConfigurator.getDSSVersion(), GoogleUserAgentBuilder.buildLicenseFlag(licensingStatus));
    }

    public static String buildForTest() {
        return GoogleUserAgentBuilder.build("0.0-tests", LICENSE_FLAG_INTERNAL);
    }

    public static String build(DKUApp.DSSVersion dssVersion, String licenseFlag) {
        String version = dssVersion != null ? dssVersion.product_version : null;
        return GoogleUserAgentBuilder.build(version, licenseFlag);
    }

    public static String build(String dssVersion, String licenseFlag) {
        String version = dssVersion == null || dssVersion.length() == 0 ? DSS_VERSION_UNKNOWN : dssVersion.replaceAll("/", "_");
        return "DSS/" + version + " (GPN:Dataiku;" + licenseFlag + ")";
    }

    private static String buildLicenseFlag(LicenseStatusService.LicensingStatus licensingStatus) {
        if (licensingStatus != null && licensingStatus.hasLicense && licensingStatus.licenseContent != null && InstanceLicenseKind.DATAIKU_INTERNAL.toString().equals(licensingStatus.licenseContent.licenseKind)) {
            return LICENSE_FLAG_INTERNAL;
        }
        return LICENSE_FLAG_NONE;
    }

    private GoogleUserAgentBuilder() {
    }
}

