/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.iceberg;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HadoopFileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.ResolvingFileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.BaseHTTPClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.HTTPRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthSession;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ErrorResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadTableResponse;
import com.dataiku.dss.shadelibawssk2.org.apache.iceberg.aws.s3.S3FileIO;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSFileIO;
import com.dataiku.dss.shadelibgcp.org.apache.iceberg.gcp.gcs.GCSFileIO;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Consumer;

public class ClassFixingHTTPClient
extends BaseHTTPClient {
    private final BaseHTTPClient delegate;
    private final Method buildRequestMethod;
    private final Method executeMethod;

    public ClassFixingHTTPClient(BaseHTTPClient delegate) {
        this.delegate = delegate;
        try {
            this.buildRequestMethod = delegate.getClass().getDeclaredMethod("buildRequest", HTTPRequest.HTTPMethod.class, String.class, Map.class, Map.class, Object.class);
            this.buildRequestMethod.setAccessible(true);
            this.executeMethod = delegate.getClass().getDeclaredMethod("execute", HTTPRequest.class, Class.class, Consumer.class, Consumer.class);
            this.executeMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to access internal methods of http client", e);
        }
    }

    public RESTClient withAuthSession(AuthSession authSession) {
        return new ClassFixingHTTPClient((BaseHTTPClient)this.delegate.withAuthSession(authSession));
    }

    protected HTTPRequest buildRequest(HTTPRequest.HTTPMethod httpMethod, String s, Map<String, String> map, Map<String, String> map1, Object o) {
        try {
            return (HTTPRequest)this.buildRequestMethod.invoke((Object)this.delegate, httpMethod, s, map, map1, o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to build request", e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException realException = (RuntimeException)throwable;
                throw realException;
            }
            throw new RuntimeException("Unable to build request", e);
        }
    }

    protected <T extends RESTResponse> T execute(HTTPRequest httpRequest, Class<T> responseType, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> consumer1) {
        try {
            RESTResponse result = (RESTResponse)this.executeMethod.invoke((Object)this.delegate, httpRequest, responseType, errorHandler, consumer1);
            if (result instanceof LoadTableResponse) {
                LoadTableResponse table = (LoadTableResponse)result;
                LoadTableResponse.Builder tableBuilder = LoadTableResponse.builder().withTableMetadata(table.tableMetadata()).addAllCredentials(table.credentials());
                for (Map.Entry prop : table.config().entrySet()) {
                    if ("org.apache.iceberg.aws.s3.S3FileIO".equals(prop.getValue())) {
                        tableBuilder.addConfig((String)prop.getKey(), S3FileIO.class.getCanonicalName());
                        continue;
                    }
                    if ("org.apache.iceberg.azure.adlsv2.ADLSFileIO".equals(prop.getValue())) {
                        tableBuilder.addConfig((String)prop.getKey(), ADLSFileIO.class.getCanonicalName());
                        continue;
                    }
                    if ("org.apache.iceberg.gcp.gcs.GCSFileIO".equals(prop.getValue())) {
                        tableBuilder.addConfig((String)prop.getKey(), GCSFileIO.class.getCanonicalName());
                        continue;
                    }
                    if ("org.apache.iceberg.io.ResolvingFileIO".equals(prop.getValue())) {
                        tableBuilder.addConfig((String)prop.getKey(), ResolvingFileIO.class.getCanonicalName());
                        continue;
                    }
                    if ("org.apache.iceberg.hadoop.HadoopFileIO".equals(prop.getValue())) {
                        tableBuilder.addConfig((String)prop.getKey(), HadoopFileIO.class.getCanonicalName());
                        continue;
                    }
                    if ("io-impl".equals(prop.getKey())) {
                        DKULogger.getLogger((String)"dip.iceberg.rest").info((Object)"Skip io-impl property");
                        continue;
                    }
                    tableBuilder.addConfig((String)prop.getKey(), (String)prop.getValue());
                }
                return (T)tableBuilder.build();
            }
            return (T)result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to execute request", e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException realException = (RuntimeException)throwable;
                throw realException;
            }
            throw new RuntimeException("Unable to execute request", e);
        }
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

