/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.IStandardDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.utils.FlowExposedObjects;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;

public class FlowZone
extends FlowGraph {
    private List<SerializedDataset> allDatasets;
    private List<SerializedRecipe> allRecipes;
    private List<LabelingTask> allLabelingTasks;
    private List<SavedModel> allSavedModels;
    private List<ModelEvaluationStore> allModelEvaluationStores;
    private List<RetrievableKnowledge> allRetrievableKnowledge;
    private List<ManagedFolder> allManagedFolders;
    private List<StreamingEndpoint> allStreamingEndpoints;
    private final ProjectFlowGraph projectFlowGraph;
    private Zone zone;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;

    public FlowZone(ProjectFlowGraph projectFlowGraph, Zone zone, List<SerializedDataset> allDatasets, List<SerializedRecipe> allRecipes, List<LabelingTask> allLabelingTasks, List<SavedModel> allSavedModels, List<ModelEvaluationStore> allModelEvaluationStores, List<ManagedFolder> allManagedFolders, List<StreamingEndpoint> allStreamingEndpoints, List<RetrievableKnowledge> allRetrievableKnowledge) {
        this.projectFlowGraph = projectFlowGraph;
        this.zone = zone;
        this.allDatasets = allDatasets;
        this.allRecipes = allRecipes;
        this.allLabelingTasks = allLabelingTasks;
        this.allSavedModels = allSavedModels;
        this.allModelEvaluationStores = allModelEvaluationStores;
        this.allManagedFolders = allManagedFolders;
        this.allStreamingEndpoints = allStreamingEndpoints;
        this.allRetrievableKnowledge = allRetrievableKnowledge;
        this.unsafe = projectFlowGraph.unsafe;
    }

    @Override
    public void buildForProject(String projectKey, boolean includeOrphans, boolean drawZones) throws IOException {
        this.iterateAndRemove(this.allRecipes, recipe -> {
            if (recipe.overrideTable != null) {
                recipe = recipe.overrideTable.overrideObject(this.variablesService.getForProject(projectKey), recipe, SerializedRecipe.class);
            }
            try {
                this.addRecipe((SerializedRecipe)recipe);
                this.projectFlowGraph.addRecipe((SerializedRecipe)recipe);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to read recipe " + recipe.name), (Throwable)e);
            }
        });
        this.iterateAndRemove(this.allLabelingTasks, labelingTask -> {
            try {
                this.addLabelingTask((LabelingTask)labelingTask);
                this.projectFlowGraph.addLabelingTask((LabelingTask)labelingTask);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to read labeling task " + labelingTask.name), (Throwable)e);
            }
        });
        this.iterateAndRemove(this.allDatasets, dataset -> {
            try {
                if (includeOrphans) {
                    this.addComputable(dataset.projectKey, dataset.name, ITaggingService.TaggableType.DATASET);
                    this.projectFlowGraph.addComputable(dataset.projectKey, dataset.name, ITaggingService.TaggableType.DATASET);
                }
                this.addImplicitRecipe((SerializedDataset)dataset);
                this.projectFlowGraph.addImplicitRecipe((SerializedDataset)dataset);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to read dataset " + dataset.name), (Throwable)e);
            }
        });
        if (includeOrphans) {
            this.iterateAndRemove(this.allSavedModels, sm -> {
                try {
                    this.addComputable(projectKey, sm.id, ITaggingService.TaggableType.SAVED_MODEL);
                    this.projectFlowGraph.addComputable(projectKey, sm.id, ITaggingService.TaggableType.SAVED_MODEL);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read savedModel " + sm.name), (Throwable)e);
                }
            });
            this.iterateAndRemove(this.allModelEvaluationStores, mes -> {
                try {
                    this.addComputable(projectKey, mes.id, ITaggingService.TaggableType.MODEL_EVALUATION_STORE);
                    this.projectFlowGraph.addComputable(projectKey, mes.id, ITaggingService.TaggableType.MODEL_EVALUATION_STORE);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read modelEvaluationStore " + mes.name), (Throwable)e);
                }
            });
            this.iterateAndRemove(this.allManagedFolders, mf -> {
                try {
                    this.addComputable(projectKey, mf.id, ITaggingService.TaggableType.MANAGED_FOLDER);
                    this.projectFlowGraph.addComputable(projectKey, mf.id, ITaggingService.TaggableType.MANAGED_FOLDER);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read managedFolder " + mf.name), (Throwable)e);
                }
            });
            this.iterateAndRemove(this.allStreamingEndpoints, se -> {
                try {
                    this.addComputable(projectKey, se.id, ITaggingService.TaggableType.STREAMING_ENDPOINT);
                    this.projectFlowGraph.addComputable(projectKey, se.id, ITaggingService.TaggableType.STREAMING_ENDPOINT);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read streaming endpoint " + se.id), (Throwable)e);
                }
            });
            for (SmartObjectRef smRef : this.zone.getShared()) {
                TaggableObjectsService.TaggableObjectRef tor = smRef.toTaggableObjectRef(this.projectFlowGraph.getProjectKey());
                if (!this.taggableObjectsReadService.exists(tor)) {
                    logger.info((Object)String.format("Taggable Object Ref: %s does not exist anymore", tor));
                    continue;
                }
                TaggableObjectsService.TaggableObject taggableObject = this.taggableObjectsReadService.getOrNullUnsafe(tor);
                if (taggableObject == null) {
                    logger.info((Object)String.format("Taggable Object: %s does not exist anymore", taggableObject));
                    continue;
                }
                this.addComputable(taggableObject.getProjectKey(), taggableObject.getId(), taggableObject.getTaggableType());
                this.projectFlowGraph.addComputable(taggableObject.getProjectKey(), taggableObject.getId(), taggableObject.getTaggableType());
            }
            ProjectsService projectsService = (ProjectsService)SpringUtils.getBean(ProjectsService.class);
            FlowExposedObjects allExposedObjects = new FlowExposedObjects(projectsService.getAllExposedObjects(projectKey));
            this.addExposedElements(allExposedObjects.allExposedSavedModels, this.smDAO);
            this.addExposedElements(allExposedObjects.allExposedModelEvaluationStores, this.modelEvaluationStoresDAO);
            this.addExposedElements(allExposedObjects.allExposedManagedFolders, this.odbDAO);
            this.addExposedElements(allExposedObjects.allExposedDatasets, this.datasetsDAO);
            this.addExposedElements(allExposedObjects.allExposedStreamingEndpoints, this.seDAO);
        }
        this.iterateAndRemove(this.allSavedModels, sm -> {
            try {
                this.addSavedModelImplicitRecipes((SavedModel)sm);
                this.projectFlowGraph.addSavedModelImplicitRecipes((SavedModel)sm);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to manage agent dependencies " + sm.id), (Throwable)e);
            }
        });
    }

    private void addExposedElements(List<ProjectsService.AnyLocWithType> elements, IStandardDAO<? extends TaggableObjectsService.TaggableObject> dao) throws IOException {
        for (ProjectsService.AnyLocWithType locToAdd : elements) {
            TaggableObjectsService.TaggableObject to = dao.getOrNullUnsafe(locToAdd);
            if (to == null || !this.includeInZone(to)) continue;
            this.addComputable(to.getProjectKey(), to.getId(), locToAdd.type);
            this.projectFlowGraph.addComputable(to.getProjectKey(), to.getId(), locToAdd.type);
        }
    }

    private <T extends TaggableObjectsService.TaggableObject> void iterateAndRemove(List<T> list, Consumer<T> func) {
        ListIterator<T> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            TaggableObjectsService.TaggableObject obj = (TaggableObjectsService.TaggableObject)listIterator.next();
            if (obj == null) {
                listIterator.remove();
                continue;
            }
            if (!this.includeInZone(obj)) continue;
            func.accept(obj);
            listIterator.remove();
        }
    }

    private boolean includeInZone(TaggableObjectsService.TaggableObject taggableObject) {
        if (!this.zone.getId().equals(Zone.DEFAULT_ZONE.getId())) {
            Zone zone = this.projectFlowGraph.getZone(taggableObject);
            if (zone == null) {
                return false;
            }
            return Objects.equals(zone.getId(), this.getZone().getId());
        }
        return taggableObject != null;
    }

    @Override
    public Map<String, TaggableObjectsService.TaggableObject> getGraphElements() throws IOException {
        Map<String, TaggableObjectsService.TaggableObject> result = super.getGraphElements();
        for (SmartObjectRef smRef : this.zone.getShared()) {
            TaggableObjectsService.TaggableObjectRef tor = smRef.toTaggableObjectRef(this.projectFlowGraph.getProjectKey());
            if (!this.taggableObjectsReadService.exists(tor)) {
                logger.info((Object)String.format("Taggable Object Ref: %s does not exist anymore", tor));
                continue;
            }
            TaggableObjectsService.TaggableObject to = this.unsafe ? this.taggableObjectsReadService.getMandatoryUnsafe(tor) : this.taggableObjectsReadService.getMandatory(tor);
            result.put(this.getID(to), to);
        }
        return result;
    }

    public Zone getZone() {
        return this.zone;
    }

    @Override
    protected String getID(TaggableObjectsService.TaggableObject to) {
        return GraphIds.forZone(this.zone, super.getID(to));
    }
}

