/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.update;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.inline.InlineDatasetConfig;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateRecipeCreator
extends SISORecipeCreator {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private FlowZonesService flowZonesService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.update.creator");

    public UpdateRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        assert (StringUtils.isNotBlank((String)recipe.projectKey));
        assert (this.meta.getType().equals(recipe.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)recipe.name), (Object)"Recipe has no name");
        List<SerializedRecipe.RecipeInput> inputs = recipe.getInputsForRole("main");
        Preconditions.checkArgument((inputs.size() == 1 ? 1 : 0) != 0, (Object)"Push to editable recipes require one intput");
        List<SerializedRecipe.RecipeOutput> outputs = recipe.getOutputsForRole("main");
        Preconditions.checkArgument((outputs.size() == 1 ? 1 : 0) != 0, (Object)"Push to editable recipes require one output");
        SerializedRecipe.RecipeInput input = inputs.get(0);
        SerializedRecipe.RecipeOutput output = outputs.get(0);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            DatasetLocUtils.DatasetLoc inputLoc = DatasetLocUtils.resolveSmart(recipe.projectKey, input.ref);
            Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
            String payload = this.makeInitialPayload(recipe, inputDataset, (Dataset)null, creationData);
            ManagedDatasetsCreationService.ManagedDatasetCreationSettings creationSettings = new ManagedDatasetsCreationService.ManagedDatasetCreationSettings();
            creationSettings.inlineDataset = true;
            Dataset outputDataset = this.mdcService.prepare(this.authCtx, recipe.projectKey, output.ref, creationSettings);
            InlineDatasetConfig config = outputDataset.getParamsAs(InlineDatasetConfig.class);
            config.keepTrackOfChanges = true;
            this.setOutputSchema(recipe, payload, outputDataset);
            try (InlineDatasetHandler dh = (InlineDatasetHandler)DatasetHandlerFactory.build(this.authCtx, outputDataset);){
                dh.initMetadata();
                dh.clearAllData();
            }
            SerializedDataset sds = outputDataset.serialize();
            logger.info((Object)("Creating dataset " + JSON.prettyLog((Object)sds)));
            DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(recipe);
            this.datasetSaveService.create(recipe.projectKey, sds, dsCtx, this.authCtx);
            String recipeZone = creationData.has("zone") ? creationData.get("zone").getAsString() : this.flowZonesService.retrieveInputZone(recipe);
            this.flowZonesService.attachObjectToZone(recipeZone, recipe.projectKey, recipe);
            this.flowZonesService.attachObjectToZone(recipeZone, recipe.projectKey, sds);
            recipe.name = this.recipeSaveService.transmogrifyName(recipe.projectKey, recipe.name);
            new PDepsFixuper().fixupInPlace(recipe);
            this.checkOutputOwnership_T(recipe);
            this.recipeSaveService.create(recipe.projectKey, recipe, payload);
            t.commitV("Creating %s recipe: %s", new Object[]{recipe.getType(), recipe.getFullId()});
            RecipeCreator.CreationResult creationResult = new RecipeCreator.CreationResult().withId(recipe.name);
            return creationResult;
        }
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        ManagedDatasetsHelper.copySchema(this.authCtx, this.getInputDataset(recipe).getSchema(), outputDataset);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        return null;
    }
}

